/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component.helper;

import android.os.Handler;
import android.os.Looper;
import android.support.v7.widget.RecyclerView;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXScroller;
import com.taobao.weex.ui.component.list.BasicListComponent;
import com.taobao.weex.ui.component.list.ListComponentView;
import com.taobao.weex.ui.component.list.template.WXRecyclerTemplateList;
import com.taobao.weex.ui.view.refresh.wrapper.BounceRecyclerView;
import com.taobao.weex.utils.WXUtils;
import java.util.Map;

public class ScrollStartEndHelper
implements Runnable {
    private Handler handler;
    private WXComponent component;
    private boolean hasStart;
    private long minInterval;
    private int x;
    private int y;

    public ScrollStartEndHelper(WXComponent component) {
        this.component = component;
        this.handler = new Handler(Looper.getMainLooper());
        this.minInterval = WXUtils.getNumberInt(component.getDomObject().getAttrs().get("minscrolldelayinterval"), 32);
    }

    public void onScrolled(int x, int y) {
        if (this.component.getDomObject().getEvents().contains("scrollstart") || this.component.getDomObject().getEvents().contains("scrollend")) {
            this.x = x;
            this.y = y;
            if (!this.hasStart) {
                if (this.component.getDomObject().getEvents().contains("scrollstart")) {
                    this.component.fireEvent("scrollstart", this.getScrollEvent(x, y));
                }
                this.hasStart = true;
            }
            this.handler.removeCallbacks((Runnable)this);
            this.handler.postDelayed((Runnable)this, this.minInterval);
        }
    }

    @Override
    public void run() {
        if (this.component.isDestoryed()) {
            return;
        }
        if (this.component.getDomObject().getEvents().contains("scrollend")) {
            this.component.fireEvent("scrollend", this.getScrollEvent(this.x, this.y));
        }
        this.hasStart = false;
    }

    private Map<String, Object> getScrollEvent(int offsetX, int offsetY) {
        if (this.component instanceof BasicListComponent) {
            ListComponentView componentView;
            BasicListComponent basicListComponent = (BasicListComponent)this.component;
            if (basicListComponent.getHostView() instanceof ListComponentView && (componentView = (ListComponentView)basicListComponent.getHostView()) != null) {
                return basicListComponent.getScrollEvent(componentView.getInnerView(), offsetX, offsetY);
            }
        } else {
            if (this.component instanceof WXRecyclerTemplateList) {
                WXRecyclerTemplateList templateList = (WXRecyclerTemplateList)this.component;
                return templateList.getScrollEvent((RecyclerView)((BounceRecyclerView)templateList.getHostView()).getInnerView(), offsetX, offsetY);
            }
            if (this.component instanceof WXScroller) {
                WXScroller scroller = (WXScroller)this.component;
                return scroller.getScrollEvent(offsetX, offsetY);
            }
        }
        return null;
    }

    public static boolean isScrollEvent(String type) {
        if ("scroll".equals(type)) {
            return true;
        }
        if ("scrollstart".equals(type)) {
            return true;
        }
        return "scrollend".equals(type);
    }
}

