/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v4.view.ViewPager;
import android.text.TextUtils;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.annotation.Component;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.dom.WXEvent;
import com.taobao.weex.ui.ComponentCreator;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXIndicator;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.view.WXCircleIndicator;
import com.taobao.weex.ui.view.WXCirclePageAdapter;
import com.taobao.weex.ui.view.WXCircleViewPager;
import com.taobao.weex.ui.view.gesture.WXGestureType;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

@Component(lazyload=false)
public class WXSlider
extends WXVContainer<FrameLayout> {
    public static final String INDEX = "index";
    public static final String INFINITE = "infinite";
    private boolean isInfinite = true;
    Map<String, Object> params = new HashMap<String, Object>();
    private float offsetXAccuracy = 0.1f;
    private int initIndex = -1;
    private boolean keepIndex = false;
    WXCircleViewPager mViewPager;
    protected WXIndicator mIndicator;
    protected WXCirclePageAdapter mAdapter;
    protected boolean mShowIndicators;
    protected ViewPager.OnPageChangeListener mPageChangeListener = new SliderPageChangeListener();

    @Deprecated
    public WXSlider(WXSDKInstance instance, WXDomObject dom, WXVContainer parent, String instanceId, boolean isLazy) {
        this(instance, dom, parent);
    }

    public WXSlider(WXSDKInstance instance, WXDomObject node, WXVContainer parent) {
        super(instance, node, parent);
    }

    @Override
    protected FrameLayout initComponentHostView(@NonNull Context context) {
        FrameLayout view = new FrameLayout(context);
        if (this.getDomObject() != null && this.getDomObject().getAttrs() != null) {
            Object obj = this.getDomObject().getAttrs().get(INFINITE);
            this.isInfinite = WXUtils.getBoolean(obj, true);
        }
        FrameLayout.LayoutParams pagerParams = new FrameLayout.LayoutParams(-1, -1);
        this.mViewPager = new WXCircleViewPager(context);
        this.mViewPager.setCircle(this.isInfinite);
        this.mViewPager.setLayoutParams((ViewGroup.LayoutParams)pagerParams);
        this.mAdapter = new WXCirclePageAdapter(this.isInfinite);
        this.mViewPager.setAdapter(this.mAdapter);
        view.addView((View)this.mViewPager);
        this.mViewPager.addOnPageChangeListener(this.mPageChangeListener);
        this.registerActivityStateListener();
        return view;
    }

    @Override
    public ViewGroup.LayoutParams getChildLayoutParams(WXComponent child, View childView, int width, int height, int left, int right, int top, int bottom) {
        ViewGroup.LayoutParams lp;
        ViewGroup.LayoutParams layoutParams = lp = childView == null ? null : childView.getLayoutParams();
        if (lp == null) {
            lp = new FrameLayout.LayoutParams(width, height);
        } else {
            lp.width = width;
            lp.height = height;
        }
        if (lp instanceof ViewGroup.MarginLayoutParams) {
            if (child instanceof WXIndicator) {
                ((ViewGroup.MarginLayoutParams)lp).setMargins(left, top, right, bottom);
            } else {
                ((ViewGroup.MarginLayoutParams)lp).setMargins(0, 0, 0, 0);
            }
        }
        return lp;
    }

    @Override
    public void addEvent(String type) {
        super.addEvent(type);
        if ("scroll".equals(type)) {
            if (this.mViewPager == null) {
                return;
            }
            this.mViewPager.addOnPageChangeListener(new SliderOnScrollListener(this));
        }
    }

    @Override
    public boolean containsGesture(WXGestureType WXGestureType2) {
        return super.containsGesture(WXGestureType2);
    }

    @Override
    public ViewGroup getRealView() {
        return this.mViewPager;
    }

    @Override
    public void addSubView(View view, int index) {
        if (view == null || this.mAdapter == null) {
            return;
        }
        if (view instanceof WXCircleIndicator) {
            return;
        }
        this.mAdapter.addPageView(view);
        this.hackTwoItemsInfiniteScroll();
        if (this.initIndex != -1 && this.mAdapter.getRealCount() > this.initIndex) {
            this.mViewPager.setCurrentItem(this.initIndex);
            this.initIndex = -1;
        } else if (!this.keepIndex) {
            this.mViewPager.setCurrentItem(0);
        }
        if (this.mIndicator != null) {
            ((WXCircleIndicator)this.mIndicator.getHostView()).forceLayout();
            ((WXCircleIndicator)this.mIndicator.getHostView()).requestLayout();
        }
    }

    @Override
    public void remove(WXComponent child, boolean destroy) {
        if (child == null || child.getHostView() == null || this.mAdapter == null) {
            return;
        }
        this.mAdapter.removePageView((View)child.getHostView());
        this.hackTwoItemsInfiniteScroll();
        super.remove(child, destroy);
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.mViewPager != null) {
            this.mViewPager.stopAutoScroll();
            this.mViewPager.removeAllViews();
            this.mViewPager.destory();
        }
    }

    @Override
    public void onActivityResume() {
        super.onActivityResume();
        if (this.mViewPager != null && this.mViewPager.isAutoScroll()) {
            this.mViewPager.startAutoScroll();
        }
    }

    @Override
    public void onActivityStop() {
        super.onActivityStop();
        if (this.mViewPager != null) {
            this.mViewPager.pauseAutoScroll();
        }
    }

    public void addIndicator(WXIndicator indicator) {
        FrameLayout root = (FrameLayout)this.getHostView();
        if (root == null) {
            return;
        }
        this.mIndicator = indicator;
        WXCircleIndicator indicatorView = (WXCircleIndicator)indicator.getHostView();
        if (indicatorView != null) {
            indicatorView.setCircleViewPager(this.mViewPager);
            root.addView((View)indicatorView);
        }
    }

    @Override
    protected boolean setProperty(String key, Object param) {
        switch (key) {
            case "value": {
                String value = WXUtils.getString(param, null);
                if (value != null) {
                    this.setValue(value);
                }
                return true;
            }
            case "autoPlay": {
                String aotu_play = WXUtils.getString(param, null);
                if (aotu_play != null) {
                    this.setAutoPlay(aotu_play);
                }
                return true;
            }
            case "showIndicators": {
                String indicators = WXUtils.getString(param, null);
                if (indicators != null) {
                    this.setShowIndicators(indicators);
                }
                return true;
            }
            case "interval": {
                Integer interval = WXUtils.getInteger(param, null);
                if (interval != null) {
                    this.setInterval(interval);
                }
                return true;
            }
            case "index": {
                Integer index = WXUtils.getInteger(param, null);
                if (index != null) {
                    this.setIndex(index);
                }
                return true;
            }
            case "offsetXAccuracy": {
                Float accuracy = WXUtils.getFloat(param, Float.valueOf(0.1f));
                if (accuracy.floatValue() != 0.0f) {
                    this.setOffsetXAccuracy(accuracy.floatValue());
                }
                return true;
            }
            case "scrollable": {
                boolean scrollable = WXUtils.getBoolean(param, true);
                this.setScrollable(scrollable);
                return true;
            }
            case "keepIndex": {
                this.keepIndex = WXUtils.getBoolean(param, false);
                return true;
            }
        }
        return super.setProperty(key, param);
    }

    @Deprecated
    @WXComponentProp(name="value")
    public void setValue(String value) {
        int i;
        if (value == null || this.getHostView() == null) {
            return;
        }
        try {
            i = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            WXLogUtils.e("", e);
            return;
        }
        this.setIndex(i);
    }

    @WXComponentProp(name="autoPlay")
    public void setAutoPlay(String autoPlay) {
        if (TextUtils.isEmpty((CharSequence)autoPlay) || autoPlay.equals("false")) {
            this.mViewPager.stopAutoScroll();
        } else {
            this.mViewPager.stopAutoScroll();
            this.mViewPager.startAutoScroll();
        }
    }

    @WXComponentProp(name="showIndicators")
    public void setShowIndicators(String show) {
        this.mShowIndicators = !TextUtils.isEmpty((CharSequence)show) && !show.equals("false");
        if (this.mIndicator == null) {
            return;
        }
        this.mIndicator.setShowIndicators(this.mShowIndicators);
    }

    @WXComponentProp(name="interval")
    public void setInterval(int intervalMS) {
        if (this.mViewPager != null && intervalMS > 0) {
            this.mViewPager.setIntervalTime(intervalMS);
        }
    }

    @WXComponentProp(name="index")
    public void setIndex(int index) {
        if (this.mViewPager != null && this.mAdapter != null) {
            if (index >= this.mAdapter.getRealCount() || index < 0) {
                this.initIndex = index;
                return;
            }
            this.mViewPager.setCurrentItem(index);
            if (this.mIndicator != null && this.mIndicator.getHostView() != null && ((WXCircleIndicator)this.mIndicator.getHostView()).getRealCurrentItem() != index) {
                WXLogUtils.d("setIndex >>>> correction indicator to " + index);
                ((WXCircleIndicator)this.mIndicator.getHostView()).setRealCurrentItem(index);
                ((WXCircleIndicator)this.mIndicator.getHostView()).invalidate();
                if (this.mPageChangeListener != null && this.mAdapter != null) {
                    this.mPageChangeListener.onPageSelected(this.mAdapter.getFirst() + index);
                }
            }
        }
    }

    @WXComponentProp(name="scrollable")
    public void setScrollable(boolean scrollable) {
        if (this.mViewPager != null && this.mAdapter != null && this.mAdapter.getRealCount() > 0) {
            this.mViewPager.setScrollable(scrollable);
        }
    }

    @WXComponentProp(name="offsetXAccuracy")
    public void setOffsetXAccuracy(float accuracy) {
        this.offsetXAccuracy = accuracy;
    }

    private void hackTwoItemsInfiniteScroll() {
        if (this.mViewPager == null || this.mAdapter == null) {
            return;
        }
        if (this.isInfinite) {
            if (this.mAdapter.getRealCount() == 2) {
                final GestureDetector gestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new FlingGestureListener(this.mViewPager));
                this.mViewPager.setOnTouchListener(new View.OnTouchListener(){

                    public boolean onTouch(View v, MotionEvent event) {
                        return gestureDetector.onTouchEvent(event);
                    }
                });
            } else {
                this.mViewPager.setOnTouchListener(null);
            }
        }
    }

    private static class FlingGestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private static final int SWIPE_MIN_DISTANCE = WXViewUtils.dip2px(50.0f);
        private static final int SWIPE_MAX_OFF_PATH = WXViewUtils.dip2px(250.0f);
        private static final int SWIPE_THRESHOLD_VELOCITY = WXViewUtils.dip2px(200.0f);
        private WeakReference<WXCircleViewPager> pagerRef;

        FlingGestureListener(WXCircleViewPager pager) {
            this.pagerRef = new WeakReference<WXCircleViewPager>(pager);
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            WXCircleViewPager mViewPager = (WXCircleViewPager)this.pagerRef.get();
            if (mViewPager == null) {
                return false;
            }
            try {
                if (Math.abs(e1.getY() - e2.getY()) > (float)SWIPE_MAX_OFF_PATH) {
                    return false;
                }
                if (e1.getX() - e2.getX() > (float)SWIPE_MIN_DISTANCE && Math.abs(velocityX) > (float)SWIPE_THRESHOLD_VELOCITY && mViewPager.superGetCurrentItem() == 1) {
                    mViewPager.setCurrentItem(0, false);
                    return true;
                }
                if (e2.getX() - e1.getX() > (float)SWIPE_MIN_DISTANCE && Math.abs(velocityX) > (float)SWIPE_THRESHOLD_VELOCITY && mViewPager.superGetCurrentItem() == 0) {
                    mViewPager.setCurrentItem(1, false);
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
    }

    protected static class SliderOnScrollListener
    implements ViewPager.OnPageChangeListener {
        private float lastPositionOffset = 99.0f;
        private int selectedPosition;
        private WXSlider target;

        public SliderOnScrollListener(WXSlider target) {
            this.target = target;
            this.selectedPosition = target.mViewPager.superGetCurrentItem();
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            if (this.lastPositionOffset == 99.0f) {
                this.lastPositionOffset = positionOffset;
                return;
            }
            float offset = positionOffset - this.lastPositionOffset;
            if (Math.abs(offset) >= this.target.offsetXAccuracy) {
                if (position == this.selectedPosition) {
                    HashMap<String, Object> event = new HashMap<String, Object>(1);
                    event.put("offsetXRatio", Float.valueOf(-positionOffset));
                    this.target.fireEvent("scroll", event);
                } else if (position < this.selectedPosition) {
                    HashMap<String, Object> event = new HashMap<String, Object>(1);
                    event.put("offsetXRatio", Float.valueOf(1.0f - positionOffset));
                    this.target.fireEvent("scroll", event);
                }
                this.lastPositionOffset = positionOffset;
            }
        }

        public void onPageSelected(int position) {
            this.selectedPosition = position;
        }

        public void onPageScrollStateChanged(int state) {
            switch (state) {
                case 0: {
                    this.lastPositionOffset = 99.0f;
                    this.target.fireEvent("scrollend");
                    break;
                }
                case 1: {
                    this.target.fireEvent("scrollstart");
                    break;
                }
            }
        }
    }

    protected class SliderPageChangeListener
    implements ViewPager.OnPageChangeListener {
        private int lastPos = -1;

        protected SliderPageChangeListener() {
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        }

        public void onPageSelected(int pos) {
            if (WXSlider.this.mAdapter.getRealPosition(pos) == this.lastPos) {
                return;
            }
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.d("onPageSelected >>>>" + WXSlider.this.mAdapter.getRealPosition(pos) + " lastPos: " + this.lastPos);
            }
            if (WXSlider.this.mAdapter == null || WXSlider.this.mAdapter.getRealCount() == 0) {
                return;
            }
            int realPosition = WXSlider.this.mAdapter.getRealPosition(pos);
            if (WXSlider.this.mChildren == null || realPosition >= WXSlider.this.mChildren.size()) {
                return;
            }
            if (WXSlider.this.getDomObject().getEvents().size() == 0) {
                return;
            }
            WXEvent event = WXSlider.this.getDomObject().getEvents();
            String ref = WXSlider.this.getDomObject().getRef();
            if (event.contains("change") && WXViewUtils.onScreenArea(WXSlider.this.getHostView())) {
                WXSlider.this.params.put(WXSlider.INDEX, realPosition);
                HashMap<String, Object> domChanges = new HashMap<String, Object>();
                HashMap<String, Integer> attrsChanges = new HashMap<String, Integer>();
                attrsChanges.put(WXSlider.INDEX, realPosition);
                domChanges.put("attrs", attrsChanges);
                WXSDKManager.getInstance().fireEvent(WXSlider.this.getInstanceId(), ref, "change", WXSlider.this.params, domChanges);
            }
            WXSlider.this.mViewPager.requestLayout();
            ((FrameLayout)WXSlider.this.getHostView()).invalidate();
            this.lastPos = WXSlider.this.mAdapter.getRealPosition(pos);
        }

        public void onPageScrollStateChanged(int arg0) {
            FrameLayout root = (FrameLayout)WXSlider.this.getHostView();
            if (null != root) {
                root.invalidate();
            }
        }
    }

    public static class Creator
    implements ComponentCreator {
        @Override
        public WXComponent createInstance(WXSDKInstance instance, WXDomObject node, WXVContainer parent) throws IllegalAccessException, InvocationTargetException, InstantiationException {
            return new WXSlider(instance, node, parent);
        }
    }
}

