/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.dom.action;

import android.widget.ScrollView;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.common.WXErrorCode;
import com.taobao.weex.common.WXRenderStrategy;
import com.taobao.weex.dom.DOMActionContext;
import com.taobao.weex.dom.RenderActionContext;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.dom.action.AbstractAddElementAction;
import com.taobao.weex.tracing.Stopwatch;
import com.taobao.weex.tracing.WXTracing;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXScroller;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXViewUtils;

class CreateBodyAction
extends AbstractAddElementAction {
    private final JSONObject mData;
    private StringBuilder mErrMsg = new StringBuilder("CreateBodyAction Error:");

    CreateBodyAction(JSONObject data) {
        this.mData = data;
    }

    @Override
    public void executeDom(DOMActionContext context) {
        if (WXTracing.isAvailable() && context != null && context.getInstance() != null) {
            WXTracing.TraceEvent execJsEndEvent = WXTracing.newEvent("executeBundleJS", context.getInstanceId(), -1);
            execJsEndEvent.traceId = context.getInstance().mExecJSTraceId;
            execJsEndEvent.ph = "E";
            execJsEndEvent.submit();
        }
        this.addDomInternal(context, this.mData);
    }

    @Override
    protected WXComponent createComponent(DOMActionContext context, WXDomObject domObject) {
        return this.generateComponentTree(context, domObject, null);
    }

    @Override
    protected void appendDomToTree(DOMActionContext context, WXDomObject domObject) {
        long startNanos = System.nanoTime();
        String instanceId = context.getInstanceId();
        WXDomObject.prepareRoot(domObject, WXViewUtils.getWebPxByWidth(WXViewUtils.getWeexHeight(instanceId), WXSDKManager.getInstanceViewPortWidth(instanceId)), WXViewUtils.getWebPxByWidth(WXViewUtils.getWeexWidth(instanceId), WXSDKManager.getInstanceViewPortWidth(instanceId)));
        domObject.mDomThreadNanos += System.nanoTime() - startNanos;
    }

    @Override
    protected WXErrorCode getErrorCode() {
        return WXErrorCode.WX_KEY_EXCEPTION_DOM_CREATE_BODY;
    }

    @Override
    protected String getErrorMsg() {
        return this.mErrMsg.toString();
    }

    @Override
    protected String getStatementName() {
        return "createBody";
    }

    @Override
    public void executeRender(RenderActionContext context) {
        WXComponent component = context.getComponent("_root");
        WXSDKInstance instance = context.getInstance();
        if (instance == null || instance.getContext() == null) {
            WXLogUtils.e("instance is null or instance is destroy!");
            this.mErrMsg.append("instance is null or instance is destroy!");
            return;
        }
        try {
            WXScroller scroller;
            Stopwatch.tick();
            long start = System.currentTimeMillis();
            component.createView();
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.renderPerformanceLog("createView", System.currentTimeMillis() - start);
                this.submitPerformance("createView", "X", instance.getInstanceId(), Stopwatch.tackAndTick(), start, true);
            }
            start = System.currentTimeMillis();
            component.applyLayoutAndEvent(component);
            if (WXTracing.isAvailable()) {
                this.submitPerformance("applyLayoutAndEvent", "X", instance.getInstanceId(), Stopwatch.tackAndTick(), start, true);
            }
            start = System.currentTimeMillis();
            component.bindData(component);
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.renderPerformanceLog("bind", System.currentTimeMillis() - start);
                this.submitPerformance("bindData", "X", instance.getInstanceId(), Stopwatch.tack(), start, true);
            }
            if (component instanceof WXScroller && (scroller = (WXScroller)component).getInnerView() instanceof ScrollView) {
                instance.setRootScrollView((ScrollView)scroller.getInnerView());
            }
            instance.onRootCreated(component);
            if (instance.getRenderStrategy() != WXRenderStrategy.APPEND_ONCE) {
                instance.onCreateFinish();
            }
            component.mTraceInfo.uiQueueTime = this.mUIQueueTime;
            component.onRenderFinish(2);
        }
        catch (Exception e) {
            WXLogUtils.e("create body failed.", e);
            this.mErrMsg.append("create body failed.").append(WXLogUtils.getStackTrace(e)).toString();
        }
    }
}

