/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.dom.action;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ArgbEvaluator;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.graphics.drawable.ColorDrawable;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.view.animation.PathInterpolatorCompat;
import android.text.TextUtils;
import android.util.Pair;
import android.util.Property;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.common.WXErrorCode;
import com.taobao.weex.dom.DOMAction;
import com.taobao.weex.dom.DOMActionContext;
import com.taobao.weex.dom.RenderAction;
import com.taobao.weex.dom.RenderActionContext;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.ui.animation.BackgroundColorProperty;
import com.taobao.weex.ui.animation.HeightProperty;
import com.taobao.weex.ui.animation.WXAnimationBean;
import com.taobao.weex.ui.animation.WXAnimationModule;
import com.taobao.weex.ui.animation.WidthProperty;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.view.border.BorderDrawable;
import com.taobao.weex.utils.SingleFunctionParser;
import com.taobao.weex.utils.WXExceptionUtils;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXResourceUtils;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.util.HashMap;
import java.util.List;

class AnimationAction
implements DOMAction,
RenderAction {
    private static final String TAG = "AnimationAction";
    @NonNull
    private final String ref;
    @Nullable
    private final String animation;
    @Nullable
    private final String callback;
    @Nullable
    private WXAnimationBean mAnimationBean;

    AnimationAction(@NonNull String ref, @Nullable String animation, @Nullable String callBack) {
        this.ref = ref;
        this.animation = animation;
        this.callback = callBack;
    }

    AnimationAction(@NonNull String ref, @NonNull WXAnimationBean animationBean) {
        this(ref, animationBean, null);
    }

    AnimationAction(@NonNull String ref, @NonNull WXAnimationBean animationBean, @Nullable String callBack) {
        this.ref = ref;
        this.mAnimationBean = animationBean;
        this.callback = callBack;
        this.animation = null;
    }

    @Override
    public void executeDom(DOMActionContext context) {
        try {
            WXAnimationBean animationBean;
            WXDomObject domObject;
            if (!context.isDestory() && !TextUtils.isEmpty((CharSequence)this.animation) && (domObject = context.getDomByRef(this.ref)) != null && (animationBean = (WXAnimationBean)JSONObject.parseObject((String)this.animation, WXAnimationBean.class)) != null && animationBean.styles != null) {
                int width = (int)domObject.getLayoutWidth();
                int height = (int)domObject.getLayoutHeight();
                animationBean.styles.init(animationBean.styles.transformOrigin, animationBean.styles.transform, width, height, context.getInstance().getInstanceViewPortWidth());
                this.mAnimationBean = animationBean;
                context.postRenderTask(this);
            }
        }
        catch (RuntimeException e) {
            WXExceptionUtils.commitCriticalExceptionRT(context.getInstance().getInstanceId(), WXErrorCode.WX_KEY_EXCEPTION_DOM_ANIMATION.getErrorCode(), "animationAction", WXErrorCode.WX_KEY_EXCEPTION_DOM_ANIMATION.getErrorMsg() + WXLogUtils.getStackTrace(e), null);
            WXLogUtils.e(TAG, WXLogUtils.getStackTrace(e));
        }
    }

    @Override
    public void executeRender(RenderActionContext context) {
        WXSDKInstance instance;
        if (this.mAnimationBean != null && (instance = context.getInstance()) != null) {
            this.startAnimation(instance, context.getComponent(this.ref));
        }
    }

    private void startAnimation(@NonNull WXSDKInstance instance, @Nullable WXComponent component) {
        if (component != null) {
            if (this.mAnimationBean != null) {
                component.setNeedLayoutOnAnimation(this.mAnimationBean.needLayout);
            }
            if (component.getHostView() == null) {
                WXAnimationModule.AnimationHolder holder = new WXAnimationModule.AnimationHolder(this.mAnimationBean, this.callback);
                component.postAnimation(holder);
            } else {
                try {
                    ObjectAnimator animator = this.createAnimator((View)component.getHostView(), instance.getInstanceViewPortWidth());
                    if (animator != null) {
                        Animator.AnimatorListener animatorCallback = this.createAnimatorListener(instance, this.callback);
                        if (Build.VERSION.SDK_INT < 18 && component.isLayerTypeEnabled()) {
                            component.getHostView().setLayerType(2, null);
                        }
                        Interpolator interpolator = this.createTimeInterpolator();
                        if (animatorCallback != null) {
                            animator.addListener(animatorCallback);
                        }
                        if (interpolator != null) {
                            animator.setInterpolator((TimeInterpolator)interpolator);
                        }
                        component.getHostView().setCameraDistance(this.mAnimationBean.styles.getCameraDistance());
                        animator.setDuration(this.mAnimationBean.duration);
                        animator.start();
                    }
                }
                catch (RuntimeException e) {
                    WXExceptionUtils.commitCriticalExceptionRT(instance.getInstanceId(), WXErrorCode.WX_KEY_EXCEPTION_DOM_ANIMATION.getErrorCode(), "animationAction", WXErrorCode.WX_KEY_EXCEPTION_DOM_ANIMATION.getErrorMsg() + WXLogUtils.getStackTrace(e), null);
                    WXLogUtils.e(TAG, WXLogUtils.getStackTrace(e));
                }
            }
        }
    }

    @Nullable
    private ObjectAnimator createAnimator(View target, int viewPortWidth) {
        if (target == null) {
            return null;
        }
        WXAnimationBean.Style style = this.mAnimationBean.styles;
        if (style != null) {
            List<PropertyValuesHolder> holders = style.getHolders();
            if (!TextUtils.isEmpty((CharSequence)style.backgroundColor)) {
                BorderDrawable borderDrawable = WXViewUtils.getBorderDrawable(target);
                if (borderDrawable != null) {
                    holders.add(PropertyValuesHolder.ofObject((Property)new BackgroundColorProperty(), (TypeEvaluator)new ArgbEvaluator(), (Object[])new Integer[]{borderDrawable.getColor(), WXResourceUtils.getColor(style.backgroundColor)}));
                } else if (target.getBackground() instanceof ColorDrawable) {
                    holders.add(PropertyValuesHolder.ofObject((Property)new BackgroundColorProperty(), (TypeEvaluator)new ArgbEvaluator(), (Object[])new Integer[]{((ColorDrawable)target.getBackground()).getColor(), WXResourceUtils.getColor(style.backgroundColor)}));
                }
            }
            if (!(target.getLayoutParams() == null || TextUtils.isEmpty((CharSequence)style.width) && TextUtils.isEmpty((CharSequence)style.height))) {
                ViewGroup.LayoutParams layoutParams = target.getLayoutParams();
                if (!TextUtils.isEmpty((CharSequence)style.width)) {
                    holders.add(PropertyValuesHolder.ofInt((Property)new WidthProperty(), (int[])new int[]{layoutParams.width, (int)WXViewUtils.getRealPxByWidth(WXUtils.getFloat(style.width), viewPortWidth)}));
                }
                if (!TextUtils.isEmpty((CharSequence)style.height)) {
                    holders.add(PropertyValuesHolder.ofInt((Property)new HeightProperty(), (int[])new int[]{layoutParams.height, (int)WXViewUtils.getRealPxByWidth(WXUtils.getFloat(style.height), viewPortWidth)}));
                }
            }
            if (style.getPivot() != null) {
                Pair<Float, Float> pair = style.getPivot();
                target.setPivotX(((Float)pair.first).floatValue());
                target.setPivotY(((Float)pair.second).floatValue());
            }
            ObjectAnimator animator = ObjectAnimator.ofPropertyValuesHolder((Object)target, (PropertyValuesHolder[])holders.toArray(new PropertyValuesHolder[holders.size()]));
            animator.setStartDelay(this.mAnimationBean.delay);
            return animator;
        }
        return null;
    }

    @Nullable
    private Animator.AnimatorListener createAnimatorListener(final WXSDKInstance instance, final @Nullable String callBack) {
        if (!TextUtils.isEmpty((CharSequence)callBack)) {
            return new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    if (instance == null || instance.isDestroy()) {
                        WXLogUtils.e("RenderActionContextImpl-onAnimationEnd WXSDKInstance == null NPE or instance is destroyed");
                    } else {
                        WXSDKManager.getInstance().callback(instance.getInstanceId(), callBack, new HashMap<String, Object>());
                    }
                }
            };
        }
        return null;
    }

    @Nullable
    private Interpolator createTimeInterpolator() {
        String interpolator = this.mAnimationBean.timingFunction;
        if (!TextUtils.isEmpty((CharSequence)interpolator)) {
            switch (interpolator) {
                case "ease-in": {
                    return PathInterpolatorCompat.create((float)0.42f, (float)0.0f, (float)1.0f, (float)1.0f);
                }
                case "ease-out": {
                    return PathInterpolatorCompat.create((float)0.0f, (float)0.0f, (float)0.58f, (float)1.0f);
                }
                case "ease-in-out": {
                    return PathInterpolatorCompat.create((float)0.42f, (float)0.0f, (float)0.58f, (float)1.0f);
                }
                case "ease": {
                    return PathInterpolatorCompat.create((float)0.25f, (float)0.1f, (float)0.25f, (float)1.0f);
                }
                case "linear": {
                    return PathInterpolatorCompat.create((float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
                }
            }
            try {
                SingleFunctionParser<Float> parser = new SingleFunctionParser<Float>(this.mAnimationBean.timingFunction, new SingleFunctionParser.FlatMapper<Float>(){

                    @Override
                    public Float map(String raw) {
                        return Float.valueOf(Float.parseFloat(raw));
                    }
                });
                List<Float> params = parser.parse("cubic-bezier");
                if (params != null && params.size() == 4) {
                    return PathInterpolatorCompat.create((float)params.get(0).floatValue(), (float)params.get(1).floatValue(), (float)params.get(2).floatValue(), (float)params.get(3).floatValue());
                }
                return null;
            }
            catch (RuntimeException e) {
                return null;
            }
        }
        return null;
    }
}

