/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component.list;

import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.RestrictTo;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.annotation.Component;
import com.taobao.weex.dom.WXAttr;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.flat.WidgetContainer;
import com.taobao.weex.ui.view.WXFrameLayout;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;

@Component(lazyload=false)
public class WXCell
extends WidgetContainer<WXFrameLayout> {
    private int mLastLocationY = 0;
    private ViewGroup mRealView;
    private View mTempStickyView;
    private View mHeadView;
    private int mScrollPositon = -1;
    private boolean mFlatUIEnabled = false;
    private Object renderData;
    private boolean isSourceUsed = false;

    @Deprecated
    public WXCell(WXSDKInstance instance, WXDomObject dom, WXVContainer parent, String instanceId, boolean isLazy) {
        super(instance, dom, parent);
        this.lazy(true);
    }

    public WXCell(WXSDKInstance instance, WXDomObject dom, WXVContainer parent, boolean isLazy) {
        super(instance, dom, parent);
        this.lazy(true);
        if (Build.VERSION.SDK_INT < 21) {
            try {
                WXAttr attr = this.getDomObject().getAttrs();
                if (attr.containsKey("flat")) {
                    this.mFlatUIEnabled = WXUtils.getBoolean(attr.get("flat"), false);
                }
            }
            catch (NullPointerException e) {
                WXLogUtils.e("Cell", WXLogUtils.getStackTrace(e));
            }
        }
    }

    @Override
    public boolean isLazy() {
        return super.isLazy() && !this.isFixed();
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public boolean isFlatUIEnabled() {
        return this.mFlatUIEnabled;
    }

    @Override
    protected WXFrameLayout initComponentHostView(@NonNull Context context) {
        if (this.isSticky()) {
            WXFrameLayout view = new WXFrameLayout(context);
            this.mRealView = new WXFrameLayout(context);
            view.addView((View)this.mRealView);
            if (this.isFlatUIEnabled()) {
                view.setLayerType(2, null);
            }
            return view;
        }
        WXFrameLayout view = new WXFrameLayout(context);
        this.mRealView = view;
        if (this.isFlatUIEnabled()) {
            view.setLayerType(2, null);
        }
        return view;
    }

    public int getLocationFromStart() {
        return this.mLastLocationY;
    }

    public void setLocationFromStart(int l) {
        this.mLastLocationY = l;
    }

    public void setScrollPositon(int pos) {
        this.mScrollPositon = pos;
    }

    public int getScrollPositon() {
        return this.mScrollPositon;
    }

    @Override
    public ViewGroup getRealView() {
        return this.mRealView;
    }

    public void removeSticky() {
        if (((WXFrameLayout)this.getHostView()).getChildCount() > 0) {
            this.mHeadView = ((WXFrameLayout)this.getHostView()).getChildAt(0);
            int[] location = new int[2];
            int[] parentLocation = new int[2];
            ((WXFrameLayout)this.getHostView()).getLocationOnScreen(location);
            this.getParentScroller().getView().getLocationOnScreen(parentLocation);
            int headerViewOffsetX = location[0] - parentLocation[0];
            int headerViewOffsetY = this.getParent().getHostView().getTop();
            ((WXFrameLayout)this.getHostView()).removeView(this.mHeadView);
            this.mRealView = (ViewGroup)this.mHeadView;
            this.mTempStickyView = new FrameLayout(this.getContext());
            FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams((int)this.getDomObject().getLayoutWidth(), (int)this.getDomObject().getLayoutHeight());
            ((WXFrameLayout)this.getHostView()).addView(this.mTempStickyView, (ViewGroup.LayoutParams)lp);
            this.mHeadView.setTranslationX((float)headerViewOffsetX);
            this.mHeadView.setTranslationY((float)headerViewOffsetY);
        }
    }

    public void recoverySticky() {
        if (this.mHeadView != null) {
            if (this.mHeadView.getLayoutParams() != null) {
                ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)this.mHeadView.getLayoutParams();
                if (params.topMargin > 0) {
                    params.topMargin = 0;
                }
            }
            if (this.mHeadView.getVisibility() != 0) {
                this.mHeadView.setVisibility(0);
            }
            if (this.mHeadView.getParent() != null) {
                ((ViewGroup)this.mHeadView.getParent()).removeView(this.mHeadView);
            }
            if (this.getHostView() != null) {
                ((WXFrameLayout)this.getHostView()).removeView(this.mTempStickyView);
                ((WXFrameLayout)this.getHostView()).addView(this.mHeadView);
            }
            this.mHeadView.setTranslationX(0.0f);
            this.mHeadView.setTranslationY(0.0f);
        }
    }

    @Override
    protected void mountFlatGUI() {
        if (this.getHostView() != null) {
            ((WXFrameLayout)this.getHostView()).mountFlatGUI(this.widgets);
        }
    }

    @Override
    public void unmountFlatGUI() {
        if (this.getHostView() != null) {
            ((WXFrameLayout)this.getHostView()).unmountFlatGUI();
        }
    }

    @Override
    public boolean intendToBeFlatContainer() {
        return this.getInstance().getFlatUIContext().isFlatUIEnabled(this) && WXCell.class.equals(this.getClass()) && !this.isSticky();
    }

    @Override
    public int getStickyOffset() {
        if (this.getDomObject() == null) {
            return 0;
        }
        WXDomObject domObject = (WXDomObject)this.getDomObject();
        if (domObject.getAttrs().get("stickyOffset") == null) {
            return 0;
        }
        float offset = WXUtils.getFloat(domObject.getAttrs().get("stickyOffset"));
        return (int)WXViewUtils.getRealPxByWidth(offset, domObject.getViewPortWidth());
    }

    public Object getRenderData() {
        return this.renderData;
    }

    public void setRenderData(Object renderData) {
        this.renderData = renderData;
    }

    public boolean isSourceUsed() {
        return this.isSourceUsed;
    }

    public void setSourceUsed(boolean sourceUsed) {
        this.isSourceUsed = sourceUsed;
    }
}

