/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component.binding;

import android.os.AsyncTask;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.dom.flex.CSSLayoutContext;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.component.list.template.TemplateViewHolder;
import com.taobao.weex.utils.WXLogUtils;

public class Layouts {
    public static void doLayoutAsync(final TemplateViewHolder templateViewHolder, boolean async) {
        final WXComponent component = templateViewHolder.getComponent();
        final int position = templateViewHolder.getHolderPosition();
        if (templateViewHolder.asyncTask != null) {
            templateViewHolder.asyncTask.cancel(false);
            templateViewHolder.asyncTask = null;
        }
        if (async) {
            AsyncTask<Void, Void, Void> asyncTask;
            templateViewHolder.asyncTask = asyncTask = new AsyncTask<Void, Void, Void>(){

                protected Void doInBackground(Void ... params) {
                    if (templateViewHolder.getHolderPosition() == position && component.getInstance() != null && !component.getInstance().isDestroy()) {
                        Layouts.doSafeLayout(component, templateViewHolder.getLayoutContext());
                    }
                    return null;
                }

                protected void onPostExecute(Void aVoid) {
                    if (position == templateViewHolder.getHolderPosition() && component.getInstance() != null && !component.getInstance().isDestroy()) {
                        Layouts.setLayout(component, false);
                    }
                }
            };
            asyncTask.executeOnExecutor(AsyncTask.SERIAL_EXECUTOR, (Object[])new Void[0]);
        } else {
            Layouts.doSafeLayout(component, templateViewHolder.getLayoutContext());
            Layouts.setLayout(component, false);
        }
    }

    public static void doSafeLayout(WXComponent component, CSSLayoutContext layoutContext) {
        block4: {
            try {
                long start = System.currentTimeMillis();
                Layouts.doLayout(component, layoutContext);
                if (WXEnvironment.isOpenDebugLog()) {
                    // empty if block
                }
                if (!(component.getLayoutHeight() > 0.0f)) {
                    WXLogUtils.e("WXRecyclerTemplateList", " WXTemplateList doSafeLayout wrong template " + component.getDomObject().getAttrs().get("case") + " cell height " + component.getLayoutHeight());
                }
            }
            catch (Exception e) {
                if (!WXEnvironment.isApkDebugable()) break block4;
                WXLogUtils.e("WXRecyclerTemplateList", e);
            }
        }
    }

    private static void doLayout(WXComponent component, CSSLayoutContext layoutContext) {
        WXDomObject domObject = (WXDomObject)component.getDomObject();
        final WXSDKInstance instance = component.getInstance();
        domObject.traverseUpdateTree(new WXDomObject.Consumer(){

            @Override
            public void accept(WXDomObject dom) {
                if (instance == null || instance.isDestroy()) {
                    return;
                }
                if (!dom.hasUpdate()) {
                    return;
                }
                if (!dom.isShow()) {
                    return;
                }
                dom.layoutBefore();
            }
        });
        if (instance != null && !instance.isDestroy()) {
            domObject.calculateLayout(layoutContext);
        }
        domObject.traverseUpdateTree(new WXDomObject.Consumer(){

            @Override
            public void accept(WXDomObject dom) {
                if (instance == null || instance.isDestroy()) {
                    return;
                }
                if (!dom.isShow()) {
                    return;
                }
                if (dom.hasUpdate()) {
                    dom.layoutAfter();
                }
            }
        });
    }

    public static final void setLayout(WXComponent component, boolean force) {
        if (component.isWaste()) {
            return;
        }
        WXDomObject domObject = (WXDomObject)component.getDomObject();
        if (domObject.hasUpdate() || force) {
            domObject.markUpdateSeen();
            if (domObject.hasUpdate()) {
                domObject.markLayoutStateUpdated();
            }
            component.setLayout(component.getDomObject());
            if (component.getDomObject().getExtra() != null) {
                component.updateExtra(component.getDomObject().getExtra());
            }
        }
        if (component instanceof WXVContainer) {
            WXVContainer container = (WXVContainer)component;
            int count = container.getChildCount();
            for (int i = 0; i < count; ++i) {
                WXComponent child = container.getChild(i);
                if (child == null) continue;
                Layouts.setLayout(child, force);
            }
        }
    }

    private static final void setLayoutWaste(WXComponent component, boolean force) {
        WXDomObject domObject = (WXDomObject)component.getDomObject();
        if (domObject.hasUpdate() || force) {
            domObject.markUpdateSeen();
            if (domObject.hasUpdate()) {
                domObject.markLayoutStateUpdated();
            }
        }
        if (component instanceof WXVContainer) {
            WXVContainer container = (WXVContainer)component;
            int count = container.getChildCount();
            for (int i = 0; i < count; ++i) {
                WXComponent child = container.getChild(i);
                if (child == null) continue;
                Layouts.setLayoutWaste(child, force);
            }
        }
    }
}

