/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import android.content.Context;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.View;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.annotation.Component;
import com.taobao.weex.annotation.JSMethod;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.view.IWebView;
import com.taobao.weex.ui.view.WXWebView;
import com.taobao.weex.utils.WXUtils;
import java.util.HashMap;
import java.util.Map;

@Component(lazyload=false)
public class WXWeb
extends WXComponent {
    public static final String GO_BACK = "goBack";
    public static final String GO_FORWARD = "goForward";
    public static final String RELOAD = "reload";
    public static final String POST_MESSAGE = "postMessage";
    protected IWebView mWebView;

    @Deprecated
    public WXWeb(WXSDKInstance instance, WXDomObject dom, WXVContainer parent, String instanceId, boolean isLazy) {
        this(instance, dom, parent, isLazy);
    }

    public WXWeb(WXSDKInstance instance, WXDomObject dom, WXVContainer parent, boolean isLazy) {
        super(instance, dom, parent, isLazy);
        this.createWebView();
    }

    protected void createWebView() {
        String origin = null;
        try {
            String bundleUrl = WXSDKManager.getInstance().getSDKInstance(this.getInstanceId()).getBundleUrl();
            Uri uri = Uri.parse((String)bundleUrl);
            String scheme = uri.getScheme();
            String authority = uri.getAuthority();
            if (!TextUtils.isEmpty((CharSequence)scheme) && !TextUtils.isEmpty((CharSequence)authority)) {
                origin = scheme + "://" + authority;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mWebView = new WXWebView(this.getContext(), origin);
    }

    protected View initComponentHostView(@NonNull Context context) {
        this.mWebView.setOnErrorListener(new IWebView.OnErrorListener(){

            @Override
            public void onError(String type, Object message) {
                WXWeb.this.fireEvent(type, message);
            }
        });
        this.mWebView.setOnPageListener(new IWebView.OnPageListener(){

            @Override
            public void onReceivedTitle(String title) {
                if (WXWeb.this.getDomObject().getEvents().contains("receivedtitle")) {
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("title", title);
                    WXWeb.this.fireEvent("receivedtitle", params);
                }
            }

            @Override
            public void onPageStart(String url) {
                if (WXWeb.this.getDomObject().getEvents().contains("pagestart")) {
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("url", url);
                    WXWeb.this.fireEvent("pagestart", params);
                }
            }

            @Override
            public void onPageFinish(String url, boolean canGoBack, boolean canGoForward) {
                if (WXWeb.this.getDomObject().getEvents().contains("pagefinish")) {
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("url", url);
                    params.put("canGoBack", canGoBack);
                    params.put("canGoForward", canGoForward);
                    WXWeb.this.fireEvent("pagefinish", params);
                }
            }
        });
        this.mWebView.setOnMessageListener(new IWebView.OnMessageListener(){

            @Override
            public void onMessage(Map<String, Object> params) {
                WXWeb.this.fireEvent("message", params);
            }
        });
        return this.mWebView.getView();
    }

    @Override
    public void destroy() {
        super.destroy();
        this.getWebView().destroy();
    }

    @Override
    protected boolean setProperty(String key, Object param) {
        switch (key) {
            case "show-loading": {
                Boolean result = WXUtils.getBoolean(param, null);
                if (result != null) {
                    this.setShowLoading(result);
                }
                return true;
            }
            case "src": {
                String src = WXUtils.getString(param, null);
                if (src != null) {
                    this.setUrl(src);
                }
                return true;
            }
            case "source": {
                String source = WXUtils.getString(param, null);
                if (source != null) {
                    this.setSource(source);
                }
                return true;
            }
        }
        return super.setProperty(key, param);
    }

    @WXComponentProp(name="show-loading")
    public void setShowLoading(boolean showLoading) {
        this.getWebView().setShowLoading(showLoading);
    }

    @WXComponentProp(name="src")
    public void setUrl(String url) {
        if (TextUtils.isEmpty((CharSequence)url) || this.getHostView() == null) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)url)) {
            this.loadUrl(this.getInstance().rewriteUri(Uri.parse((String)url), "web").toString());
        }
    }

    @WXComponentProp(name="source")
    public void setSource(String source) {
        if (!TextUtils.isEmpty((CharSequence)source) && this.getHostView() != null) {
            this.loadDataWithBaseURL(source);
        }
    }

    public void setAction(String action, Object data) {
        if (!TextUtils.isEmpty((CharSequence)action)) {
            if (action.equals(GO_BACK)) {
                this.goBack();
            } else if (action.equals(GO_FORWARD)) {
                this.goForward();
            } else if (action.equals(RELOAD)) {
                this.reload();
            } else if (action.equals(POST_MESSAGE)) {
                this.postMessage(data);
            }
        }
    }

    private void fireEvent(String type, Object message) {
        if (this.getDomObject().getEvents().contains("error")) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("type", type);
            params.put("errorMsg", message);
            this.fireEvent("error", params);
        }
    }

    private void loadUrl(String url) {
        this.getWebView().loadUrl(url);
    }

    private void loadDataWithBaseURL(String source) {
        this.getWebView().loadDataWithBaseURL(source);
    }

    @JSMethod
    public void reload() {
        this.getWebView().reload();
    }

    @JSMethod
    public void goForward() {
        this.getWebView().goForward();
    }

    @JSMethod
    public void goBack() {
        this.getWebView().goBack();
    }

    @JSMethod
    public void postMessage(Object msg) {
        this.getWebView().postMessage(msg);
    }

    private IWebView getWebView() {
        return this.mWebView;
    }
}

