/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import android.app.Activity;
import android.content.Context;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.adapter.IWXImgLoaderAdapter;
import com.taobao.weex.annotation.Component;
import com.taobao.weex.annotation.JSMethod;
import com.taobao.weex.bridge.JSCallback;
import com.taobao.weex.common.WXImageSharpen;
import com.taobao.weex.common.WXImageStrategy;
import com.taobao.weex.common.WXRuntimeException;
import com.taobao.weex.dom.ImmutableDomObject;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.ui.ComponentCreator;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.view.WXImageView;
import com.taobao.weex.ui.view.border.BorderDrawable;
import com.taobao.weex.utils.ImageDrawable;
import com.taobao.weex.utils.ImgURIUtil;
import com.taobao.weex.utils.SingleFunctionParser;
import com.taobao.weex.utils.WXDomUtils;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewToImageUtil;
import com.taobao.weex.utils.WXViewUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component(lazyload=false)
public class WXImage
extends WXComponent<ImageView> {
    public static final String SUCCEED = "success";
    public static final String ERRORDESC = "errorDesc";
    private static final int WRITE_EXTERNAL_STORAGE_PERMISSION_REQUEST_CODE = 2;
    private String mSrc;
    private int mBlurRadius;
    private boolean mAutoRecycle = true;
    private static SingleFunctionParser.FlatMapper<Integer> BLUR_RADIUS_MAPPER = new SingleFunctionParser.FlatMapper<Integer>(){

        @Override
        public Integer map(String raw) {
            return WXUtils.getInteger(raw, 0);
        }
    };

    @Deprecated
    public WXImage(WXSDKInstance instance, WXDomObject dom, WXVContainer parent, String instanceId, boolean isLazy) {
        this(instance, dom, parent);
    }

    public WXImage(WXSDKInstance instance, WXDomObject node, WXVContainer parent) {
        super(instance, node, parent);
    }

    @Override
    protected ImageView initComponentHostView(@NonNull Context context) {
        WXImageView view = new WXImageView(context);
        view.setScaleType(ImageView.ScaleType.FIT_XY);
        if (Build.VERSION.SDK_INT >= 16) {
            view.setCropToPadding(true);
        }
        view.holdComponent(this);
        return view;
    }

    @Override
    protected boolean setProperty(String key, Object param) {
        switch (key) {
            case "resizeMode": {
                String resize_mode = WXUtils.getString(param, null);
                if (resize_mode != null) {
                    this.setResizeMode(resize_mode);
                }
                return true;
            }
            case "resize": {
                String resize = WXUtils.getString(param, null);
                if (resize != null) {
                    this.setResize(resize);
                }
                return true;
            }
            case "src": {
                String src = WXUtils.getString(param, null);
                if (src != null) {
                    this.setSrc(src);
                }
                return true;
            }
            case "imageQuality": {
                return true;
            }
            case "autoBitmapRecycle": {
                this.mAutoRecycle = WXUtils.getBoolean(param, this.mAutoRecycle);
                return true;
            }
            case "filter": {
                int blurRadius = 0;
                if (param != null && param instanceof String) {
                    blurRadius = this.parseBlurRadius((String)param);
                }
                if (!TextUtils.isEmpty((CharSequence)this.mSrc)) {
                    this.setBlurRadius(this.mSrc, blurRadius);
                }
                return true;
            }
        }
        return super.setProperty(key, param);
    }

    @Override
    public void refreshData(WXComponent component) {
        super.refreshData(component);
        if (component instanceof WXImage) {
            this.setSrc(component.getDomObject().getAttrs().getImageSrc());
        }
    }

    @WXComponentProp(name="resizeMode")
    public void setResizeMode(String resizeMode) {
        ((ImageView)this.getHostView()).setScaleType(this.getResizeMode(resizeMode));
    }

    private ImageView.ScaleType getResizeMode(String resizeMode) {
        ImageView.ScaleType scaleType = ImageView.ScaleType.FIT_XY;
        if (TextUtils.isEmpty((CharSequence)resizeMode)) {
            return scaleType;
        }
        switch (resizeMode) {
            case "cover": {
                scaleType = ImageView.ScaleType.CENTER_CROP;
                break;
            }
            case "contain": {
                scaleType = ImageView.ScaleType.FIT_CENTER;
                break;
            }
            case "stretch": {
                scaleType = ImageView.ScaleType.FIT_XY;
            }
        }
        return scaleType;
    }

    @WXComponentProp(name="resize")
    public void setResize(String resize) {
        ((ImageView)this.getHostView()).setScaleType(this.getResizeMode(resize));
    }

    private void setLocalSrc(Uri rewrited) {
        ImageView imageView;
        Drawable localDrawable = ImgURIUtil.getDrawableFromLoaclSrc(this.getContext(), rewrited);
        if (localDrawable != null && (imageView = (ImageView)this.getHostView()) != null) {
            imageView.setImageDrawable(localDrawable);
        }
    }

    @WXComponentProp(name="src")
    public void setSrc(String src) {
        if (src == null) {
            return;
        }
        ImageView image = (ImageView)this.getHostView();
        if ("".equals(src) && image != null) {
            image.setImageDrawable(null);
            return;
        }
        if (image != null && image.getDrawable() != null) {
            image.setImageDrawable(null);
        }
        this.mSrc = src;
        WXSDKInstance instance = this.getInstance();
        Uri rewrited = instance.rewriteUri(Uri.parse((String)src), "image");
        if ("local".equals(rewrited.getScheme())) {
            this.setLocalSrc(rewrited);
        } else {
            int blur = 0;
            if (this.getDomObject() != null) {
                String blurStr = this.getDomObject().getStyles().getBlur();
                blur = this.parseBlurRadius(blurStr);
            }
            this.setRemoteSrc(rewrited, blur);
        }
    }

    private void setBlurRadius(@NonNull String src, int blurRadius) {
        Uri parsedUri;
        if (this.getInstance() != null && blurRadius != this.mBlurRadius && !"local".equals((parsedUri = this.getInstance().rewriteUri(Uri.parse((String)src), "image")).getScheme())) {
            this.setRemoteSrc(parsedUri, blurRadius);
        }
    }

    private int parseBlurRadius(@Nullable String rawRadius) {
        if (rawRadius == null) {
            return 0;
        }
        SingleFunctionParser<Integer> parser = new SingleFunctionParser<Integer>(rawRadius, BLUR_RADIUS_MAPPER);
        List<Integer> list = null;
        try {
            list = parser.parse("blur");
        }
        catch (Exception e) {
            return 0;
        }
        if (list == null || list.isEmpty()) {
            return 0;
        }
        return list.get(0);
    }

    @Override
    public void recycled() {
        super.recycled();
        if (this.getInstance().getImgLoaderAdapter() != null) {
            this.getInstance().getImgLoaderAdapter().setImage(null, (ImageView)this.mHost, null, null);
        } else {
            if (WXEnvironment.isApkDebugable()) {
                throw new WXRuntimeException("getImgLoaderAdapter() == null");
            }
            WXLogUtils.e("Error getImgLoaderAdapter() == null");
        }
    }

    public void autoReleaseImage() {
        if (this.mAutoRecycle && this.getHostView() != null && this.getInstance().getImgLoaderAdapter() != null) {
            this.getInstance().getImgLoaderAdapter().setImage(null, (ImageView)this.mHost, null, null);
        }
    }

    public void autoRecoverImage() {
        if (this.mAutoRecycle) {
            this.setSrc(this.mSrc);
        }
    }

    private void setRemoteSrc(Uri rewrited, int blurRadius) {
        IWXImgLoaderAdapter imgLoaderAdapter;
        WXImageStrategy imageStrategy = new WXImageStrategy();
        imageStrategy.isClipping = true;
        WXImageSharpen imageSharpen = this.getDomObject().getAttrs().getImageSharpen();
        imageStrategy.isSharpen = imageSharpen == WXImageSharpen.SHARPEN;
        imageStrategy.blurRadius = Math.max(0, blurRadius);
        this.mBlurRadius = blurRadius;
        imageStrategy.setImageListener(new WXImageStrategy.ImageListener(){

            @Override
            public void onImageFinish(String url, ImageView imageView, boolean result, Map extra) {
                if (WXImage.this.getDomObject() != null && WXImage.this.getDomObject().getEvents().contains("load")) {
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    HashMap<String, Integer> size = new HashMap<String, Integer>(2);
                    if (imageView != null && imageView instanceof Measurable) {
                        size.put("naturalWidth", ((Measurable)imageView).getNaturalWidth());
                        size.put("naturalHeight", ((Measurable)imageView).getNaturalHeight());
                    } else {
                        size.put("naturalWidth", 0);
                        size.put("naturalHeight", 0);
                    }
                    if (WXImage.this.getDomObject() != null && WXImage.this.containsEvent("load")) {
                        params.put(WXImage.SUCCEED, result);
                        params.put("size", size);
                        WXImage.this.fireEvent("load", params);
                    }
                }
                WXImage.this.monitorImgSize(imageView);
            }
        });
        String placeholder = null;
        if (this.getDomObject().getAttrs().containsKey("placeholder")) {
            placeholder = (String)this.getDomObject().getAttrs().get("placeholder");
        } else if (this.getDomObject().getAttrs().containsKey("placeHolder")) {
            placeholder = (String)this.getDomObject().getAttrs().get("placeHolder");
        }
        if (!TextUtils.isEmpty((CharSequence)placeholder)) {
            imageStrategy.placeHolder = this.getInstance().rewriteUri(Uri.parse((String)placeholder), "image").toString();
        }
        if ((imgLoaderAdapter = this.getInstance().getImgLoaderAdapter()) != null) {
            imgLoaderAdapter.setImage(rewrited.toString(), (ImageView)this.getHostView(), this.getDomObject().getAttrs().getImageQuality(), imageStrategy);
        }
    }

    @Override
    public void updateProperties(Map<String, Object> props) {
        super.updateProperties(props);
        ImmutableDomObject imageDom = this.getDomObject();
        if (imageDom != null && this.getHostView() instanceof WXImageView) {
            ImageDrawable imageDrawable;
            float[] previousRadius;
            float[] borderRadius;
            WXImageView imageView = (WXImageView)this.getHostView();
            BorderDrawable borderDrawable = WXViewUtils.getBorderDrawable(this.getHostView());
            if (borderDrawable != null) {
                RectF borderBox = new RectF(0.0f, 0.0f, WXDomUtils.getContentWidth(imageDom), WXDomUtils.getContentHeight(imageDom));
                borderRadius = borderDrawable.getBorderRadius(borderBox);
            } else {
                borderRadius = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
            }
            imageView.setBorderRadius(borderRadius);
            if (imageView.getDrawable() instanceof ImageDrawable && !Arrays.equals(previousRadius = (imageDrawable = (ImageDrawable)imageView.getDrawable()).getCornerRadii(), borderRadius)) {
                imageDrawable.setCornerRadii(borderRadius);
            }
            this.readyToRender();
        }
    }

    @JSMethod(uiThread=false)
    public void save(final JSCallback saveStatuCallback) {
        if (ContextCompat.checkSelfPermission((Context)this.getContext(), (String)"android.permission.WRITE_EXTERNAL_STORAGE") != 0 && this.getContext() instanceof Activity) {
            ActivityCompat.requestPermissions((Activity)((Activity)this.getContext()), (String[])new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"}, (int)2);
        }
        if (ContextCompat.checkSelfPermission((Context)this.getContext(), (String)"android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
            if (saveStatuCallback != null) {
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put(SUCCEED, false);
                result.put(ERRORDESC, "Permission denied: android.permission.WRITE_EXTERNAL_STORAGE");
                saveStatuCallback.invoke(result);
            }
            return;
        }
        if (this.mHost == null) {
            if (saveStatuCallback != null) {
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put(SUCCEED, false);
                result.put(ERRORDESC, "Image component not initialized");
                saveStatuCallback.invoke(result);
            }
            return;
        }
        if (this.mSrc == null || this.mSrc.equals("")) {
            if (saveStatuCallback != null) {
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put(SUCCEED, false);
                result.put(ERRORDESC, "Image does not have the correct src");
                saveStatuCallback.invoke(result);
            }
            return;
        }
        WXViewToImageUtil.generateImage(this.mHost, 0, -460552, new WXViewToImageUtil.OnImageSavedCallback(){

            @Override
            public void onSaveSucceed(String path) {
                if (saveStatuCallback != null) {
                    HashMap<String, Boolean> result = new HashMap<String, Boolean>();
                    result.put(WXImage.SUCCEED, true);
                    saveStatuCallback.invoke(result);
                }
            }

            @Override
            public void onSaveFailed(String errorDesc) {
                if (saveStatuCallback != null) {
                    HashMap<String, Object> result = new HashMap<String, Object>();
                    result.put(WXImage.SUCCEED, false);
                    result.put(WXImage.ERRORDESC, errorDesc);
                    saveStatuCallback.invoke(result);
                }
            }
        });
    }

    private void monitorImgSize(ImageView imageView) {
        if (null == imageView) {
            return;
        }
        WXSDKInstance instance = this.getInstance();
        if (null == instance) {
            return;
        }
        ViewGroup.LayoutParams params = imageView.getLayoutParams();
        Drawable img = imageView.getDrawable();
        if (null == params || null == img) {
            return;
        }
        if (img.getIntrinsicHeight() * img.getIntrinsicWidth() > imageView.getMeasuredHeight() * imageView.getMeasuredWidth()) {
            instance.getWXPerformance().wrongImgSizeCount += 1.0;
        }
    }

    @Override
    public void destroy() {
        if (this.getHostView() instanceof WXImageView && this.getInstance().getImgLoaderAdapter() != null) {
            this.getInstance().getImgLoaderAdapter().setImage(null, (ImageView)this.mHost, null, null);
        }
        super.destroy();
    }

    public static interface Measurable {
        public int getNaturalWidth();

        public int getNaturalHeight();
    }

    public static class Ceator
    implements ComponentCreator {
        @Override
        public WXComponent createInstance(WXSDKInstance instance, WXDomObject node, WXVContainer parent) throws IllegalAccessException, InvocationTargetException, InstantiationException {
            return new WXImage(instance, node, parent);
        }
    }
}

