/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.dom.DOMActionContext;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.dom.action.TraceableAction;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentFactory;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.utils.WXLogUtils;

public class ComponentUtils {
    private static final String TAG = "ComponentUtils";

    public static void initLazyComponent(WXComponent component, WXVContainer mParent) {
        if (component.isLazy()) {
            component.lazy(false);
            if (mParent != null) {
                int index = mParent.indexOf(component);
                mParent.createChildViewAt(index);
            } else {
                component.createView();
            }
            component.applyLayoutAndEvent(component);
            component.bindData(component);
        }
    }

    public static final synchronized WXComponent buildTree(WXDomObject domObject, WXVContainer parent) {
        DOMActionContext domActionContext = WXSDKManager.getInstance().getWXDomManager().getDomContext(parent.getInstanceId());
        if (domActionContext == null) {
            return null;
        }
        DomTreeBuilder builder = new DomTreeBuilder();
        domObject.traverseTree(domActionContext.getAddDOMConsumer(), domActionContext.getApplyStyleConsumer());
        return builder.buildComponentTree(domActionContext, domObject, parent);
    }

    static class DomTreeBuilder
    extends TraceableAction {
        DomTreeBuilder() {
        }

        private WXComponent buildComponentTree(DOMActionContext context, WXDomObject dom, WXVContainer parent) {
            if (dom == null) {
                return null;
            }
            long startNanos = System.nanoTime();
            dom.setCloneThis(true);
            WXComponent component = WXComponentFactory.newInstance(context.getInstance(), dom, parent);
            if (component != null) {
                component.mTraceInfo.domThreadStart = dom.mDomThreadTimestamp;
                component.mTraceInfo.rootEventId = this.mTracingEventId;
                component.mTraceInfo.domQueueTime = this.mDomQueueTime;
            }
            context.registerComponent(dom.getRef(), component);
            if (component instanceof WXVContainer) {
                WXVContainer container = (WXVContainer)component;
                WXDomObject parentDom = (WXDomObject)container.getDomObject();
                for (int i = 0; i < dom.childCount(); ++i) {
                    WXDomObject child = dom.getChild(i);
                    if (child == null) continue;
                    WXComponent childComponent = this.buildComponentTree(context, child, container);
                    container.addChild(childComponent);
                    WXDomObject childDomObject = (WXDomObject)childComponent.getDomObject();
                    if (childDomObject == child) continue;
                    int index = parentDom.index(child);
                    parentDom.add(childDomObject, index);
                    if (index >= 0) {
                        parentDom.remove(child);
                        --i;
                    }
                    IllegalArgumentException exception = new IllegalArgumentException(childDomObject.getClass().getName() + " not support clone this");
                    WXLogUtils.e("weex", exception);
                    if (!WXEnvironment.isApkDebugable()) continue;
                    throw exception;
                }
            }
            dom.setCloneThis(false);
            if (component != null) {
                component.mTraceInfo.domThreadNanos = System.nanoTime() - startNanos;
            }
            return component;
        }
    }
}

