/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.method.PasswordTransformationMethod;
import android.text.method.TransformationMethod;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.TextView;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.annotation.JSMethod;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.common.WXThread;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.dom.WXStyle;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.component.helper.SoftKeyboardDetector;
import com.taobao.weex.ui.component.helper.WXTimeInputHelper;
import com.taobao.weex.ui.view.WXEditText;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXResourceUtils;
import com.taobao.weex.utils.WXUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public abstract class AbstractEditComponent
extends WXComponent<WXEditText> {
    private final InputMethodManager mInputMethodManager = (InputMethodManager)this.getContext().getSystemService("input_method");
    private String mBeforeText = "";
    private boolean mAutoFocus;
    private String mType = "text";
    private String mMax = null;
    private String mMin = null;
    private String mLastValue = "";
    private int mEditorAction = 6;
    private String mReturnKeyType = null;
    private List<TextView.OnEditorActionListener> mEditorActionListeners;
    private boolean mListeningKeyboard = false;
    private SoftKeyboardDetector.Unregister mUnregister;
    private boolean mIgnoreNextOnInputEvent = false;
    private boolean mKeepSelectionIndex = false;
    private TextFormatter mFormatter = null;
    private List<TextWatcher> mTextChangedListeners;
    private TextWatcher mTextChangedEventDispatcher;
    private int mFormatRepeatCount = 0;
    private static final int MAX_TEXT_FORMAT_REPEAT = 3;

    public AbstractEditComponent(WXSDKInstance instance, WXDomObject dom, WXVContainer parent, boolean isLazy) {
        super(instance, dom, parent, isLazy);
    }

    @Override
    protected WXEditText initComponentHostView(@NonNull Context context) {
        WXEditText inputView = new WXEditText(context);
        this.appleStyleAfterCreated(inputView);
        return inputView;
    }

    @Override
    protected void onHostViewInitialized(WXEditText host) {
        super.onHostViewInitialized(host);
        this.addFocusChangeListener(new WXComponent.OnFocusChangeListener(){

            @Override
            public void onFocusChange(boolean hasFocus) {
                if (!hasFocus) {
                    AbstractEditComponent.this.decideSoftKeyboard();
                }
                AbstractEditComponent.this.setPseudoClassStatus(":focus", hasFocus);
            }
        });
        this.addKeyboardListener(host);
    }

    @Override
    protected boolean isConsumeTouch() {
        return !this.isDisabled();
    }

    private void applyOnClickListener() {
        this.addClickListener(new WXComponent.OnClickListener(){

            @Override
            public void onHostViewClick() {
                switch (AbstractEditComponent.this.mType) {
                    case "date": {
                        AbstractEditComponent.this.hideSoftKeyboard();
                        if (AbstractEditComponent.this.getParent() != null) {
                            AbstractEditComponent.this.getParent().interceptFocus();
                        }
                        WXTimeInputHelper.pickDate(AbstractEditComponent.this.mMax, AbstractEditComponent.this.mMin, AbstractEditComponent.this);
                        break;
                    }
                    case "time": {
                        AbstractEditComponent.this.hideSoftKeyboard();
                        if (AbstractEditComponent.this.getParent() != null) {
                            AbstractEditComponent.this.getParent().interceptFocus();
                        }
                        WXTimeInputHelper.pickTime(AbstractEditComponent.this);
                    }
                }
            }
        });
    }

    protected int getVerticalGravity() {
        return 16;
    }

    protected void appleStyleAfterCreated(final WXEditText editText) {
        String alignStr = (String)this.getDomObject().getStyles().get("textAlign");
        int textAlign = this.getTextAlign(alignStr);
        if (textAlign <= 0) {
            textAlign = 0x800003;
        }
        editText.setGravity(textAlign | this.getVerticalGravity());
        int colorInt = WXResourceUtils.getColor("#999999");
        if (colorInt != Integer.MIN_VALUE) {
            editText.setHintTextColor(colorInt);
        }
        this.mTextChangedEventDispatcher = new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                if (AbstractEditComponent.this.mTextChangedListeners != null) {
                    for (TextWatcher watcher : AbstractEditComponent.this.mTextChangedListeners) {
                        watcher.beforeTextChanged(s, start, count, after);
                    }
                }
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                if (AbstractEditComponent.this.mFormatter != null) {
                    String raw = AbstractEditComponent.this.mFormatter.recover(s.toString());
                    String result = AbstractEditComponent.this.mFormatter.format(raw);
                    if (!result.equals(s.toString()) && AbstractEditComponent.this.mFormatRepeatCount < 3) {
                        AbstractEditComponent.this.mFormatRepeatCount = AbstractEditComponent.this.mFormatRepeatCount + 1;
                        int index = editText.getSelectionStart();
                        int cursorIndex = AbstractEditComponent.this.mFormatter.format(AbstractEditComponent.this.mFormatter.recover(s.subSequence(0, index).toString())).length();
                        editText.setText(result);
                        editText.setSelection(cursorIndex);
                        return;
                    }
                    AbstractEditComponent.this.mFormatRepeatCount = 0;
                }
                if (AbstractEditComponent.this.mTextChangedListeners != null) {
                    for (TextWatcher watcher : AbstractEditComponent.this.mTextChangedListeners) {
                        watcher.onTextChanged(s, start, before, count);
                    }
                }
            }

            public void afterTextChanged(Editable s) {
                if (AbstractEditComponent.this.mTextChangedListeners != null) {
                    for (TextWatcher watcher : AbstractEditComponent.this.mTextChangedListeners) {
                        watcher.afterTextChanged(s);
                    }
                }
            }
        };
        editText.addTextChangedListener(this.mTextChangedEventDispatcher);
        editText.setTextSize(0, WXStyle.getFontSize(this.getDomObject().getStyles(), this.getInstance().getInstanceViewPortWidth()));
    }

    @Override
    public void addEvent(String type) {
        super.addEvent(type);
        if (this.getHostView() == null || TextUtils.isEmpty((CharSequence)type)) {
            return;
        }
        final TextView text = (TextView)this.getHostView();
        if (type.equals("change")) {
            this.addFocusChangeListener(new WXComponent.OnFocusChangeListener(){

                @Override
                public void onFocusChange(boolean hasFocus) {
                    if (hasFocus) {
                        AbstractEditComponent.this.mLastValue = text.getText().toString();
                    } else {
                        CharSequence newValue = text.getText();
                        CharSequence charSequence = newValue = newValue == null ? "" : newValue;
                        if (!newValue.toString().equals(AbstractEditComponent.this.mLastValue)) {
                            AbstractEditComponent.this.fireEvent("change", newValue.toString());
                            AbstractEditComponent.this.mLastValue = text.getText().toString();
                        }
                    }
                }
            });
            this.addEditorActionListener(new TextView.OnEditorActionListener(){

                public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                    if (actionId == AbstractEditComponent.this.mEditorAction) {
                        CharSequence newValue = text.getText();
                        CharSequence charSequence = newValue = newValue == null ? "" : newValue;
                        if (!newValue.toString().equals(AbstractEditComponent.this.mLastValue)) {
                            AbstractEditComponent.this.fireEvent("change", newValue.toString());
                            AbstractEditComponent.this.mLastValue = text.getText().toString();
                        }
                        if (AbstractEditComponent.this.getParent() != null) {
                            AbstractEditComponent.this.getParent().interceptFocus();
                        }
                        AbstractEditComponent.this.hideSoftKeyboard();
                        return true;
                    }
                    return false;
                }
            });
        } else if (type.equals("input")) {
            this.addTextChangedListener(new TextWatcher(){

                public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                }

                public void onTextChanged(CharSequence s, int start, int before, int count) {
                    if (AbstractEditComponent.this.mIgnoreNextOnInputEvent) {
                        AbstractEditComponent.this.mIgnoreNextOnInputEvent = false;
                        return;
                    }
                    if (AbstractEditComponent.this.mBeforeText.equals(s.toString())) {
                        return;
                    }
                    AbstractEditComponent.this.mBeforeText = s.toString();
                    AbstractEditComponent.this.fireEvent("input", s.toString());
                }

                public void afterTextChanged(Editable s) {
                }
            });
        }
        if ("return".equals(type)) {
            this.addEditorActionListener(new TextView.OnEditorActionListener(){

                public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                    if (actionId == AbstractEditComponent.this.mEditorAction) {
                        HashMap<String, Object> ret = new HashMap<String, Object>(2);
                        ret.put("returnKeyType", AbstractEditComponent.this.mReturnKeyType);
                        ret.put("value", v.getText().toString());
                        AbstractEditComponent.this.fireEvent("return", ret);
                        return true;
                    }
                    return false;
                }
            });
        }
        if ("keyboard".equals(type)) {
            this.mListeningKeyboard = true;
        }
    }

    private void fireEvent(String event, String value) {
        if (event != null) {
            HashMap<String, Object> params = new HashMap<String, Object>(2);
            params.put("value", value);
            params.put("timeStamp", System.currentTimeMillis());
            HashMap<String, Object> domChanges = new HashMap<String, Object>();
            HashMap<String, String> attrsChanges = new HashMap<String, String>();
            attrsChanges.put("value", value);
            domChanges.put("attrs", attrsChanges);
            WXSDKManager.getInstance().fireEvent(this.getInstanceId(), this.getDomObject().getRef(), event, params, domChanges);
        }
    }

    public void performOnChange(String value) {
        if (this.getDomObject() != null && this.getDomObject().getEvents() != null) {
            String event = this.getDomObject().getEvents().contains("change") ? "change" : null;
            this.fireEvent(event, value);
        }
    }

    @Override
    protected boolean setProperty(String key, Object param) {
        switch (key) {
            case "placeholder": {
                String placeholder = WXUtils.getString(param, null);
                if (placeholder != null) {
                    this.setPlaceholder(placeholder);
                }
                return true;
            }
            case "placeholderColor": {
                String placeholder_color = WXUtils.getString(param, null);
                if (placeholder_color != null) {
                    this.setPlaceholderColor(placeholder_color);
                }
                return true;
            }
            case "type": {
                String input_type = WXUtils.getString(param, null);
                if (input_type != null) {
                    this.setType(input_type);
                }
                return true;
            }
            case "autofocus": {
                Boolean result = WXUtils.getBoolean(param, null);
                if (result != null) {
                    this.setAutofocus(result);
                }
                return true;
            }
            case "color": {
                String color = WXUtils.getString(param, null);
                if (color != null) {
                    this.setColor(color);
                }
                return true;
            }
            case "fontSize": {
                String fontsize = WXUtils.getString(param, null);
                if (fontsize != null) {
                    this.setFontSize(fontsize);
                }
                return true;
            }
            case "textAlign": {
                String text_align = WXUtils.getString(param, null);
                if (text_align != null) {
                    this.setTextAlign(text_align);
                }
                return true;
            }
            case "singleline": {
                Boolean singLineResult = WXUtils.getBoolean(param, null);
                if (singLineResult != null) {
                    this.setSingleLine(singLineResult);
                }
                return true;
            }
            case "lines": {
                Integer lines = WXUtils.getInteger(param, null);
                if (lines != null) {
                    this.setLines(lines);
                }
                return true;
            }
            case "maxLength": {
                Integer maxlength = WXUtils.getInteger(param, null);
                if (maxlength != null) {
                    this.setMaxLength(maxlength);
                }
                return true;
            }
            case "maxlength": {
                Integer maxLength = WXUtils.getInteger(param, null);
                if (maxLength != null) {
                    this.setMaxLength(maxLength);
                }
                return true;
            }
            case "max": {
                this.setMax(String.valueOf(param));
                return true;
            }
            case "min": {
                this.setMin(String.valueOf(param));
                return true;
            }
            case "returnKeyType": {
                this.setReturnKeyType(String.valueOf(param));
                return true;
            }
            case "keepSelectionIndex": {
                boolean keepIndex;
                this.mKeepSelectionIndex = keepIndex = WXUtils.getBoolean(param, false).booleanValue();
                return true;
            }
            case "allowCopyPaste": {
                boolean allowCopyPaste = WXUtils.getBoolean(param, true);
                if (this.getHostView() != null) {
                    ((WXEditText)this.getHostView()).setAllowCopyPaste(allowCopyPaste);
                }
                return true;
            }
        }
        return super.setProperty(key, param);
    }

    @WXComponentProp(name="returnKeyType")
    public void setReturnKeyType(String type) {
        if (this.getHostView() == null) {
            return;
        }
        this.mReturnKeyType = type;
        switch (type) {
            case "default": {
                this.mEditorAction = 0;
                break;
            }
            case "go": {
                this.mEditorAction = 2;
                break;
            }
            case "next": {
                this.mEditorAction = 5;
                break;
            }
            case "search": {
                this.mEditorAction = 3;
                break;
            }
            case "send": {
                this.mEditorAction = 4;
                break;
            }
            case "done": {
                this.mEditorAction = 6;
                break;
            }
        }
        this.blur();
        ((WXEditText)this.getHostView()).setImeOptions(this.mEditorAction);
    }

    @WXComponentProp(name="placeholder")
    public void setPlaceholder(String placeholder) {
        if (placeholder == null || this.getHostView() == null) {
            return;
        }
        ((WXEditText)this.getHostView()).setHint(placeholder);
    }

    @WXComponentProp(name="placeholderColor")
    public void setPlaceholderColor(String color) {
        int colorInt;
        if (this.getHostView() != null && !TextUtils.isEmpty((CharSequence)color) && (colorInt = WXResourceUtils.getColor(color)) != Integer.MIN_VALUE) {
            ((WXEditText)this.getHostView()).setHintTextColor(colorInt);
        }
    }

    @WXComponentProp(name="type")
    public void setType(String type) {
        if (type == null || this.getHostView() == null) {
            return;
        }
        this.mType = type;
        ((EditText)this.getHostView()).setRawInputType(this.getInputType(this.mType));
        switch (this.mType) {
            case "date": 
            case "time": {
                this.applyOnClickListener();
            }
        }
    }

    @WXComponentProp(name="autofocus")
    public void setAutofocus(boolean autofocus) {
        if (this.getHostView() == null) {
            return;
        }
        this.mAutoFocus = autofocus;
        EditText inputView = (EditText)this.getHostView();
        if (this.mAutoFocus) {
            inputView.setFocusable(true);
            inputView.requestFocus();
            inputView.setFocusableInTouchMode(true);
            this.showSoftKeyboard();
        } else {
            this.hideSoftKeyboard();
        }
    }

    @WXComponentProp(name="value")
    public void setValue(String value) {
        WXEditText view = (WXEditText)this.getHostView();
        if (view == null) {
            return;
        }
        this.mIgnoreNextOnInputEvent = true;
        int oldIndex = view.getSelectionStart();
        view.setText(value);
        int index = this.mKeepSelectionIndex ? oldIndex : value.length();
        view.setSelection(value == null ? 0 : index);
    }

    @WXComponentProp(name="color")
    public void setColor(String color) {
        int colorInt;
        if (this.getHostView() != null && !TextUtils.isEmpty((CharSequence)color) && (colorInt = WXResourceUtils.getColor(color)) != Integer.MIN_VALUE) {
            ((WXEditText)this.getHostView()).setTextColor(colorInt);
        }
    }

    @WXComponentProp(name="fontSize")
    public void setFontSize(String fontSize) {
        if (this.getHostView() != null && fontSize != null) {
            HashMap<String, Object> map = new HashMap<String, Object>(1);
            map.put("fontSize", fontSize);
            ((WXEditText)this.getHostView()).setTextSize(0, WXStyle.getFontSize(map, this.getInstance().getInstanceViewPortWidth()));
        }
    }

    @WXComponentProp(name="textAlign")
    public void setTextAlign(String textAlign) {
        int align = this.getTextAlign(textAlign);
        if (align > 0) {
            ((WXEditText)this.getHostView()).setGravity(align | this.getVerticalGravity());
        }
    }

    @WXComponentProp(name="singleline")
    public void setSingleLine(boolean singleLine) {
        if (this.getHostView() == null) {
            return;
        }
        ((WXEditText)this.getHostView()).setSingleLine(singleLine);
    }

    @WXComponentProp(name="lines")
    public void setLines(int lines) {
        if (this.getHostView() == null) {
            return;
        }
        ((WXEditText)this.getHostView()).setLines(lines);
    }

    @WXComponentProp(name="maxLength")
    public void setMaxLength(int maxLength) {
        if (this.getHostView() == null) {
            return;
        }
        ((WXEditText)this.getHostView()).setFilters(new InputFilter[]{new InputFilter.LengthFilter(maxLength)});
    }

    @WXComponentProp(name="maxlength")
    @Deprecated
    public void setMaxlength(int maxLength) {
        this.setMaxLength(maxLength);
    }

    private int getInputType(String type) {
        int inputType;
        switch (type) {
            case "text": {
                inputType = 1;
                break;
            }
            case "date": {
                inputType = 0;
                ((WXEditText)this.getHostView()).setFocusable(false);
                break;
            }
            case "datetime": {
                inputType = 4;
                break;
            }
            case "email": {
                inputType = 33;
                break;
            }
            case "password": {
                inputType = 129;
                ((WXEditText)this.getHostView()).setTransformationMethod((TransformationMethod)PasswordTransformationMethod.getInstance());
                break;
            }
            case "tel": {
                inputType = 3;
                break;
            }
            case "time": {
                inputType = 0;
                ((WXEditText)this.getHostView()).setFocusable(false);
                break;
            }
            case "url": {
                inputType = 17;
                break;
            }
            case "number": {
                inputType = 2;
                break;
            }
            default: {
                inputType = 1;
            }
        }
        return inputType;
    }

    @WXComponentProp(name="max")
    public void setMax(String max) {
        this.mMax = max;
    }

    @WXComponentProp(name="min")
    public void setMin(String min) {
        this.mMin = min;
    }

    private boolean showSoftKeyboard() {
        if (this.getHostView() == null) {
            return false;
        }
        ((WXEditText)this.getHostView()).postDelayed(WXThread.secure(new Runnable(){

            @Override
            public void run() {
                AbstractEditComponent.this.mInputMethodManager.showSoftInput(AbstractEditComponent.this.getHostView(), 1);
            }
        }), 100L);
        return true;
    }

    private void hideSoftKeyboard() {
        if (this.getHostView() != null) {
            ((WXEditText)this.getHostView()).postDelayed(WXThread.secure(new Runnable(){

                @Override
                public void run() {
                    AbstractEditComponent.this.mInputMethodManager.hideSoftInputFromWindow(((WXEditText)AbstractEditComponent.this.getHostView()).getWindowToken(), 0);
                }
            }), 16L);
        }
    }

    private int getTextAlign(String textAlign) {
        int align = 0x800003;
        if (TextUtils.isEmpty((CharSequence)textAlign)) {
            return align;
        }
        if (textAlign.equals("left")) {
            align = 0x800003;
        } else if (textAlign.equals("center")) {
            align = 17;
        } else if (textAlign.equals("right")) {
            align = 0x800005;
        }
        return align;
    }

    @JSMethod
    public void blur() {
        WXEditText host = (WXEditText)this.getHostView();
        if (host != null && host.hasFocus()) {
            if (this.getParent() != null) {
                this.getParent().interceptFocus();
            }
            host.clearFocus();
            this.hideSoftKeyboard();
        }
    }

    @JSMethod
    public void focus() {
        WXEditText host = (WXEditText)this.getHostView();
        if (host != null && !host.hasFocus()) {
            if (this.getParent() != null) {
                this.getParent().ignoreFocus();
            }
            host.requestFocus();
            host.setFocusable(true);
            host.setFocusableInTouchMode(true);
            this.showSoftKeyboard();
        }
    }

    @Override
    protected Object convertEmptyProperty(String propName, Object originalValue) {
        switch (propName) {
            case "fontSize": {
                return 32;
            }
            case "color": {
                return "black";
            }
        }
        return super.convertEmptyProperty(propName, originalValue);
    }

    private void decideSoftKeyboard() {
        Context context;
        Object hostView = this.getHostView();
        if (hostView != null && (context = this.getContext()) != null && context instanceof Activity) {
            hostView.postDelayed(WXThread.secure(new Runnable(){

                @Override
                public void run() {
                    View currentFocus = ((Activity)context).getCurrentFocus();
                    if (!(currentFocus instanceof EditText)) {
                        AbstractEditComponent.this.mInputMethodManager.hideSoftInputFromWindow(((WXEditText)AbstractEditComponent.this.getHostView()).getWindowToken(), 0);
                    }
                }
            }), 16L);
        }
    }

    @JSMethod
    public void setSelectionRange(int selectionStart, int selectionEnd) {
        EditText hostView = (EditText)this.getHostView();
        if (hostView != null) {
            int length = ((WXEditText)this.getHostView()).length();
            if (selectionStart > length || selectionEnd > length) {
                return;
            }
            this.focus();
            hostView.setSelection(selectionStart, selectionEnd);
        }
    }

    @JSMethod
    public void getSelectionRange(String callbackId) {
        HashMap<String, Integer> result = new HashMap<String, Integer>(2);
        EditText hostView = (EditText)this.getHostView();
        if (hostView != null) {
            int start = hostView.getSelectionStart();
            int end = hostView.getSelectionEnd();
            if (!hostView.hasFocus()) {
                start = 0;
                end = 0;
            }
            result.put("selectionStart", start);
            result.put("selectionEnd", end);
        }
        WXBridgeManager.getInstance().callback(this.getInstanceId(), callbackId, result, false);
    }

    @JSMethod
    public void setTextFormatter(JSONObject params) {
        try {
            String formatRule = params.getString("formatRule");
            String formatReplace = params.getString("formatReplace");
            String recoverRule = params.getString("recoverRule");
            String recoverReplace = params.getString("recoverReplace");
            PatternWrapper format = this.parseToPattern(formatRule, formatReplace);
            PatternWrapper recover = this.parseToPattern(recoverRule, recoverReplace);
            if (format != null && recover != null) {
                this.mFormatter = new TextFormatter(format, recover);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    protected final void addEditorActionListener(TextView.OnEditorActionListener listener) {
        TextView view;
        if (listener != null && (view = (TextView)this.getHostView()) != null) {
            if (this.mEditorActionListeners == null) {
                this.mEditorActionListeners = new ArrayList<TextView.OnEditorActionListener>();
                view.setOnEditorActionListener(new TextView.OnEditorActionListener(){
                    private boolean handled = true;

                    public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                        for (TextView.OnEditorActionListener l : AbstractEditComponent.this.mEditorActionListeners) {
                            if (l == null) continue;
                            this.handled &= l.onEditorAction(v, actionId, event);
                        }
                        return this.handled;
                    }
                });
            }
            this.mEditorActionListeners.add(listener);
        }
    }

    public final void addTextChangedListener(TextWatcher watcher) {
        if (this.mTextChangedListeners == null) {
            this.mTextChangedListeners = new ArrayList<TextWatcher>();
        }
        this.mTextChangedListeners.add(watcher);
    }

    private void addKeyboardListener(WXEditText host) {
        if (host == null) {
            return;
        }
        Context context = host.getContext();
        if (context != null && context instanceof Activity) {
            SoftKeyboardDetector.registerKeyboardEventListener((Activity)context, new SoftKeyboardDetector.OnKeyboardEventListener(){

                @Override
                public void onKeyboardEvent(boolean isShown) {
                    if (AbstractEditComponent.this.mListeningKeyboard) {
                        HashMap<String, Object> event = new HashMap<String, Object>(1);
                        event.put("isShow", isShown);
                        AbstractEditComponent.this.fireEvent("keyboard", event);
                    }
                    if (!isShown) {
                        AbstractEditComponent.this.blur();
                    }
                }
            });
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.mUnregister != null) {
            try {
                this.mUnregister.execute();
                this.mUnregister = null;
            }
            catch (Throwable throwable) {
                WXLogUtils.w("Unregister throw ", throwable);
            }
        }
    }

    private PatternWrapper parseToPattern(String jsPattern, String replace) {
        if (jsPattern == null || replace == null) {
            return null;
        }
        String checker = "/[\\S]+/[i]?[m]?[g]?";
        if (!Pattern.compile(checker).matcher(jsPattern).matches()) {
            WXLogUtils.w("WXInput", "Illegal js pattern syntax: " + jsPattern);
            return null;
        }
        int flags = 0;
        boolean global = false;
        String flagsStr = jsPattern.substring(jsPattern.lastIndexOf("/") + 1);
        String regExp = jsPattern.substring(jsPattern.indexOf("/") + 1, jsPattern.lastIndexOf("/"));
        if (flagsStr.contains("i")) {
            flags |= 2;
        }
        if (flagsStr.contains("m")) {
            flags |= 0x20;
        }
        if (flagsStr.contains("g")) {
            global = true;
        }
        Pattern pattern = null;
        try {
            pattern = Pattern.compile(regExp, flags);
        }
        catch (PatternSyntaxException e) {
            WXLogUtils.w("WXInput", "Pattern syntax error: " + regExp);
        }
        if (pattern == null) {
            return null;
        }
        PatternWrapper wrapper = new PatternWrapper();
        wrapper.global = global;
        wrapper.matcher = pattern;
        wrapper.replace = replace;
        return wrapper;
    }

    private static class TextFormatter {
        private PatternWrapper format;
        private PatternWrapper recover;

        private TextFormatter(PatternWrapper format, PatternWrapper recover) {
            this.format = format;
            this.recover = recover;
        }

        private String format(String src) {
            try {
                if (this.format != null) {
                    if (this.format.global) {
                        return this.format.matcher.matcher(src).replaceAll(this.format.replace);
                    }
                    return this.format.matcher.matcher(src).replaceFirst(this.format.replace);
                }
            }
            catch (Throwable t) {
                WXLogUtils.w("WXInput", "[format] " + t.getMessage());
            }
            return src;
        }

        private String recover(String formatted) {
            try {
                if (this.recover != null) {
                    if (this.recover.global) {
                        return this.recover.matcher.matcher(formatted).replaceAll(this.recover.replace);
                    }
                    return this.recover.matcher.matcher(formatted).replaceFirst(this.recover.replace);
                }
            }
            catch (Throwable t) {
                WXLogUtils.w("WXInput", "[formatted] " + t.getMessage());
            }
            return formatted;
        }
    }

    private static class PatternWrapper {
        private boolean global = false;
        private Pattern matcher;
        private String replace;

        private PatternWrapper() {
        }
    }

    private static interface ReturnTypes {
        public static final String DEFAULT = "default";
        public static final String GO = "go";
        public static final String NEXT = "next";
        public static final String SEARCH = "search";
        public static final String SEND = "send";
        public static final String DONE = "done";
    }
}

