/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui;

import android.text.TextUtils;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.common.WXException;
import com.taobao.weex.ui.IFComponentHolder;
import com.taobao.weex.utils.WXLogUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class WXComponentRegistry {
    private static Map<String, IFComponentHolder> sTypeComponentMap = new ConcurrentHashMap<String, IFComponentHolder>();
    private static ArrayList<Map<String, Object>> sComponentInfos = new ArrayList();

    public static synchronized boolean registerComponent(final String type, final IFComponentHolder holder, final Map<String, Object> componentInfo) throws WXException {
        if (holder == null || TextUtils.isEmpty((CharSequence)type)) {
            return false;
        }
        WXBridgeManager.getInstance().post(new Runnable(){

            @Override
            public void run() {
                try {
                    HashMap<String, String> registerInfo = componentInfo;
                    if (registerInfo == null) {
                        registerInfo = new HashMap<String, String>();
                    }
                    registerInfo.put("type", type);
                    registerInfo.put("methods", (String)holder.getMethods());
                    WXComponentRegistry.registerNativeComponent(type, holder);
                    WXComponentRegistry.registerJSComponent(registerInfo);
                    sComponentInfos.add(registerInfo);
                }
                catch (WXException e) {
                    WXLogUtils.e("register component error:", e);
                }
            }
        });
        return true;
    }

    private static boolean registerNativeComponent(String type, IFComponentHolder holder) throws WXException {
        try {
            holder.loadIfNonLazy();
            sTypeComponentMap.put(type, holder);
        }
        catch (ArrayStoreException e) {
            e.printStackTrace();
        }
        return true;
    }

    private static boolean registerJSComponent(Map<String, Object> componentInfo) throws WXException {
        ArrayList<Map<String, Object>> coms = new ArrayList<Map<String, Object>>();
        coms.add(componentInfo);
        WXSDKManager.getInstance().registerComponents(coms);
        return true;
    }

    public static IFComponentHolder getComponent(String type) {
        return sTypeComponentMap.get(type);
    }

    public static void reload() {
        WXBridgeManager.getInstance().post(new Runnable(){

            @Override
            public void run() {
                try {
                    for (Map com : sComponentInfos) {
                        WXComponentRegistry.registerJSComponent(com);
                    }
                }
                catch (WXException e) {
                    WXLogUtils.e("", e);
                }
            }
        });
    }
}

