/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.dom.action;

import android.text.TextUtils;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.bridge.SimpleJSCallback;
import com.taobao.weex.dom.RenderAction;
import com.taobao.weex.dom.RenderActionContext;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.list.template.CellDataManager;
import com.taobao.weex.ui.component.list.template.WXRecyclerTemplateList;
import com.taobao.weex.utils.WXLogUtils;

public class UpdateComponentDataAction
implements RenderAction {
    private String virtualComponentId;
    private JSONObject data;
    private String callback;

    public UpdateComponentDataAction(String virtualComponentId, JSONObject data, String callback) {
        this.virtualComponentId = virtualComponentId;
        this.data = data;
        this.callback = callback;
    }

    @Override
    public void executeRender(RenderActionContext context) {
        String ref = CellDataManager.getListRef(this.virtualComponentId);
        if (TextUtils.isEmpty((CharSequence)ref)) {
            WXLogUtils.e("wrong virtualComponentId split error " + this.virtualComponentId);
            return;
        }
        WXComponent component = context.getComponent(ref);
        if (component instanceof WXRecyclerTemplateList) {
            WXRecyclerTemplateList templateList = (WXRecyclerTemplateList)component;
            templateList.getCellDataManager().updateVirtualComponentData(this.virtualComponentId, this.data);
            templateList.notifyUpdateList();
            SimpleJSCallback jsCallback = new SimpleJSCallback(component.getInstanceId(), this.callback);
            jsCallback.invoke(true);
        } else {
            WXLogUtils.e("recycler-list wrong virtualComponentId " + this.virtualComponentId);
        }
    }
}

