/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.dom.action;

import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.common.WXErrorCode;
import com.taobao.weex.dom.DOMAction;
import com.taobao.weex.dom.DOMActionContext;
import com.taobao.weex.dom.RenderAction;
import com.taobao.weex.dom.RenderActionContext;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.dom.WXEvent;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.utils.WXExceptionUtils;

class RemoveEventAction
implements DOMAction,
RenderAction {
    private final String mRef;
    private final String mEvent;
    private WXDomObject mUpdatedDomObject;

    RemoveEventAction(String ref, Object event) {
        this.mRef = ref;
        this.mEvent = WXEvent.getEventName(event);
    }

    @Override
    public void executeDom(DOMActionContext context) {
        if (context.isDestory()) {
            return;
        }
        WXSDKInstance instance = context.getInstance();
        WXDomObject domObject = context.getDomByRef(this.mRef);
        if (domObject == null) {
            if (instance != null) {
                WXExceptionUtils.commitCriticalExceptionRT(instance.getInstanceId(), WXErrorCode.WX_KEY_EXCEPTION_DOM_REMOVE_EVENT, "updateAttr", WXErrorCode.WX_KEY_EXCEPTION_DOM_REMOVE_EVENT.getErrorMsg() + "domObject is null", null);
            }
            return;
        }
        domObject.removeEvent(this.mEvent);
        this.mUpdatedDomObject = domObject;
        context.postRenderTask(this);
    }

    @Override
    public void executeRender(RenderActionContext context) {
        WXComponent comp = context.getComponent(this.mRef);
        if (comp != null) {
            comp.updateDom(this.mUpdatedDomObject);
            comp.removeEvent(this.mEvent);
        }
    }
}

