/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.dom.action;

import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.common.WXErrorCode;
import com.taobao.weex.dom.DOMAction;
import com.taobao.weex.dom.DOMActionContext;
import com.taobao.weex.dom.RenderAction;
import com.taobao.weex.dom.RenderActionContext;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.utils.WXExceptionUtils;

final class RemoveElementAction
implements DOMAction,
RenderAction {
    private final String mRef;

    RemoveElementAction(String ref) {
        this.mRef = ref;
    }

    @Override
    public void executeDom(DOMActionContext context) {
        if (context.isDestory()) {
            return;
        }
        WXSDKInstance instance = context.getInstance();
        WXDomObject domObject = context.getDomByRef(this.mRef);
        if (domObject == null) {
            if (instance != null) {
                WXExceptionUtils.commitCriticalExceptionRT(instance.getInstanceId(), WXErrorCode.WX_KEY_EXCEPTION_DOM_REMOVE_ELEMENT, "removeElement", WXErrorCode.WX_KEY_EXCEPTION_DOM_REMOVE_ELEMENT.getErrorMsg() + "domObject is null", null);
            }
            return;
        }
        WXDomObject parent = domObject.parent;
        if (parent == null) {
            if (instance != null) {
                WXExceptionUtils.commitCriticalExceptionRT(instance.getInstanceId(), WXErrorCode.WX_KEY_EXCEPTION_DOM_REMOVE_ELEMENT, "removeElement", WXErrorCode.WX_KEY_EXCEPTION_DOM_REMOVE_ELEMENT.getErrorMsg() + "parent is null", null);
            }
            return;
        }
        domObject.traverseTree(context.getRemoveElementConsumer());
        parent.remove(domObject);
        context.unregisterDOMObject(this.mRef);
        context.postRenderTask(this);
    }

    @Override
    public void executeRender(RenderActionContext context) {
        WXComponent component = context.getComponent(this.mRef);
        if (component == null || component.getParent() == null) {
            return;
        }
        WXVContainer parent = component.getParent();
        this.clearRegistryForComponent(context, component);
        parent.remove(component, true);
        context.unregisterComponent(this.mRef);
        WXSDKInstance instance = context.getInstance();
        if (null != instance) {
            instance.onElementChange();
        }
    }

    private void clearRegistryForComponent(RenderActionContext context, WXComponent component) {
        WXComponent removedComponent = context.unregisterComponent(component.getDomObject().getRef());
        if (removedComponent != null) {
            removedComponent.removeAllEvent();
            removedComponent.removeStickyStyle();
        }
        if (component instanceof WXVContainer) {
            WXVContainer container = (WXVContainer)component;
            int count = container.childCount();
            for (int i = count - 1; i >= 0; --i) {
                this.clearRegistryForComponent(context, container.getChild(i));
            }
        }
    }
}

