/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.dom.action;

import android.view.View;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.common.WXErrorCode;
import com.taobao.weex.dom.DOMAction;
import com.taobao.weex.dom.DOMActionContext;
import com.taobao.weex.dom.RenderAction;
import com.taobao.weex.dom.RenderActionContext;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.utils.WXExceptionUtils;

final class MoveElementAction
implements DOMAction,
RenderAction {
    private final String mRef;
    private final String mParentRef;
    private final int mIndex;
    private int mNewIndex;

    MoveElementAction(String ref, String parentRef, int index) {
        this.mRef = ref;
        this.mParentRef = parentRef;
        this.mIndex = index;
        this.mNewIndex = index;
    }

    @Override
    public void executeDom(DOMActionContext context) {
        if (context.isDestory()) {
            return;
        }
        WXSDKInstance instance = context.getInstance();
        WXDomObject domObject = context.getDomByRef(this.mRef);
        WXDomObject parentObject = context.getDomByRef(this.mParentRef);
        if (domObject == null || domObject.parent == null || parentObject == null || parentObject.hasNewLayout()) {
            if (instance != null) {
                WXExceptionUtils.commitCriticalExceptionRT(instance.getInstanceId(), WXErrorCode.WX_KEY_EXCEPTION_DOM_MOVE_ELEMENT, "moveElement", WXErrorCode.WX_KEY_EXCEPTION_DOM_MOVE_ELEMENT.getErrorMsg() + "domObject = " + domObject + "domObject.parent= " + domObject.parent + "parentObject = " + parentObject + "parentObject.hasNewLayout() =" + parentObject.hasNewLayout(), null);
            }
            return;
        }
        int index = this.mIndex;
        if (domObject.parent.equals(parentObject)) {
            if (parentObject.index(domObject) == index) {
                return;
            }
            if (domObject.parent.index(domObject) < index) {
                --index;
            }
        }
        this.mNewIndex = index;
        domObject.parent.remove(domObject);
        parentObject.add(domObject, this.mNewIndex);
        context.postRenderTask(this);
    }

    @Override
    public void executeRender(RenderActionContext context) {
        WXComponent component = context.getComponent(this.mRef);
        WXComponent newParent = context.getComponent(this.mParentRef);
        if (component == null || component.getParent() == null || newParent == null || !(newParent instanceof WXVContainer)) {
            return;
        }
        WXVContainer oldParent = component.getParent();
        oldParent.remove(component, false);
        ((WXVContainer)newParent).addChild(component, this.mNewIndex);
        if (!component.isVirtualComponent()) {
            ((WXVContainer)newParent).addSubView((View)component.getHostView(), this.mNewIndex);
        }
    }
}

