/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.dom.action;

import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.common.WXErrorCode;
import com.taobao.weex.dom.DOMAction;
import com.taobao.weex.dom.DOMActionContext;
import com.taobao.weex.dom.RenderAction;
import com.taobao.weex.dom.RenderActionContext;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.dom.action.TraceableAction;
import com.taobao.weex.tracing.Stopwatch;
import com.taobao.weex.tracing.WXTracing;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.utils.WXExceptionUtils;
import java.util.List;

class AddEventAction
extends TraceableAction
implements DOMAction,
RenderAction {
    private final String mRef;
    private final Object mEvent;
    private WXDomObject mUpdatedDom;

    AddEventAction(String ref, Object event) {
        this.mRef = ref;
        this.mEvent = event;
    }

    @Override
    public void executeDom(DOMActionContext context) {
        if (context.isDestory()) {
            return;
        }
        Stopwatch.tick();
        WXSDKInstance instance = context.getInstance();
        WXDomObject domObject = context.getDomByRef(this.mRef);
        if (domObject == null) {
            if (instance != null) {
                String event = JSONObject.toJSONString((Object)this.mEvent);
                StringBuilder sbErr = new StringBuilder().append("|mRef==" + this.mRef).append("|mEvent=" + event).append("|instance id = " + instance.getInstanceId()).append("|context = " + context.toString());
                if (!"_documentElement".equals(this.mRef)) {
                    WXExceptionUtils.commitCriticalExceptionRT(instance.getInstanceId(), WXErrorCode.WX_KEY_EXCEPTION_DOM_ADD_EVENT, "addEvent", WXErrorCode.WX_KEY_EXCEPTION_DOM_ADD_EVENT.getErrorMsg() + "| domObject is null |" + sbErr.toString(), null);
                }
            }
            return;
        }
        domObject.getEvents().addEvent(this.mEvent);
        this.mUpdatedDom = domObject;
        if (WXTracing.isAvailable() && this.mBeginEvent != null) {
            this.submitPerformance("addEventToDom", "X", instance.getInstanceId(), Stopwatch.tack(), Stopwatch.lastTickStamp(), true);
        }
        context.postRenderTask(this);
    }

    @Override
    public void executeRender(RenderActionContext context) {
        WXComponent comp = context.getComponent(this.mRef);
        if (comp != null) {
            Stopwatch.tick();
            comp.updateDom(this.mUpdatedDom);
            Stopwatch.split("updateDom");
            comp.addEvent(this.mEvent);
            Stopwatch.split("addEventToComponent");
            if (WXTracing.isAvailable() && this.mBeginEvent != null) {
                List<Stopwatch.ProcessEvent> events = Stopwatch.getProcessEvents();
                for (Stopwatch.ProcessEvent event : events) {
                    this.submitPerformance(event.fname, "X", comp.getInstanceId(), event.duration, event.startMillis, true);
                }
            }
        }
    }
}

