/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.dom.action;

import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.common.WXErrorCode;
import com.taobao.weex.dom.DOMActionContext;
import com.taobao.weex.dom.RenderActionContext;
import com.taobao.weex.dom.WXCellDomObject;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.dom.action.AbstractAddElementAction;
import com.taobao.weex.tracing.Stopwatch;
import com.taobao.weex.tracing.WXTracing;
import com.taobao.weex.ui.component.ComponentUtils;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.utils.WXLogUtils;
import java.util.List;

final class AddElementAction
extends AbstractAddElementAction {
    private final String mParentRef;
    private final int mAddIndex;
    private final JSONObject mData;
    private StringBuilder mErrMsg = new StringBuilder("AddElementAction Error:");
    private String mRef;

    AddElementAction(JSONObject data, String parentRef, int index) {
        this.mParentRef = parentRef;
        this.mAddIndex = index;
        this.mData = data;
    }

    @Override
    protected WXComponent createComponent(DOMActionContext context, WXDomObject domObject) {
        WXComponent comp = context.getCompByRef(this.mParentRef);
        if (comp == null || !(comp instanceof WXVContainer)) {
            this.mErrMsg.append("WXComponent comp = context.getCompByRef(mParentRef) is null or \n").append("!(comp instanceof WXVContainer)");
            return null;
        }
        if (domObject.getType().equals("cell-slot") && domObject instanceof WXCellDomObject) {
            return ComponentUtils.buildTree(domObject, (WXVContainer)comp);
        }
        return this.generateComponentTree(context, domObject, (WXVContainer)comp);
    }

    @Override
    protected void appendDomToTree(DOMActionContext context, WXDomObject domObject) {
        long startNanos = System.nanoTime();
        this.mRef = domObject.getRef();
        WXDomObject parent = context.getDomByRef(this.mParentRef);
        if (parent == null) {
            this.mErrMsg.append("parent = context.getDomByRef(mParentRef)) == null");
            return;
        }
        parent.add(domObject, this.mAddIndex);
        domObject.mDomThreadNanos += System.nanoTime() - startNanos;
    }

    @Override
    protected String getStatementName() {
        return "addDom";
    }

    @Override
    protected WXErrorCode getErrorCode() {
        return WXErrorCode.WX_KEY_EXCEPTION_DOM_ADD_ELEMENT;
    }

    @Override
    protected String getErrorMsg() {
        return this.mErrMsg.toString();
    }

    @Override
    public void executeDom(DOMActionContext context) {
        this.addDomInternal(context, this.mData);
    }

    @Override
    public void executeRender(RenderActionContext context) {
        WXComponent component = context.getComponent(this.mRef);
        WXSDKInstance instance = context.getInstance();
        if (instance == null || instance.getContext() == null) {
            WXLogUtils.e("instance is null or instance is destroy!");
            this.mErrMsg.append("instance is null or instance is destroy!");
            return;
        }
        try {
            WXVContainer parent = (WXVContainer)context.getComponent(this.mParentRef);
            if (parent == null || component == null) {
                this.mErrMsg.append("parent == null || component == null").append("parent=" + parent).append("component=" + component);
                return;
            }
            Stopwatch.tick();
            parent.addChild(component, this.mAddIndex);
            parent.createChildViewAt(this.mAddIndex);
            Stopwatch.split("createViewTree");
            component.applyLayoutAndEvent(component);
            Stopwatch.split("applyLayoutAndEvent");
            component.bindData(component);
            Stopwatch.split("bindData");
            if (WXTracing.isAvailable()) {
                String instanceId = context.getInstance().getInstanceId();
                List<Stopwatch.ProcessEvent> splits = Stopwatch.getProcessEvents();
                for (Stopwatch.ProcessEvent event : splits) {
                    this.submitPerformance(event.fname, "X", instanceId, event.duration, event.startMillis, true);
                }
            }
            component.mTraceInfo.uiQueueTime = this.mUIQueueTime;
            if (component.isLazy()) {
                component.onRenderFinish(0);
            } else {
                component.onRenderFinish(2);
            }
        }
        catch (Exception e) {
            WXLogUtils.e("add component failed.", e);
            this.mErrMsg.append("add component failed.").append(WXLogUtils.getStackTrace(e));
        }
        instance.onElementChange();
    }
}

