/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.dom;

import android.support.v4.util.ArrayMap;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.dom.WXCellDomObject;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class WXRecyclerDomObject
extends WXDomObject {
    private int mColumnCount = 1;
    private float mColumnWidth = -1.0f;
    private float mColumnGap = 32.0f;
    private float mAvailableWidth = 0.0f;
    private boolean mIsPreCalculateCellWidth = false;
    private float mLeftGap = 0.0f;
    private float mRightGap = 0.0f;
    private float[] spanOffsets;
    private List<WXCellDomObject> cellList;

    public float getAvailableWidth() {
        return WXViewUtils.getRealPxByWidth(this.mAvailableWidth, this.getViewPortWidth());
    }

    public int getLayoutType() {
        return this.getAttrs().getLayoutType();
    }

    public float getColumnGap() {
        return WXViewUtils.getRealPxByWidth(this.mColumnGap, this.getViewPortWidth());
    }

    public int getColumnCount() {
        return this.mColumnCount;
    }

    public float getColumnWidth() {
        return WXViewUtils.getRealPxByWidth(this.mColumnWidth, this.getViewPortWidth());
    }

    public float getLeftGap() {
        return WXViewUtils.getRealPxByWidth(this.mLeftGap, this.getViewPortWidth());
    }

    public float getRightGap() {
        return WXViewUtils.getRealPxByWidth(this.mRightGap, this.getViewPortWidth());
    }

    @Override
    public void add(WXDomObject child, int index) {
        if ("cell-slot".equals(child.getType()) && child instanceof WXCellDomObject) {
            if (this.cellList == null) {
                this.cellList = Collections.synchronizedList(new ArrayList());
            }
            this.cellList.add((WXCellDomObject)child);
        } else {
            super.add(child, index);
        }
        if ("cell".equals(child.getType()) || "cell-slot".equals(child.getType())) {
            if (!this.mIsPreCalculateCellWidth) {
                this.preCalculateCellWidth();
            }
            if (this.mColumnWidth != 0.0f && this.mColumnWidth != Float.NaN) {
                child.getStyles().put("width", (Object)Float.valueOf(this.mColumnWidth));
            }
        }
    }

    @Override
    public void remove(WXDomObject child) {
        if (this.cellList != null) {
            this.cellList.remove(child);
        }
        super.remove(child);
    }

    @Override
    public void removeFromDom(WXDomObject child) {
        if (this.cellList != null) {
            this.cellList.remove(child);
        }
        super.removeFromDom(child);
    }

    @Override
    public float getStyleWidth() {
        float width = super.getStyleWidth();
        if ((Float.isNaN(width) || width <= 0.0f) && (Float.isNaN(width = super.getLayoutWidth()) || width <= 0.0f)) {
            if (this.getStyles().containsKey("width")) {
                width = WXViewUtils.getRealPxByWidth(this.getStyles().containsKey("width") ? this.getStyles().getWidth(this.getViewPortWidth()) : this.getStyles().getDefaultWidth(), this.getViewPortWidth());
            }
            if ((Float.isNaN(width) || width <= 0.0f) && this.getParent() != null) {
                width = this.getParent().getLayoutWidth();
            }
        }
        if (Float.isNaN(width) || width <= 0.0f) {
            width = WXViewUtils.getRealPxByWidth(this.getViewPortWidth(), this.getViewPortWidth());
        }
        return width;
    }

    public void preCalculateCellWidth() {
        if (this.getAttrs() != null) {
            this.mColumnCount = this.getAttrs().getColumnCount();
            this.mColumnWidth = this.getAttrs().getColumnWidth();
            this.mColumnGap = this.getAttrs().getColumnGap();
            this.mLeftGap = WXUtils.getFloat(this.getAttrs().get("leftGap"), Float.valueOf(0.0f)).floatValue();
            this.mRightGap = WXUtils.getFloat(this.getAttrs().get("rightGap"), Float.valueOf(0.0f)).floatValue();
            this.mAvailableWidth = this.getStyleWidth() - this.getPadding().get(0) - this.getPadding().get(2);
            this.mAvailableWidth = WXViewUtils.getWebPxByWidth(this.mAvailableWidth, this.getViewPortWidth());
            if (-1 == this.mColumnCount && -1.0f == this.mColumnWidth) {
                this.mColumnCount = 1;
            } else if (-1.0f == this.mColumnWidth && -1 != this.mColumnCount) {
                this.mColumnWidth = (this.mAvailableWidth - this.mLeftGap - this.mRightGap - (float)(this.mColumnCount - 1) * this.mColumnGap) / (float)this.mColumnCount;
                this.mColumnWidth = this.mColumnWidth > 0.0f ? this.mColumnWidth : 0.0f;
            } else if (-1.0f != this.mColumnWidth && -1 == this.mColumnCount) {
                this.mColumnCount = Math.round((this.mAvailableWidth + this.mColumnGap) / (this.mColumnWidth + this.mColumnGap) - 0.5f);
                int n = this.mColumnCount = this.mColumnCount > 0 ? this.mColumnCount : 1;
                if (this.mColumnCount <= 0) {
                    this.mColumnCount = 1;
                }
                this.mColumnWidth = (this.mAvailableWidth + this.mColumnGap - this.mLeftGap - this.mRightGap) / (float)this.mColumnCount - this.mColumnGap;
            } else if (-1.0f != this.mColumnWidth && -1 != this.mColumnCount) {
                int columnCount = Math.round((this.mAvailableWidth + this.mColumnGap - this.mLeftGap - this.mRightGap) / (this.mColumnWidth + this.mColumnGap) - 0.5f);
                int n = this.mColumnCount = columnCount > this.mColumnCount ? this.mColumnCount : columnCount;
                if (this.mColumnCount <= 0) {
                    this.mColumnCount = 1;
                }
                this.mColumnWidth = (this.mAvailableWidth + this.mColumnGap - this.mLeftGap - this.mRightGap) / (float)this.mColumnCount - this.mColumnGap;
            }
            this.calcSpanOffset();
            this.mIsPreCalculateCellWidth = true;
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.d("preCalculateCellWidth mColumnGap :" + this.mColumnGap + " mColumnWidth:" + this.mColumnWidth + " mColumnCount:" + this.mColumnCount);
            }
        }
    }

    public boolean hasPreCalculateCellWidth() {
        return this.mIsPreCalculateCellWidth;
    }

    public void updateRecyclerAttr() {
        this.preCalculateCellWidth();
        if (this.mColumnWidth == 0.0f && this.mColumnWidth == Float.NaN) {
            WXLogUtils.w("preCalculateCellWidth mColumnGap :" + this.mColumnGap + " mColumnWidth:" + this.mColumnWidth + " mColumnCount:" + this.mColumnCount);
            return;
        }
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            WXDomObject domObject = this.getChild(i);
            if (!"cell".equals(domObject.getType())) continue;
            this.getChild(i).getStyles().put("width", (Object)Float.valueOf(this.mColumnWidth));
        }
    }

    @Override
    public void updateAttr(Map<String, Object> attrs) {
        super.updateAttr(attrs);
        if (attrs.containsKey("columnCount") || attrs.containsKey("columnGap") || attrs.containsKey("columnWidth")) {
            this.updateRecyclerAttr();
        }
    }

    @Override
    protected Map<String, String> getDefaultStyle() {
        String prop;
        ArrayMap map = new ArrayMap();
        boolean isVertical = true;
        if (this.parent != null && this.parent.getType() != null) {
            if (this.parent.getType().equals("hlist")) {
                isVertical = false;
            } else if (this.getOrientation() == 0) {
                isVertical = false;
            }
        }
        String string2 = prop = isVertical ? "height" : "width";
        if (this.getStyles().get(prop) == null && this.getStyles().get("flex") == null) {
            map.put("flex", "1");
        }
        return map;
    }

    public int getOrientation() {
        String direction = (String)this.getAttrs().get("scrollDirection");
        if ("horizontal".equals(direction)) {
            return 0;
        }
        return 1;
    }

    @Override
    public WXDomObject clone() {
        if (this.isCloneThis()) {
            return this;
        }
        WXRecyclerDomObject domObject = (WXRecyclerDomObject)super.clone();
        domObject.cellList = this.cellList;
        return domObject;
    }

    public void calcSpanOffset() {
        if (this.mLeftGap > 0.0f || this.mRightGap > 0.0f) {
            if (this.spanOffsets == null || this.spanOffsets.length != this.mColumnCount) {
                this.spanOffsets = new float[this.mColumnCount];
            }
            for (int i = 0; i < this.mColumnCount; ++i) {
                this.spanOffsets[i] = this.mLeftGap + (float)i * (this.mColumnWidth + this.mColumnGap - (this.mAvailableWidth + this.mColumnGap) / (float)this.mColumnCount);
            }
        }
    }

    public float[] getSpanOffsets() {
        return this.spanOffsets;
    }

    public List<WXCellDomObject> getCellList() {
        return this.cellList;
    }
}

