/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.dom;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.common.WXModule;
import com.taobao.weex.dom.DOMAction;
import com.taobao.weex.dom.RenderAction;
import com.taobao.weex.dom.action.Action;
import com.taobao.weex.dom.action.Actions;
import com.taobao.weex.dom.action.TraceableAction;
import com.taobao.weex.tracing.Stopwatch;
import com.taobao.weex.tracing.WXTracing;
import com.taobao.weex.utils.WXLogUtils;

public final class WXDomModule
extends WXModule {
    public static final String CREATE_BODY = "createBody";
    public static final String UPDATE_ATTRS = "updateAttrs";
    public static final String UPDATE_STYLE = "updateStyle";
    public static final String REMOVE_ELEMENT = "removeElement";
    public static final String ADD_ELEMENT = "addElement";
    public static final String MOVE_ELEMENT = "moveElement";
    public static final String ADD_EVENT = "addEvent";
    public static final String REMOVE_EVENT = "removeEvent";
    public static final String CREATE_FINISH = "createFinish";
    public static final String REFRESH_FINISH = "refreshFinish";
    public static final String UPDATE_FINISH = "updateFinish";
    public static final String SCROLL_TO_ELEMENT = "scrollToElement";
    public static final String ADD_RULE = "addRule";
    public static final String UPDATE_COMPONENT_DATA = "updateComponentData";
    public static final String GET_COMPONENT_RECT = "getComponentRect";
    public static final String WXDOM = "dom";
    public static final String INVOKE_METHOD = "invokeMethod";
    public static final String[] METHODS = new String[]{"createBody", "updateAttrs", "updateStyle", "removeElement", "addElement", "moveElement", "addEvent", "removeEvent", "createFinish", "refreshFinish", "updateFinish", "scrollToElement", "addRule", "getComponentRect", "invokeMethod"};

    public WXDomModule(WXSDKInstance instance) {
        this.mWXSDKInstance = instance;
    }

    public void callDomMethod(JSONObject task, long ... parseNanos) {
        if (task == null) {
            return;
        }
        String method = (String)task.get((Object)"method");
        JSONArray args = (JSONArray)task.get((Object)"args");
        this.callDomMethod(method, args, parseNanos);
    }

    public Object callDomMethod(String method, JSONArray args, long ... parseNanos) {
        if (method == null) {
            return null;
        }
        try {
            Action action = Actions.get(method, args);
            if (action == null) {
                WXLogUtils.e("Unknown dom action " + method + " args " + (args == null ? " null" : args.toJSONString()));
                return null;
            }
            if (action instanceof DOMAction) {
                this.postAction((DOMAction)action, CREATE_BODY.equals(method) || ADD_RULE.equals(method));
            } else {
                this.postAction((RenderAction)action);
            }
            if (WXTracing.isAvailable() && action instanceof TraceableAction) {
                String ref = null;
                String type = null;
                if (args.size() > 0) {
                    if (args.size() >= 1) {
                        if (args.get(0) instanceof String) {
                            ref = args.getString(0);
                        } else if (args.get(0) instanceof JSONObject) {
                            ref = ((JSONObject)args.get(0)).getString("ref");
                            type = ((JSONObject)args.get(0)).getString("type");
                        }
                    }
                    if (args.size() >= 2 && args.get(1) instanceof JSONObject) {
                        ref = ((JSONObject)args.get(1)).getString("ref");
                        type = ((JSONObject)args.get(1)).getString("type");
                    }
                }
                if (parseNanos != null && parseNanos.length == 1) {
                    ((TraceableAction)((Object)action)).mParseJsonNanos = parseNanos[0];
                    ((TraceableAction)((Object)action)).mStartMillis = (long)((double)((TraceableAction)((Object)action)).mStartMillis - Stopwatch.nanosToMillis(parseNanos[0]));
                }
                ((TraceableAction)((Object)action)).onStartDomExecute(this.mWXSDKInstance.getInstanceId(), method, ref, type, args.toJSONString());
            }
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
            WXLogUtils.e("Dom module call miss arguments.");
        }
        catch (ClassCastException cce) {
            WXLogUtils.e("Dom module call arguments format error!!");
        }
        return null;
    }

    public void invokeMethod(String ref, String method, JSONArray args) {
        if (ref == null || method == null) {
            return;
        }
        this.postAction(Actions.getInvokeMethod(ref, method, args), false);
    }

    public void postAction(RenderAction action) {
        WXSDKManager.getInstance().getWXRenderManager().runOnThread(this.mWXSDKInstance.getInstanceId(), action);
    }

    public void postAction(DOMAction action, boolean createContext) {
        WXSDKManager.getInstance().getWXDomManager().postAction(this.mWXSDKInstance.getInstanceId(), action, createContext);
    }
}

