/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.bridge;

import android.text.TextUtils;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.common.WXJSService;
import java.util.HashMap;
import java.util.Map;

public class WXServiceManager {
    private static Map<String, WXJSService> sInstanceJSServiceMap = new HashMap<String, WXJSService>();

    public static boolean registerService(String name, String serviceScript, Map<String, Object> options) {
        if (TextUtils.isEmpty((CharSequence)name) || TextUtils.isEmpty((CharSequence)serviceScript)) {
            return false;
        }
        String param1 = "register: global.registerService, unregister: global.unregisterService";
        String param2 = "serviceName: \"" + name + "\"";
        for (String key : options.keySet()) {
            Object value = options.get(key);
            if (value instanceof String) {
                param2 = param2 + ", '" + key + "': '" + value + "'";
                continue;
            }
            param2 = param2 + ", '" + key + "': " + value;
        }
        String serviceJs = String.format(";(function(service, options){ ;%s; })({ %s }, { %s });", serviceScript, param1, param2);
        WXJSService service = new WXJSService();
        service.setName(name);
        service.setScript(serviceScript);
        service.setOptions(options);
        sInstanceJSServiceMap.put(name, service);
        WXBridgeManager.getInstance().execJSService(serviceJs);
        return true;
    }

    public static boolean unRegisterService(String name) {
        if (TextUtils.isEmpty((CharSequence)name)) {
            return false;
        }
        if (WXEnvironment.isApkDebugable()) {
            sInstanceJSServiceMap.remove(name);
        }
        String js = String.format("global.unregisterService( \"%s\" );", name);
        WXBridgeManager.getInstance().execJSService(js);
        return true;
    }

    public static void execAllCacheJsService() {
        for (String serviceName : sInstanceJSServiceMap.keySet()) {
            WXJSService service = sInstanceJSServiceMap.get(serviceName);
            WXServiceManager.registerService(service.getName(), service.getScript(), service.getOptions());
        }
    }

    public static WXJSService getService(String serviceName) {
        if (sInstanceJSServiceMap != null) {
            return sInstanceJSServiceMap.get(serviceName);
        }
        return null;
    }

    public static void reload() {
        WXBridgeManager.getInstance().post(new Runnable(){

            @Override
            public void run() {
                for (Map.Entry entry : sInstanceJSServiceMap.entrySet()) {
                    WXJSService service = (WXJSService)entry.getValue();
                    WXServiceManager.registerService(service.getName(), service.getScript(), service.getOptions());
                }
            }
        });
    }
}

