/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.bridge;

import android.text.TextUtils;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.bridge.WXJSObject;
import com.taobao.weex.bridge.WXParams;
import com.taobao.weex.common.IWXBridge;
import com.taobao.weex.utils.WXJsonUtils;
import com.taobao.weex.utils.WXLogUtils;

class WXBridge
implements IWXBridge {
    public static final String TAG = "WXBridge";
    public static final boolean MULTIPROCESS = true;

    WXBridge() {
    }

    @Override
    public native int initFramework(String var1, WXParams var2);

    public native int initFrameworkMultiProcess(String var1, WXParams var2, String var3, boolean var4);

    @Override
    public native int execJS(String var1, String var2, String var3, WXJSObject[] var4);

    @Override
    public native int createInstanceContext(String var1, String var2, String var3, WXJSObject[] var4);

    @Override
    public native int destoryInstance(String var1, String var2, String var3, WXJSObject[] var4);

    @Override
    public native byte[] execJSWithResult(String var1, String var2, String var3, WXJSObject[] var4);

    @Override
    public native int execJSService(String var1);

    @Override
    public native String execJSOnInstance(String var1, String var2, int var3);

    @Override
    public native void takeHeapSnapshot(String var1);

    public native void updateGlobalConfig(String var1);

    @Override
    public int initFrameworkEnv(String framework, WXParams params, String cacheDir, boolean pieSupport) {
        return this.initFrameworkMultiProcess(framework, params, cacheDir, pieSupport);
    }

    public int callNative(String instanceId, byte[] tasks, String callback) {
        try {
            return this.callNative(instanceId, (JSONArray)WXJsonUtils.parseWson(tasks), callback);
        }
        catch (Throwable e) {
            WXLogUtils.e(TAG, "callNative throw exception:" + e.getMessage());
            return 0;
        }
    }

    @Override
    public int callNative(String instanceId, JSONArray tasks, String callback) {
        long start = System.currentTimeMillis();
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(instanceId);
        if (instance != null) {
            instance.firstScreenCreateInstanceTime(start);
        }
        int errorCode = 1;
        try {
            errorCode = WXBridgeManager.getInstance().callNative(instanceId, tasks, callback);
        }
        catch (Throwable e) {
            WXLogUtils.e(TAG, "callNative throw exception:" + e.getMessage());
        }
        if (instance != null) {
            instance.callNativeTime(System.currentTimeMillis() - start);
        }
        if (WXEnvironment.isApkDebugable() && errorCode == -1) {
            WXLogUtils.w("destroyInstance :" + instanceId + " JSF must stop callNative");
        }
        return errorCode;
    }

    public int callAddElement(String instanceId, String ref, byte[] dom, String index, String callback) {
        try {
            return this.callAddElement(instanceId, ref, (JSONObject)WXJsonUtils.parseWson(dom), index, callback);
        }
        catch (Throwable e) {
            WXLogUtils.e(TAG, "callAddElement throw exception:" + e.getMessage());
            return 0;
        }
    }

    public int callCreateBody(String instanceId, byte[] tasks, String callback) {
        try {
            return this.callCreateBody(instanceId, new String(tasks), callback);
        }
        catch (Throwable e) {
            WXLogUtils.e(TAG, "callCreateBody throw exception:" + e.getMessage());
            return 0;
        }
    }

    @Override
    public int callCreateBody(String instanceId, String tasks, String callback) {
        long start = System.currentTimeMillis();
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(instanceId);
        if (instance != null) {
            instance.firstScreenCreateInstanceTime(start);
        }
        int errorCode = 1;
        try {
            errorCode = WXBridgeManager.getInstance().callCreateBody(instanceId, tasks, callback);
        }
        catch (Throwable e) {
            WXLogUtils.e(TAG, "callCreateBody throw exception:" + e.getMessage());
        }
        if (instance != null) {
            instance.callNativeTime(System.currentTimeMillis() - start);
        }
        return errorCode;
    }

    @Override
    public int callAddElement(String instanceId, String ref, JSONObject dom, String index, String callback) {
        long start = System.currentTimeMillis();
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(instanceId);
        if (instance != null) {
            instance.firstScreenCreateInstanceTime(start);
        }
        int errorCode = 1;
        try {
            errorCode = WXBridgeManager.getInstance().callAddElement(instanceId, ref, dom, index, callback);
        }
        catch (Throwable e) {
            e.printStackTrace();
            WXLogUtils.e(TAG, "callNative throw error:" + e.getMessage());
        }
        if (instance != null) {
            instance.callNativeTime(System.currentTimeMillis() - start);
        }
        if (errorCode == -1) {
            WXLogUtils.w("destroyInstance :" + instanceId + " JSF must stop callNative");
        }
        return errorCode;
    }

    @Override
    public void reportJSException(String instanceId, String func, String exception) {
        WXBridgeManager.getInstance().reportJSException(instanceId, func, exception);
    }

    @Override
    public Object callNativeModule(String instanceId, String module, String method, byte[] arguments, byte[] options) {
        JSONArray argArray = (JSONArray)WXJsonUtils.parseWson(arguments);
        JSONObject optionsObj = null;
        if (options != null) {
            optionsObj = (JSONObject)WXJsonUtils.parseWson(options);
        }
        Object object = WXBridgeManager.getInstance().callNativeModule(instanceId, module, method, argArray, optionsObj);
        return new WXJSObject(object);
    }

    @Override
    public void callNativeComponent(String instanceId, String componentRef, String method, byte[] arguments, byte[] options) {
        JSONArray argArray = (JSONArray)WXJsonUtils.parseWson(arguments);
        WXBridgeManager.getInstance().callNativeComponent(instanceId, componentRef, method, argArray, options);
    }

    public void setTimeoutNative(String callbackId, String time) {
        WXBridgeManager.getInstance().setTimeout(callbackId, time);
    }

    public void setJSFrmVersion(String version) {
        if (!TextUtils.isEmpty((CharSequence)version)) {
            WXEnvironment.JS_LIB_SDK_VERSION = version;
        }
    }

    @Override
    public int callUpdateFinish(String instanceId, byte[] tasks, String callback) {
        int errorCode;
        WXSDKInstance instance;
        long start;
        block4: {
            start = System.currentTimeMillis();
            instance = WXSDKManager.getInstance().getSDKInstance(instanceId);
            if (instance != null) {
                instance.firstScreenCreateInstanceTime(start);
            }
            errorCode = 1;
            try {
                errorCode = WXBridgeManager.getInstance().callUpdateFinish(instanceId, callback);
            }
            catch (Throwable e) {
                if (!WXEnvironment.isApkDebugable()) break block4;
                WXLogUtils.e(TAG, "callCreateBody throw exception:" + e.getMessage());
            }
        }
        if (instance != null) {
            instance.callNativeTime(System.currentTimeMillis() - start);
        }
        return errorCode;
    }

    @Override
    public int callCreateFinish(String instanceId, byte[] tasks, String callback) {
        long start = System.currentTimeMillis();
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(instanceId);
        if (instance != null) {
            instance.firstScreenCreateInstanceTime(start);
        }
        int errorCode = 1;
        try {
            errorCode = WXBridgeManager.getInstance().callCreateFinish(instanceId, callback);
        }
        catch (Throwable e) {
            WXLogUtils.e(TAG, "callCreateFinish throw exception:" + e.getMessage());
        }
        if (instance != null) {
            instance.callNativeTime(System.currentTimeMillis() - start);
        }
        return errorCode;
    }

    @Override
    public int callRefreshFinish(String instanceId, byte[] tasks, String callback) {
        int errorCode;
        WXSDKInstance instance;
        long start;
        block4: {
            start = System.currentTimeMillis();
            instance = WXSDKManager.getInstance().getSDKInstance(instanceId);
            if (instance != null) {
                instance.firstScreenCreateInstanceTime(start);
            }
            errorCode = 1;
            try {
                errorCode = WXBridgeManager.getInstance().callRefreshFinish(instanceId, callback);
            }
            catch (Throwable e) {
                if (!WXEnvironment.isApkDebugable()) break block4;
                WXLogUtils.e(TAG, "callCreateFinish throw exception:" + e.getMessage());
            }
        }
        if (instance != null) {
            instance.callNativeTime(System.currentTimeMillis() - start);
        }
        return errorCode;
    }

    @Override
    public int callUpdateAttrs(String instanceId, String ref, byte[] tasks, String callback) {
        int errorCode;
        WXSDKInstance instance;
        long start;
        block4: {
            start = System.currentTimeMillis();
            instance = WXSDKManager.getInstance().getSDKInstance(instanceId);
            if (instance != null) {
                instance.firstScreenCreateInstanceTime(start);
            }
            errorCode = 1;
            try {
                errorCode = WXBridgeManager.getInstance().callUpdateAttrs(instanceId, ref, tasks == null ? new String("") : new String(tasks), callback);
            }
            catch (Throwable e) {
                if (!WXEnvironment.isApkDebugable()) break block4;
                WXLogUtils.e(TAG, "callUpdateAttrs throw exception:" + e.getMessage());
            }
        }
        if (instance != null) {
            instance.callNativeTime(System.currentTimeMillis() - start);
        }
        return errorCode;
    }

    @Override
    public int callUpdateStyle(String instanceId, String ref, byte[] tasks, String callback) {
        int errorCode;
        WXSDKInstance instance;
        long start;
        block4: {
            start = System.currentTimeMillis();
            instance = WXSDKManager.getInstance().getSDKInstance(instanceId);
            if (instance != null) {
                instance.firstScreenCreateInstanceTime(start);
            }
            errorCode = 1;
            try {
                errorCode = WXBridgeManager.getInstance().callUpdateStyle(instanceId, ref, new String(tasks), callback);
            }
            catch (Throwable e) {
                if (!WXEnvironment.isApkDebugable()) break block4;
                WXLogUtils.e(TAG, "callUpdateStyle throw exception:" + e.getMessage());
            }
        }
        if (instance != null) {
            instance.callNativeTime(System.currentTimeMillis() - start);
        }
        return errorCode;
    }

    @Override
    public int callRemoveElement(String instanceId, String ref, String callback) {
        int errorCode;
        WXSDKInstance instance;
        long start;
        block4: {
            start = System.currentTimeMillis();
            instance = WXSDKManager.getInstance().getSDKInstance(instanceId);
            if (instance != null) {
                instance.firstScreenCreateInstanceTime(start);
            }
            errorCode = 1;
            try {
                errorCode = WXBridgeManager.getInstance().callRemoveElement(instanceId, ref, callback);
            }
            catch (Throwable e) {
                if (!WXEnvironment.isApkDebugable()) break block4;
                WXLogUtils.e(TAG, "callRemoveElement throw exception:" + e.getMessage());
            }
        }
        if (instance != null) {
            instance.callNativeTime(System.currentTimeMillis() - start);
        }
        return errorCode;
    }

    @Override
    public int callMoveElement(String instanceId, String ref, String parentref, String index, String callback) {
        int errorCode;
        WXSDKInstance instance;
        long start;
        block4: {
            start = System.currentTimeMillis();
            instance = WXSDKManager.getInstance().getSDKInstance(instanceId);
            if (instance != null) {
                instance.firstScreenCreateInstanceTime(start);
            }
            errorCode = 1;
            try {
                errorCode = WXBridgeManager.getInstance().callMoveElement(instanceId, ref, parentref, index, callback);
            }
            catch (Throwable e) {
                if (!WXEnvironment.isApkDebugable()) break block4;
                WXLogUtils.e(TAG, "callMoveElement throw exception:" + e.getMessage());
            }
        }
        if (instance != null) {
            instance.callNativeTime(System.currentTimeMillis() - start);
        }
        return errorCode;
    }

    @Override
    public int callAddEvent(String instanceId, String ref, String event, String callback) {
        long start = System.currentTimeMillis();
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(instanceId);
        if (instance != null) {
            instance.firstScreenCreateInstanceTime(start);
        }
        int errorCode = 1;
        try {
            errorCode = WXBridgeManager.getInstance().callAddEvent(instanceId, ref, event, callback);
        }
        catch (Throwable e) {
            WXLogUtils.e(TAG, "callAddEvent throw exception:" + e.getMessage());
        }
        if (instance != null) {
            instance.callNativeTime(System.currentTimeMillis() - start);
        }
        return errorCode;
    }

    @Override
    public int callRemoveEvent(String instanceId, String ref, String event, String callback) {
        int errorCode;
        WXSDKInstance instance;
        long start;
        block4: {
            start = System.currentTimeMillis();
            instance = WXSDKManager.getInstance().getSDKInstance(instanceId);
            if (instance != null) {
                instance.firstScreenCreateInstanceTime(start);
            }
            errorCode = 1;
            try {
                errorCode = WXBridgeManager.getInstance().callRemoveEvent(instanceId, ref, event, callback);
            }
            catch (Throwable e) {
                if (!WXEnvironment.isApkDebugable()) break block4;
                WXLogUtils.e(TAG, "callRemoveEvent throw exception:" + e.getMessage());
            }
        }
        if (instance != null) {
            instance.callNativeTime(System.currentTimeMillis() - start);
        }
        return errorCode;
    }

    @Override
    public void reportServerCrash(String instanceId, String crashFile) {
        block2: {
            WXLogUtils.e(TAG, "reportServerCrash instanceId:" + instanceId);
            int errorCode = 1;
            try {
                errorCode = WXBridgeManager.getInstance().callReportCrashReloadPage(instanceId, crashFile);
            }
            catch (Throwable e) {
                if (!WXEnvironment.isApkDebugable()) break block2;
                WXLogUtils.e(TAG, "reloadPageNative throw exception:" + e.getMessage());
            }
        }
    }
}

