/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.utils;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.LinearGradient;
import android.graphics.MaskFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.IntRange;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXResourceUtils;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BoxShadowUtil {
    private static final String TAG = "BoxShadowUtil";
    private static boolean sBoxShadowEnabled = true;

    public static void setBoxShadowEnabled(boolean enabled) {
        sBoxShadowEnabled = enabled;
        WXLogUtils.w(TAG, "Switch box-shadow status: " + enabled);
    }

    public static boolean isBoxShadowEnabled() {
        return sBoxShadowEnabled;
    }

    public static void setBoxShadow(final View target, String style, float[] radii, int viewPort, final float quality) {
        if (!sBoxShadowEnabled) {
            WXLogUtils.w(TAG, "box-shadow was disabled by config");
            return;
        }
        final BoxShadowOptions options = BoxShadowUtil.parseBoxShadow(style, viewPort);
        if (options == null) {
            WXLogUtils.w(TAG, "Failed to parse box-shadow: " + style);
            return;
        }
        if (target == null) {
            WXLogUtils.w(TAG, "Target view is null!");
            return;
        }
        if (options.isClear && Build.VERSION.SDK_INT >= 18) {
            target.getOverlay().clear();
            WXLogUtils.d(TAG, "Remove box-shadow");
            return;
        }
        if (radii != null) {
            if (radii.length != 8) {
                WXLogUtils.w(TAG, "Length of radii must be 8");
            } else {
                for (int i = 0; i < radii.length; ++i) {
                    float realRadius;
                    radii[i] = realRadius = WXViewUtils.getRealSubPxByWidth(radii[i], viewPort);
                }
                options.radii = radii;
            }
        }
        WXLogUtils.d(TAG, "Set box-shadow: " + options.toString());
        target.post(new Runnable(){

            @Override
            public void run() {
                if (options.isInset) {
                    BoxShadowUtil.setInsetBoxShadow(target, options, quality);
                } else {
                    BoxShadowUtil.setNormalBoxShadow(target, options, quality);
                }
            }
        });
    }

    private static Bitmap createShadowBitmap(int viewWidth, int viewHeight, float[] radii, float shadowRadius, float shadowSpread, float dx, float dy, int shadowColor) {
        int canvasWidth = viewWidth + 2 * (int)(shadowRadius + shadowSpread + Math.abs(dx));
        int canvasHeight = viewHeight + 2 * (int)(shadowRadius + shadowSpread + Math.abs(dy));
        Bitmap output = Bitmap.createBitmap((int)canvasWidth, (int)canvasHeight, (Bitmap.Config)Bitmap.Config.ARGB_4444);
        if (Build.VERSION.SDK_INT >= 19) {
            WXLogUtils.d(TAG, "Allocation memory for box-shadow: " + output.getAllocationByteCount() / 1024 + " KB");
        }
        Canvas canvas = new Canvas(output);
        RectF shadowRect = new RectF(0.0f, 0.0f, (float)viewWidth + 2.0f * shadowSpread, (float)viewHeight + 2.0f * shadowSpread);
        float shadowDx = shadowRadius;
        float shadowDy = shadowRadius;
        if (dx > 0.0f) {
            shadowDx += 2.0f * dx;
        }
        if (dy > 0.0f) {
            shadowDy += 2.0f * dy;
        }
        shadowRect.offset(shadowDx, shadowDy);
        Paint shadowPaint = new Paint();
        shadowPaint.setAntiAlias(true);
        shadowPaint.setColor(shadowColor);
        shadowPaint.setStyle(Paint.Style.FILL);
        if (shadowRadius > 0.0f) {
            shadowPaint.setMaskFilter((MaskFilter)new BlurMaskFilter(shadowRadius, BlurMaskFilter.Blur.NORMAL));
        }
        Path shadowPath = new Path();
        float[] shadowRadii = new float[8];
        for (int i = 0; i < radii.length; ++i) {
            float contentRadius = radii[i];
            shadowRadii[i] = contentRadius == 0.0f ? 0.0f : radii[i] + shadowSpread;
        }
        shadowPath.addRoundRect(shadowRect, shadowRadii, Path.Direction.CCW);
        canvas.drawPath(shadowPath, shadowPaint);
        return output;
    }

    private static void setNormalBoxShadow(View target, BoxShadowOptions options, float quality) {
        int h = target.getHeight();
        int w = target.getWidth();
        if (h == 0 || w == 0) {
            Log.w((String)TAG, (String)"Target view is invisible, ignore set shadow.");
            return;
        }
        if (Build.VERSION.SDK_INT >= 18) {
            options.viewWidth = w;
            options.viewHeight = h;
            BoxShadowOptions scaleOptions = options.scale(quality);
            Bitmap shadowBitmap = BoxShadowUtil.createShadowBitmap(scaleOptions.viewWidth, scaleOptions.viewHeight, scaleOptions.radii, scaleOptions.blur, scaleOptions.spread, scaleOptions.hShadow, scaleOptions.vShadow, scaleOptions.color);
            OverflowBitmapDrawable shadowDrawable = new OverflowBitmapDrawable(target.getResources(), shadowBitmap, options);
            target.getOverlay().clear();
            target.getOverlay().add((Drawable)shadowDrawable);
            ViewParent parent = target.getParent();
            if (parent != null) {
                parent.requestLayout();
                if (parent instanceof ViewGroup) {
                    ((ViewGroup)parent).invalidate(shadowDrawable.getBounds());
                }
            }
        } else {
            Log.w((String)TAG, (String)"Call setNormalBoxShadow() requires API level 18 or higher.");
        }
    }

    private static void setInsetBoxShadow(View target, BoxShadowOptions options, float quality) {
        if (target == null || options == null) {
            WXLogUtils.w(TAG, "Illegal arguments");
            return;
        }
        if (target.getWidth() == 0 || target.getHeight() == 0) {
            WXLogUtils.w(TAG, "Target view is invisible, ignore set shadow.");
            return;
        }
        if (Build.VERSION.SDK_INT >= 18) {
            InsetShadowDrawable shadow = new InsetShadowDrawable(target.getWidth(), target.getHeight(), options.hShadow, options.vShadow, options.blur, options.spread, options.color, options.radii);
            target.getOverlay().clear();
            target.getOverlay().add((Drawable)shadow);
            target.invalidate();
        } else {
            Log.w((String)TAG, (String)"Call setInsetBoxShadow() requires API level 18 or higher.");
        }
    }

    public static BoxShadowOptions parseBoxShadow(String boxShadow, int viewport) {
        ArrayList<String> params;
        String maybeColor;
        BoxShadowOptions result = new BoxShadowOptions(viewport);
        if (TextUtils.isEmpty((CharSequence)boxShadow)) {
            result.isClear = true;
            return result;
        }
        String boxShadowCopy = boxShadow;
        if ((boxShadowCopy = boxShadowCopy.replaceAll("\\s*,\\s+", ",")).contains("inset")) {
            result.isInset = true;
            boxShadowCopy = boxShadowCopy.replace("inset", "").trim();
        }
        if (!TextUtils.isEmpty((CharSequence)(maybeColor = (String)(params = new ArrayList<String>(Arrays.asList(boxShadowCopy.split("\\s+")))).get(params.size() - 1))) && (maybeColor.startsWith("#") || maybeColor.startsWith("rgb") || WXResourceUtils.isNamedColor(maybeColor))) {
            result.color = WXResourceUtils.getColor(maybeColor, -16777216);
            params.remove(params.size() - 1);
        }
        try {
            float px;
            if (params.size() < 2) {
                return null;
            }
            if (!TextUtils.isEmpty((CharSequence)((CharSequence)params.get(0)))) {
                px = WXUtils.getFloat(((String)params.get(0)).trim(), Float.valueOf(0.0f)).floatValue();
                result.hShadow = WXViewUtils.getRealSubPxByWidth(px, viewport);
            }
            if (!TextUtils.isEmpty((CharSequence)((CharSequence)params.get(1)))) {
                px = WXUtils.getFloat(((String)params.get(1)).trim(), Float.valueOf(0.0f)).floatValue();
                result.vShadow = WXViewUtils.getRealPxByWidth(px, viewport);
            }
            for (int i = 2; i < params.size(); ++i) {
                int parserIndex = i - 2;
                BoxShadowOptions.IParser parser = (BoxShadowOptions.IParser)result.optionParamParsers.get(parserIndex);
                parser.parse((String)params.get(i));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return result;
    }

    public static class BoxShadowOptions {
        private List<IParser> optionParamParsers;
        private int viewport = 750;
        public float hShadow;
        public float vShadow;
        public float blur = 0.0f;
        public float spread = 0.0f;
        public float[] radii = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
        public int color = -16777216;
        public boolean isInset = false;
        public boolean isClear = false;
        public int viewWidth = 0;
        public int viewHeight = 0;

        private BoxShadowOptions(int vp) {
            if (this.viewport != 0) {
                this.viewport = vp;
            }
            this.optionParamParsers = new ArrayList<IParser>();
            IParser spreadParser = new IParser(){

                @Override
                public void parse(String param) {
                    if (!TextUtils.isEmpty((CharSequence)param)) {
                        float px = WXUtils.getFloat(param, Float.valueOf(0.0f)).floatValue();
                        BoxShadowOptions.this.spread = WXViewUtils.getRealSubPxByWidth(px, BoxShadowOptions.this.viewport);
                        WXLogUtils.w(BoxShadowUtil.TAG, "Experimental box-shadow attribute: spread");
                    }
                }
            };
            IParser blurParser = new IParser(){

                @Override
                public void parse(String param) {
                    if (!TextUtils.isEmpty((CharSequence)param)) {
                        float px = WXUtils.getFloat(param, Float.valueOf(0.0f)).floatValue();
                        BoxShadowOptions.this.blur = WXViewUtils.getRealSubPxByWidth(px, BoxShadowOptions.this.viewport);
                    }
                }
            };
            this.optionParamParsers.add(blurParser);
            this.optionParamParsers.add(spreadParser);
        }

        public BoxShadowOptions scale(float scale) {
            if (scale > 0.0f && scale <= 1.0f) {
                BoxShadowOptions scaledOptions = new BoxShadowOptions(this.viewport);
                scaledOptions.hShadow = this.hShadow * scale;
                scaledOptions.vShadow = this.vShadow * scale;
                scaledOptions.blur = this.blur * scale;
                scaledOptions.spread = this.spread * scale;
                for (int i = 0; i < this.radii.length; ++i) {
                    scaledOptions.radii[i] = this.radii[i] * scale;
                }
                scaledOptions.viewHeight = (int)((float)this.viewHeight * scale);
                scaledOptions.viewWidth = (int)((float)this.viewWidth * scale);
                scaledOptions.color = this.color;
                scaledOptions.isInset = this.isInset;
                scaledOptions.isClear = this.isClear;
                WXLogUtils.d(BoxShadowUtil.TAG, "Scaled BoxShadowOptions: [" + scale + "] " + scaledOptions);
                return scaledOptions;
            }
            return null;
        }

        public String toString() {
            String r = "[" + this.radii[0] + "," + this.radii[2] + "," + this.radii[4] + "," + this.radii[6] + "]";
            StringBuffer sb = new StringBuffer("BoxShadowOptions{");
            sb.append("h-shadow=").append(this.hShadow);
            sb.append(", v-shadow=").append(this.vShadow);
            sb.append(", blur=").append(this.blur);
            sb.append(", spread=").append(this.spread);
            sb.append(", corner-radius=").append(r);
            sb.append(", color=#").append(Integer.toHexString(this.color));
            sb.append(", inset=").append(this.isInset);
            sb.append('}');
            return sb.toString();
        }

        private static interface IParser {
            public void parse(String var1);
        }
    }

    private static class InsetShadowDrawable
    extends Drawable {
        private static final int LEFT_TO_RIGHT = 0;
        private static final int TOP_TO_BOTTOM = 1;
        private static final int RIGHT_TO_LEFT = 2;
        private static final int BOTTOM_TO_TOP = 3;
        private float blurRadius;
        private int shadowColor;
        private float[] radii;
        private float width;
        private float height;
        private float shadowXSize;
        private float shadowYSize;
        private Shader[] shades = new Shader[4];
        private Path[] paths = new Path[4];
        private Paint paint;

        private InsetShadowDrawable(int viewWidth, int viewHeight, float dx, float dy, float blurRadius, float spread, int shadowColor, float[] radii) {
            this.blurRadius = blurRadius;
            this.shadowColor = shadowColor;
            this.width = (float)viewWidth + 2.0f * dx;
            this.height = (float)viewHeight + 2.0f * dy;
            this.shadowXSize = dx + spread;
            this.shadowYSize = dy + spread;
            this.radii = radii;
            this.setBounds(0, 0, viewWidth, viewHeight);
            this.prepare();
        }

        private void prepare() {
            PointF a = new PointF(0.0f, 0.0f);
            PointF b = new PointF(this.width, 0.0f);
            PointF c = new PointF(b.x, this.height);
            PointF d = new PointF(a.x, c.y);
            PointF e = new PointF(this.shadowXSize, this.shadowYSize);
            PointF f = new PointF(b.x - this.shadowXSize, e.y);
            PointF g = new PointF(f.x, c.y - this.shadowYSize);
            PointF h = new PointF(e.x, g.y);
            LinearGradient ltr = new LinearGradient(e.x - this.blurRadius, e.y, e.x, e.y, this.shadowColor, 0, Shader.TileMode.CLAMP);
            LinearGradient ttb = new LinearGradient(e.x, e.y - this.blurRadius, e.x, e.y, this.shadowColor, 0, Shader.TileMode.CLAMP);
            LinearGradient rtl = new LinearGradient(g.x + this.blurRadius, g.y, g.x, g.y, this.shadowColor, 0, Shader.TileMode.CLAMP);
            LinearGradient btt = new LinearGradient(g.x, g.y + this.blurRadius, g.x, g.y, this.shadowColor, 0, Shader.TileMode.CLAMP);
            this.shades[0] = ltr;
            this.shades[1] = ttb;
            this.shades[2] = rtl;
            this.shades[3] = btt;
            Path ltrPath = new Path();
            ltrPath.moveTo(a.x, a.y);
            ltrPath.lineTo(e.x, e.y);
            ltrPath.lineTo(h.x, h.y);
            ltrPath.lineTo(d.x, d.y);
            ltrPath.close();
            Path ttbPath = new Path();
            ttbPath.moveTo(a.x, a.y);
            ttbPath.lineTo(b.x, b.y);
            ttbPath.lineTo(f.x, f.y);
            ttbPath.lineTo(e.x, e.y);
            ttbPath.close();
            Path rtlPath = new Path();
            rtlPath.moveTo(b.x, b.y);
            rtlPath.lineTo(c.x, c.y);
            rtlPath.lineTo(g.x, g.y);
            rtlPath.lineTo(f.x, f.y);
            rtlPath.close();
            Path bttPath = new Path();
            bttPath.moveTo(d.x, d.y);
            bttPath.lineTo(c.x, c.y);
            bttPath.lineTo(g.x, g.y);
            bttPath.lineTo(h.x, h.y);
            bttPath.close();
            this.paths[0] = ltrPath;
            this.paths[1] = ttbPath;
            this.paths[2] = rtlPath;
            this.paths[3] = bttPath;
            this.paint = new Paint();
            this.paint.setAntiAlias(true);
            this.paint.setStyle(Paint.Style.FILL);
            this.paint.setColor(this.shadowColor);
        }

        public void draw(Canvas canvas) {
            Path border = new Path();
            RectF rectF = new RectF(0.0f, 0.0f, (float)canvas.getWidth(), (float)canvas.getHeight());
            border.addRoundRect(rectF, this.radii, Path.Direction.CCW);
            canvas.clipPath(border);
            for (int i = 0; i < 4; ++i) {
                Shader shader = this.shades[i];
                Path path = this.paths[i];
                this.paint.setShader(shader);
                canvas.drawPath(path, this.paint);
            }
        }

        public void setAlpha(@IntRange(from=0L, to=255L) int alpha) {
        }

        public void setColorFilter(@Nullable ColorFilter colorFilter) {
        }

        public int getOpacity() {
            return -1;
        }
    }

    private static class OverflowBitmapDrawable
    extends BitmapDrawable {
        private int paddingX;
        private int paddingY;
        private BoxShadowOptions options;

        private OverflowBitmapDrawable(Resources resources, Bitmap bitmap, BoxShadowOptions options) {
            super(resources, bitmap);
            this.paddingX = (int)(options.blur + Math.abs(options.hShadow) + options.spread);
            this.paddingY = (int)(options.blur + Math.abs(options.vShadow) + options.spread);
            this.options = options;
            this.setBounds(-this.paddingX, -this.paddingY, options.viewWidth + this.paddingX, options.viewHeight + this.paddingY);
        }

        public void draw(Canvas canvas) {
            Rect newRect = canvas.getClipBounds();
            newRect.inset(-this.paddingX * 2, -this.paddingY * 2);
            canvas.clipRect(newRect, Region.Op.REPLACE);
            Path contentPath = new Path();
            RectF rectF = new RectF(0.0f, 0.0f, (float)this.options.viewWidth, (float)this.options.viewHeight);
            contentPath.addRoundRect(rectF, this.options.radii, Path.Direction.CCW);
            canvas.clipPath(contentPath, Region.Op.DIFFERENCE);
            super.draw(canvas);
        }
    }
}

