/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.module;

import android.app.Application;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import android.os.LocaleList;
import android.text.TextUtils;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.annotation.JSMethod;
import com.taobao.weex.bridge.JSCallback;
import com.taobao.weex.common.WXModule;
import java.util.Locale;

public class WXLocalModule
extends WXModule {
    @JSMethod
    public void getLanguage(JSCallback callback) {
        callback.invoke(this.getLanguageTags());
    }

    @JSMethod
    public void getLanguages(JSCallback callback) {
        callback.invoke(this.getLanguageTags().split(","));
    }

    private String getLanguageTags() {
        Configuration configuration;
        Resources res;
        Application application = WXEnvironment.getApplication();
        if (application != null && (res = application.getResources()) != null && (configuration = res.getConfiguration()) != null) {
            if (Build.VERSION.SDK_INT >= 24) {
                LocaleList localeList = configuration.getLocales();
                return localeList.toLanguageTags();
            }
            Locale local = configuration.locale;
            if (local != null) {
                return this.toLanguageTag(local);
            }
        }
        return "";
    }

    private String toLanguageTag(Locale locale) {
        if (Build.VERSION.SDK_INT >= 21) {
            return locale.toLanguageTag();
        }
        StringBuilder sb = new StringBuilder();
        String language = locale.getLanguage();
        String script = locale.getScript();
        String region = locale.getCountry();
        sb.append(language);
        if (!TextUtils.isEmpty((CharSequence)script)) {
            sb.append("-").append(script);
        }
        if (!TextUtils.isEmpty((CharSequence)region)) {
            sb.append("-").append(region);
        }
        return sb.toString();
    }
}

