/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component.binding;

import android.os.Looper;
import android.support.v4.util.ArrayMap;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.dom.WXAttr;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.dom.WXEvent;
import com.taobao.weex.dom.binding.WXStatement;
import com.taobao.weex.el.parse.ArrayStack;
import com.taobao.weex.el.parse.Operators;
import com.taobao.weex.el.parse.Token;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentFactory;
import com.taobao.weex.ui.component.WXImage;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.component.list.WXCell;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Statements {
    private static final ThreadLocal<Map<String, Object>> dynamicLocal = new ThreadLocal();

    public static WXComponent copyComponentTree(WXComponent component) {
        long start = System.currentTimeMillis();
        WXComponent copy = Statements.copyComponentTree(component, component.getParent());
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.d("WXRecyclerTemplateList", Thread.currentThread() + component.getRef() + "copyComponentTree used " + (System.currentTimeMillis() - start));
        }
        return copy;
    }

    private static final WXComponent copyComponentTree(WXComponent source, WXVContainer parent) {
        WXDomObject node = (WXDomObject)source.getDomObject();
        WXComponent component = WXComponentFactory.newInstance(source.getInstance(), node, parent);
        if (source instanceof WXVContainer) {
            WXVContainer container = (WXVContainer)source;
            WXVContainer childParent = (WXVContainer)component;
            WXDomObject childParentNode = (WXDomObject)childParent.getDomObject();
            int count = container.getChildCount();
            for (int i = 0; i < count; ++i) {
                WXComponent child = container.getChild(i);
                if (child == null) continue;
                WXComponent targetChild = Statements.copyComponentTree(child, childParent);
                childParent.addChild(targetChild);
                childParentNode.add((WXDomObject)targetChild.getDomObject(), -1);
            }
        }
        return component;
    }

    public static final List<WXComponent> doRender(WXComponent component, ArrayStack stack) {
        ArrayList<WXComponent> updates = new ArrayList<WXComponent>(4);
        try {
            Statements.doRenderComponent(component, stack, updates);
        }
        catch (Exception e) {
            WXLogUtils.e("WeexStatementRender", e);
        }
        return updates;
    }

    public static final void doInitCompontent(List<WXComponent> updates) {
        if (updates == null || updates.size() == 0) {
            return;
        }
        for (WXComponent renderNode : updates) {
            if (renderNode.getParent() == null) {
                throw new IllegalArgumentException("render node parent cann't find");
            }
            WXVContainer parent = renderNode.getParent();
            int renderIndex = parent.indexOf(renderNode);
            if (renderIndex < 0) {
                throw new IllegalArgumentException("render node cann't find");
            }
            parent.createChildViewAt(renderIndex);
            renderNode.applyLayoutAndEvent(renderNode);
            renderNode.bindData(renderNode);
        }
    }

    private static final int doRenderComponent(WXComponent component, ArrayStack context, List<WXComponent> updates) {
        WXVContainer parent = component.getParent();
        WXDomObject domObject = (WXDomObject)component.getDomObject();
        WXAttr attrs = domObject.getAttrs();
        WXStatement statement = attrs.getStatement();
        if (statement != null) {
            WXDomObject parentDomObject = (WXDomObject)parent.getDomObject();
            Token vif = null;
            JSONObject vfor = null;
            if (statement.get("[[match]]") instanceof Token) {
                vif = (Token)statement.get("[[match]]");
            }
            if (statement.get("[[repeat]]") instanceof JSONObject) {
                vfor = (JSONObject)statement.get("[[repeat]]");
            }
            if (vfor != null) {
                WXComponent wasteNode;
                int renderIndex = parent.indexOf(component);
                if (vfor.get((Object)"@expression") instanceof Token) {
                    Token listBlock = (Token)vfor.get((Object)"@expression");
                    String indexKey = vfor.getString("@index");
                    String itemKey = vfor.getString("@alias");
                    Object data = null;
                    if (listBlock != null) {
                        data = listBlock.execute(context);
                    }
                    if (data instanceof List || data instanceof Map) {
                        Collection<Object> collection = null;
                        Map map = null;
                        if (data instanceof List) {
                            collection = (List)data;
                        } else {
                            map = (Map)data;
                            collection = map.keySet();
                        }
                        HashMap<String, Object> loop = new HashMap<String, Object>();
                        int index = 0;
                        for (Object item : collection) {
                            Object key = null;
                            Object value = item;
                            if (map == null) {
                                key = index;
                                value = item;
                            } else {
                                key = item;
                                value = map.get(item);
                            }
                            if (indexKey != null) {
                                loop.put(indexKey, key);
                            }
                            if (itemKey != null) {
                                loop.put(itemKey, value);
                            } else {
                                context.push(value);
                            }
                            if (loop.size() > 0) {
                                context.push(loop);
                            }
                            if (vif != null && !Operators.isTrue(vif.execute(context))) continue;
                            WXComponent renderNode = null;
                            if (renderIndex < parent.getChildCount()) {
                                renderNode = parent.getChild(renderIndex);
                                if (!Statements.isCreateFromNodeStatement(renderNode, component)) {
                                    renderNode = null;
                                }
                                if (renderNode != null && renderNode.isWaste()) {
                                    renderNode.setWaste(false);
                                }
                            }
                            if (renderNode == null) {
                                long start = System.currentTimeMillis();
                                renderNode = Statements.copyComponentTree(component, parent);
                                WXDomObject renderNodeDomObject = (WXDomObject)renderNode.getDomObject();
                                renderNodeDomObject.getAttrs().setStatement(null);
                                parentDomObject.add(renderNodeDomObject, renderIndex);
                                parent.addChild(renderNode, renderIndex);
                                updates.add(renderNode);
                                if (WXEnvironment.isApkDebugable()) {
                                    WXLogUtils.d("WXRecyclerTemplateList", Thread.currentThread().getName() + renderNode.getRef() + renderNode.getDomObject().getType() + "statements copy component tree used " + (System.currentTimeMillis() - start));
                                }
                            }
                            Statements.doBindingAttrsEventAndRenderChildNode(renderNode, domObject, context, updates);
                            ++renderIndex;
                            if (loop.size() > 0) {
                                context.push(loop);
                            }
                            if (itemKey != null) continue;
                            context.pop();
                        }
                    }
                } else {
                    WXLogUtils.e("WXRecyclerTemplateList", vfor.toJSONString() + " not call vfor block, for pre compile");
                }
                while (renderIndex < parent.getChildCount() && Statements.isCreateFromNodeStatement(wasteNode = parent.getChild(renderIndex), component)) {
                    wasteNode.setWaste(true);
                    ++renderIndex;
                }
                return renderIndex - parent.indexOf(component);
            }
            if (vif != null) {
                if (!Operators.isTrue(vif.execute(context))) {
                    component.setWaste(true);
                    if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
                        return 1;
                    }
                } else {
                    component.setWaste(false);
                }
            }
        }
        Statements.doBindingAttrsEventAndRenderChildNode(component, domObject, context, updates);
        return 1;
    }

    private static void doBindingAttrsEventAndRenderChildNode(WXComponent component, WXDomObject domObject, ArrayStack context, List<WXComponent> updates) {
        WXAttr attr = component.getDomObject().getAttrs();
        if (attr.get("@isComponentRoot") != null && WXUtils.getBoolean(attr.get("@isComponentRoot"), false).booleanValue() && attr.get("@componentProps") != null && attr.get("@componentProps") instanceof JSONObject) {
            Map<String, Object> props = Statements.renderProps((JSONObject)attr.get("@componentProps"), context);
            context = new ArrayStack<Map<String, Object>>();
            context.push(props);
        }
        Statements.doRenderBindingAttrsAndEvent(component, domObject, context);
        if (component instanceof WXVContainer) {
            WXComponent next;
            if (!domObject.isShow() && !(component instanceof WXCell) && Thread.currentThread() == Looper.getMainLooper().getThread()) {
                return;
            }
            WXVContainer container = (WXVContainer)component;
            for (int k = 0; k < container.getChildCount(); k += Statements.doRenderComponent(next, context, updates)) {
                next = container.getChild(k);
            }
        }
    }

    private static boolean isCreateFromNodeStatement(WXComponent renderNode, WXComponent component) {
        return renderNode.getRef() != null && renderNode.getRef().equals(component.getRef());
    }

    private static void doRenderBindingAttrsAndEvent(WXComponent component, WXDomObject domObject, ArrayStack context) {
        WXEvent event;
        component.setWaste(false);
        WXAttr attr = domObject.getAttrs();
        if (attr != null && attr.getBindingAttrs() != null && attr.getBindingAttrs().size() > 0) {
            ArrayMap<String, Object> bindAttrs = domObject.getAttrs().getBindingAttrs();
            Map<String, Object> dynamic = Statements.renderBindingAttrs(bindAttrs, context);
            Set<Map.Entry<String, Object>> entries = dynamic.entrySet();
            Iterator<Map.Entry<String, Object>> iterator = entries.iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String key = entry.getKey();
                if (entry.getValue() == null && attr.get(key) == null) {
                    iterator.remove();
                    continue;
                }
                if (!entry.getValue().equals(attr.get(key))) continue;
                iterator.remove();
            }
            if (dynamic.size() > 0) {
                if (dynamic.size() == 1 && dynamic.get("src") != null && component instanceof WXImage) {
                    domObject.getAttrs().put("src", dynamic.get("src"));
                } else {
                    domObject.updateAttr(dynamic);
                }
                if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
                    component.updateProperties(dynamic);
                }
                dynamic.clear();
            }
        }
        if ((event = domObject.getEvents()) == null || event.getEventBindingArgs() == null) {
            return;
        }
        Set eventBindArgsEntrySet = event.getEventBindingArgs().entrySet();
        for (Map.Entry eventBindArgsEntry : eventBindArgsEntrySet) {
            List<Object> values = Statements.getBindingEventArgs(context, eventBindArgsEntry.getValue());
            if (values == null) continue;
            event.putEventBindingArgsValue((String)eventBindArgsEntry.getKey(), values);
        }
    }

    public static Map<String, Object> renderBindingAttrs(ArrayMap bindAttrs, ArrayStack context) {
        Set entrySet = bindAttrs.entrySet();
        Map<String, Object> dynamic = dynamicLocal.get();
        if (dynamic == null) {
            dynamic = new HashMap<String, Object>();
            dynamicLocal.set(dynamic);
        }
        if (dynamic.size() > 0) {
            dynamic.clear();
        }
        for (Map.Entry entry : entrySet) {
            Object value = entry.getValue();
            String key = (String)entry.getKey();
            if (value instanceof JSONObject && ((JSONObject)value).get((Object)"@binding") instanceof Token) {
                JSONObject binding = (JSONObject)value;
                Token block = (Token)binding.get((Object)"@binding");
                Object blockValue = block.execute(context);
                dynamic.put(key, blockValue);
                continue;
            }
            if (!(value instanceof JSONArray)) continue;
            JSONArray array = (JSONArray)value;
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < array.size(); ++i) {
                Object element = array.get(i);
                if (element instanceof CharSequence) {
                    builder.append(element);
                    continue;
                }
                if (!(element instanceof JSONObject) || !(((JSONObject)element).get((Object)"@binding") instanceof Token)) continue;
                JSONObject binding = (JSONObject)element;
                Token block = (Token)binding.get((Object)"@binding");
                Object blockValue = block.execute(context);
                if (blockValue == null) {
                    blockValue = "";
                }
                builder.append(blockValue);
            }
            String builderString = builder.toString();
            if (builderString.length() > 256 && WXEnvironment.isApkDebugable()) {
                WXLogUtils.w("WXRecyclerTemplateList", " warn too big string " + builderString);
            }
            dynamic.put(key, builderString);
        }
        return dynamic;
    }

    public static Map<String, Object> renderProps(JSONObject props, ArrayStack context) {
        Set entrySet = props.entrySet();
        ArrayMap renderProps = new ArrayMap(4);
        for (Map.Entry entry : entrySet) {
            Object value = entry.getValue();
            String key = (String)entry.getKey();
            if (value instanceof JSONObject && ((JSONObject)value).get((Object)"@binding") instanceof Token) {
                JSONObject binding = (JSONObject)value;
                Token block = (Token)binding.get((Object)"@binding");
                Object blockValue = block.execute(context);
                renderProps.put(key, blockValue);
                continue;
            }
            renderProps.put(key, value);
        }
        return renderProps;
    }

    public static List<Object> getBindingEventArgs(ArrayStack context, Object bindings) {
        ArrayList<Object> params = new ArrayList<Object>(4);
        if (bindings instanceof JSONArray) {
            JSONArray array = (JSONArray)bindings;
            for (int i = 0; i < array.size(); ++i) {
                Object value = array.get(i);
                if (value instanceof JSONObject && ((JSONObject)value).get((Object)"@binding") instanceof Token) {
                    Token block = (Token)((JSONObject)value).get((Object)"@binding");
                    Object blockValue = block.execute(context);
                    params.add(blockValue);
                    continue;
                }
                params.add(value);
            }
        } else if (bindings instanceof JSONObject) {
            JSONObject binding = (JSONObject)bindings;
            if (binding.get((Object)"@binding") instanceof Token) {
                Token block = (Token)binding.get((Object)"@binding");
                Object blockValue = block.execute(context);
                params.add(blockValue);
            } else {
                params.add(bindings.toString());
            }
        } else {
            params.add(bindings.toString());
        }
        return params;
    }
}

