/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.support.annotation.NonNull;
import android.support.v4.content.LocalBroadcastManager;
import android.text.Layout;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.annotation.Component;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.ui.ComponentCreator;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.flat.FlatComponent;
import com.taobao.weex.ui.flat.widget.TextWidget;
import com.taobao.weex.ui.view.WXTextView;
import com.taobao.weex.utils.FontDO;
import com.taobao.weex.utils.TypefaceUtil;
import com.taobao.weex.utils.WXLogUtils;
import java.lang.reflect.InvocationTargetException;

@Component(lazyload=false)
public class WXText
extends WXComponent<WXTextView>
implements FlatComponent<TextWidget> {
    private TextWidget mTextWidget;
    public static final int sDEFAULT_SIZE = 32;
    private BroadcastReceiver mTypefaceObserver;
    private String mFontFamily;

    @Override
    public boolean promoteToView(boolean checkAncestor) {
        return this.getInstance().getFlatUIContext().promoteToView(this, checkAncestor, WXText.class);
    }

    @Override
    @NonNull
    public TextWidget getOrCreateFlatWidget() {
        if (this.mTextWidget == null) {
            this.mTextWidget = new TextWidget(this.getInstance().getFlatUIContext());
        }
        return this.mTextWidget;
    }

    @Override
    public boolean isVirtualComponent() {
        return !this.promoteToView(true);
    }

    @Deprecated
    public WXText(WXSDKInstance instance, WXDomObject dom, WXVContainer parent, String instanceId, boolean isLazy) {
        this(instance, dom, parent);
    }

    public WXText(WXSDKInstance instance, WXDomObject node, WXVContainer parent) {
        super(instance, node, parent);
    }

    @Override
    protected WXTextView initComponentHostView(@NonNull Context context) {
        WXTextView textView = new WXTextView(context);
        textView.holdComponent(this);
        return textView;
    }

    @Override
    public void updateExtra(Object extra) {
        if (extra instanceof Layout) {
            Layout layout = (Layout)extra;
            if (!this.promoteToView(true)) {
                this.getOrCreateFlatWidget().updateTextDrawable(layout);
            } else if (this.getHostView() != null && !extra.equals(((WXTextView)this.getHostView()).getTextLayout())) {
                ((WXTextView)this.getHostView()).setTextLayout(layout);
                ((WXTextView)this.getHostView()).invalidate();
            }
        }
    }

    @Override
    protected void setAriaLabel(String label) {
        WXTextView text = (WXTextView)this.getHostView();
        if (text != null) {
            text.setAriaLabel(label);
        }
    }

    @Override
    public void refreshData(WXComponent component) {
        super.refreshData(component);
        if (component instanceof WXText) {
            this.updateExtra(component.getDomObject().getExtra());
        }
    }

    @Override
    protected boolean setProperty(String key, Object param) {
        switch (key) {
            case "lines": 
            case "fontSize": 
            case "fontWeight": 
            case "fontStyle": 
            case "color": 
            case "textDecoration": 
            case "textAlign": 
            case "textOverflow": 
            case "lineHeight": 
            case "value": {
                return true;
            }
            case "fontFamily": {
                if (param != null) {
                    this.registerTypefaceObserver(param.toString());
                }
                return true;
            }
        }
        return super.setProperty(key, param);
    }

    @Override
    protected Object convertEmptyProperty(String propName, Object originalValue) {
        switch (propName) {
            case "fontSize": {
                return 32;
            }
            case "color": {
                return "black";
            }
        }
        return super.convertEmptyProperty(propName, originalValue);
    }

    @Override
    protected void createViewImpl() {
        if (this.promoteToView(true)) {
            super.createViewImpl();
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        if (WXEnvironment.getApplication() != null && this.mTypefaceObserver != null) {
            WXLogUtils.d("WXText", "Unregister the typeface observer");
            LocalBroadcastManager.getInstance((Context)WXEnvironment.getApplication()).unregisterReceiver(this.mTypefaceObserver);
            this.mTypefaceObserver = null;
        }
    }

    private void registerTypefaceObserver(String desiredFontFamily) {
        if (WXEnvironment.getApplication() == null) {
            WXLogUtils.w("WXText", "ApplicationContent is null on register typeface observer");
            return;
        }
        this.mFontFamily = desiredFontFamily;
        if (this.mTypefaceObserver != null) {
            return;
        }
        this.mTypefaceObserver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String fontFamily = intent.getStringExtra("fontFamily");
                if (!WXText.this.mFontFamily.equals(fontFamily)) {
                    return;
                }
                FontDO fontDO = TypefaceUtil.getFontDO(fontFamily);
                if (fontDO != null && fontDO.getTypeface() != null && WXText.this.getHostView() != null) {
                    WXTextView hostView = (WXTextView)WXText.this.getHostView();
                    Layout layout = hostView.getTextLayout();
                    if (layout != null) {
                        layout.getPaint().setTypeface(fontDO.getTypeface());
                        WXLogUtils.d("WXText", "Apply font family " + fontFamily + " to paint");
                    } else {
                        WXLogUtils.w("WXText", "Layout not created");
                    }
                    hostView.invalidate();
                }
                WXLogUtils.d("WXText", "Font family " + fontFamily + " is available");
            }
        };
        LocalBroadcastManager.getInstance((Context)WXEnvironment.getApplication()).registerReceiver(this.mTypefaceObserver, new IntentFilter("type_face_available"));
    }

    public static class Creator
    implements ComponentCreator {
        @Override
        public WXComponent createInstance(WXSDKInstance instance, WXDomObject node, WXVContainer parent) throws IllegalAccessException, InvocationTargetException, InstantiationException {
            return new WXText(instance, node, parent);
        }
    }
}

