/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import android.text.TextUtils;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.common.WXRuntimeException;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.ui.IFComponentHolder;
import com.taobao.weex.ui.WXComponentRegistry;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.utils.WXLogUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class WXComponentFactory {
    private static Map<String, Set<String>> sComponentTypes = new HashMap<String, Set<String>>();

    public static Set<String> getComponentTypesByInstanceId(String instanceId) {
        return sComponentTypes.get(instanceId);
    }

    public static void removeComponentTypesByInstanceId(String instanceId) {
        sComponentTypes.remove(instanceId);
    }

    public static WXComponent newInstance(WXSDKInstance instance, WXDomObject node, WXVContainer parent) {
        if (instance == null || node == null || TextUtils.isEmpty((CharSequence)node.getType())) {
            return null;
        }
        if (sComponentTypes.get(instance.getInstanceId()) == null) {
            HashSet types = new HashSet();
            sComponentTypes.put(instance.getInstanceId(), types);
        }
        sComponentTypes.get(instance.getInstanceId()).add(node.getType());
        IFComponentHolder holder = WXComponentRegistry.getComponent(node.getType());
        if (holder == null) {
            String tag = "WXComponentFactory error type:[" + node.getType() + "] class not found";
            WXLogUtils.e(tag);
            holder = WXComponentRegistry.getComponent("container");
            if (holder == null) {
                throw new WXRuntimeException("Container component not found.");
            }
        }
        try {
            return holder.createInstance(instance, node, parent);
        }
        catch (Exception e) {
            WXLogUtils.e("WXComponentFactory Exception type:[" + node.getType() + "] ", e);
            return null;
        }
    }
}

