/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import android.text.TextUtils;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.ui.component.AbstractEditComponent;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.view.WXEditText;
import com.taobao.weex.utils.WXUtils;

public class Textarea
extends AbstractEditComponent {
    public Textarea(WXSDKInstance instance, WXDomObject dom, WXVContainer parent, boolean isLazy) {
        super(instance, dom, parent, isLazy);
    }

    @Override
    protected void onHostViewInitialized(WXEditText host) {
        host.setAllowDisableMovement(false);
        super.onHostViewInitialized(host);
    }

    @Override
    protected void appleStyleAfterCreated(WXEditText editText) {
        super.appleStyleAfterCreated(editText);
        String rowsStr = (String)this.getDomObject().getStyles().get("rows");
        int rows = 2;
        try {
            if (!TextUtils.isEmpty((CharSequence)rowsStr)) {
                rows = Integer.parseInt(rowsStr);
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        editText.setLines(rows);
        editText.setMinLines(rows);
    }

    @Override
    protected int getVerticalGravity() {
        return 48;
    }

    @Override
    protected boolean setProperty(String key, Object param) {
        switch (key) {
            case "rows": {
                Integer rows = WXUtils.getInteger(param, null);
                if (rows != null) {
                    this.setRows(rows);
                }
                return true;
            }
        }
        return super.setProperty(key, param);
    }

    @WXComponentProp(name="rows")
    public void setRows(int rows) {
        WXEditText text = (WXEditText)this.getHostView();
        if (text == null || rows <= 0) {
            return;
        }
        text.setLines(rows);
    }
}

