/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.dom.transition;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ArgbEvaluator;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.graphics.drawable.ColorDrawable;
import android.os.Handler;
import android.support.v4.util.ArrayMap;
import android.support.v4.view.animation.PathInterpolatorCompat;
import android.text.TextUtils;
import android.util.Property;
import android.view.View;
import android.view.animation.Interpolator;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.dom.DOMActionContext;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.ui.animation.BackgroundColorProperty;
import com.taobao.weex.ui.animation.TransformParser;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.utils.SingleFunctionParser;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXResourceUtils;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class WXTransition {
    public static final String TRANSITION_PROPERTY = "transitionProperty";
    public static final String TRANSITION_DURATION = "transitionDuration";
    public static final String TRANSITION_DELAY = "transitionDelay";
    public static final String TRANSITION_TIMING_FUNCTION = "transitionTimingFunction";
    public static final Pattern PROPERTY_SPLIT_PATTERN = Pattern.compile("\\||,");
    private static final Set<String> LAYOUT_PROPERTIES = new HashSet<String>();
    private static final Set<String> TRANSFORM_PROPERTIES;
    private List<String> properties = new ArrayList<String>(4);
    private Interpolator interpolator;
    private float duration;
    private float delay;
    private WXDomObject domObject;
    private Handler handler = new Handler();
    private ValueAnimator layoutValueAnimator;
    private Map<String, Object> layoutPendingUpdates = new ArrayMap();
    private ObjectAnimator transformAnimator;
    private Map<String, Object> transformPendingUpdates = new ArrayMap();
    private Runnable transitionEndEvent;
    private Map<String, Object> targetStyles = new ArrayMap();
    private Runnable animationRunnable;

    public static WXTransition fromMap(Map<String, Object> style, WXDomObject domObject) {
        String[] propertiesArray;
        if (style.get(TRANSITION_PROPERTY) == null) {
            return null;
        }
        String propertyString = WXUtils.getString(style.get(TRANSITION_PROPERTY), null);
        if (propertyString == null) {
            return null;
        }
        WXTransition transition = new WXTransition();
        for (String property : propertiesArray = PROPERTY_SPLIT_PATTERN.split(propertyString)) {
            String trim = property.trim();
            if (TextUtils.isEmpty((CharSequence)trim)) continue;
            if (!LAYOUT_PROPERTIES.contains(trim) && !TRANSFORM_PROPERTIES.contains(trim)) {
                if (!WXEnvironment.isApkDebugable()) continue;
                WXLogUtils.e("WXTransition Property Not Supported" + trim + " in " + propertyString);
                continue;
            }
            transition.properties.add(trim);
        }
        if (transition.properties.isEmpty()) {
            return null;
        }
        transition.duration = WXTransition.parseTimeMillis(style, TRANSITION_DURATION, 1.0f);
        transition.delay = WXTransition.parseTimeMillis(style, TRANSITION_DELAY, 0.0f);
        transition.interpolator = WXTransition.createTimeInterpolator(WXUtils.getString(style.get(TRANSITION_TIMING_FUNCTION), null));
        transition.domObject = domObject;
        return transition;
    }

    public boolean hasTransitionProperty(Map<String, Object> styles) {
        for (String property : this.properties) {
            if (!styles.containsKey(property)) continue;
            return true;
        }
        return false;
    }

    public void startTransition(Map<String, Object> updates) {
        View taregtView = this.getTargetView();
        if (taregtView == null) {
            return;
        }
        for (String property : this.properties) {
            if (!updates.containsKey(property)) continue;
            Object targetValue = updates.remove(property);
            if (LAYOUT_PROPERTIES.contains(property)) {
                this.layoutPendingUpdates.put(property, targetValue);
                continue;
            }
            if (!TRANSFORM_PROPERTIES.contains(property)) continue;
            this.transformPendingUpdates.put(property, targetValue);
        }
        int delay = WXUtils.getNumberInt(this.domObject.getAttrs().get("actionDelay"), 16);
        if (this.animationRunnable != null) {
            this.handler.removeCallbacks(this.animationRunnable);
        }
        if (this.animationRunnable == null) {
            this.animationRunnable = new Runnable(){

                @Override
                public void run() {
                    WXTransition.this.doTransitionAnimation();
                    WXTransition.this.animationRunnable = null;
                }
            };
        }
        this.handler.postDelayed(this.animationRunnable, (long)delay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTransitionAnimation() {
        View taregtView = this.getTargetView();
        if (taregtView == null) {
            return;
        }
        if (this.targetStyles.size() > 0) {
            for (String property : this.properties) {
                if (!LAYOUT_PROPERTIES.contains(property) && !TRANSFORM_PROPERTIES.contains(property) || this.layoutPendingUpdates.containsKey(property) || this.transformPendingUpdates.containsKey(property)) continue;
                Map<String, Object> map = this.targetStyles;
                synchronized (map) {
                    if (this.targetStyles.containsKey(property)) {
                        Object targetValue = this.targetStyles.remove(property);
                        this.domObject.getStyles().put(property, targetValue);
                        WXComponent component = this.getComponent();
                        if (component != null && component.getDomObject() != null) {
                            component.getDomObject().getStyles().put(property, targetValue);
                        }
                    }
                }
            }
        }
        if (this.transitionEndEvent != null) {
            taregtView.removeCallbacks(this.transitionEndEvent);
        }
        if (this.transitionEndEvent == null) {
            this.transitionEndEvent = new Runnable(){

                @Override
                public void run() {
                    WXTransition.this.transitionEndEvent = null;
                    WXComponent component = WXTransition.this.getComponent();
                    if (component != null && WXTransition.this.domObject.getEvents().contains("transitionEnd")) {
                        component.fireEvent("transitionEnd");
                    }
                }
            };
        }
        taregtView.post(new Runnable(){

            @Override
            public void run() {
                WXTransition.this.doPendingTransformAnimation();
            }
        });
        this.doPendingLayoutAnimation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPendingTransformAnimation() {
        if (this.transformAnimator != null) {
            this.transformAnimator.cancel();
            this.transformAnimator = null;
        }
        if (this.transformPendingUpdates.size() == 0) {
            return;
        }
        View taregtView = this.getTargetView();
        if (taregtView == null) {
            return;
        }
        ArrayList<PropertyValuesHolder> holders = new ArrayList<PropertyValuesHolder>(8);
        String transform = WXUtils.getString(this.transformPendingUpdates.remove("transform"), null);
        if (!TextUtils.isEmpty((CharSequence)transform)) {
            PropertyValuesHolder[] transformHolders;
            Map<Property<View, Float>, Float> properties = TransformParser.parseTransForm(transform, (int)this.domObject.getLayoutWidth(), (int)this.domObject.getLayoutHeight(), this.domObject.getViewPortWidth());
            for (PropertyValuesHolder holder : transformHolders = TransformParser.toHolders(properties)) {
                holders.add(holder);
            }
        }
        for (String property : this.properties) {
            if (!TRANSFORM_PROPERTIES.contains(property) || !this.transformPendingUpdates.containsKey(property)) continue;
            Object value = this.transformPendingUpdates.remove(property);
            Object object = this.targetStyles;
            synchronized (object) {
                this.targetStyles.put(property, value);
            }
            switch (property) {
                case "opacity": {
                    holders.add(PropertyValuesHolder.ofFloat((Property)View.ALPHA, (float[])new float[]{taregtView.getAlpha(), WXUtils.getFloat(value, Float.valueOf(1.0f)).floatValue()}));
                    taregtView.setLayerType(1, null);
                    break;
                }
                case "backgroundColor": {
                    int fromColor = WXResourceUtils.getColor(WXUtils.getString(this.domObject.getStyles().getBackgroundColor(), null), 0);
                    int toColor = WXResourceUtils.getColor(WXUtils.getString(value, null), 0);
                    if (WXViewUtils.getBorderDrawable(taregtView) != null) {
                        fromColor = WXViewUtils.getBorderDrawable(taregtView).getColor();
                    } else if (taregtView.getBackground() instanceof ColorDrawable) {
                        fromColor = ((ColorDrawable)taregtView.getBackground()).getColor();
                    }
                    holders.add(PropertyValuesHolder.ofObject((Property)new BackgroundColorProperty(), (TypeEvaluator)new ArgbEvaluator(), (Object[])new Integer[]{fromColor, toColor}));
                    break;
                }
            }
        }
        this.transformPendingUpdates.clear();
        this.transformAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)taregtView, (PropertyValuesHolder[])holders.toArray(new PropertyValuesHolder[holders.size()]));
        this.transformAnimator.setDuration((long)this.duration);
        this.transformAnimator.setStartDelay((long)this.delay);
        if (this.interpolator != null) {
            this.transformAnimator.setInterpolator((TimeInterpolator)this.interpolator);
        }
        this.transformAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){
            boolean hasCancel = false;

            public void onAnimationCancel(Animator animation) {
                super.onAnimationCancel(animation);
                this.hasCancel = true;
            }

            public void onAnimationEnd(Animator animation) {
                if (this.hasCancel) {
                    return;
                }
                super.onAnimationEnd(animation);
                WXTransition.this.onTransitionAnimationEnd();
                if (WXEnvironment.isApkDebugable()) {
                    WXLogUtils.d("WXTransition transform onTransitionAnimationEnd " + WXTransition.this.domObject.getRef());
                }
            }
        });
        this.transformAnimator.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPendingLayoutAnimation() {
        if (this.layoutValueAnimator != null) {
            this.layoutValueAnimator.cancel();
            this.layoutValueAnimator = null;
        }
        if (this.layoutPendingUpdates.size() == 0) {
            return;
        }
        PropertyValuesHolder[] holders = new PropertyValuesHolder[this.layoutPendingUpdates.size()];
        int index = 0;
        for (String property : this.properties) {
            if (!LAYOUT_PROPERTIES.contains(property) || !this.layoutPendingUpdates.containsKey(property)) continue;
            Object targetValue = this.layoutPendingUpdates.remove(property);
            Map<String, Object> map = this.targetStyles;
            synchronized (map) {
                this.targetStyles.put(property, targetValue);
            }
            holders[index] = this.createLayoutPropertyValueHolder(property, targetValue);
            ++index;
        }
        this.layoutPendingUpdates.clear();
        this.doLayoutPropertyValuesHolderAnimation(holders);
    }

    private PropertyValuesHolder createLayoutPropertyValueHolder(String property, Object value) {
        PropertyValuesHolder holder = null;
        switch (property) {
            case "width": {
                holder = PropertyValuesHolder.ofFloat((String)"width", (float[])new float[]{this.domObject.getLayoutWidth(), WXViewUtils.getRealPxByWidth(WXUtils.getFloat(value), this.domObject.getViewPortWidth())});
                break;
            }
            case "height": {
                holder = PropertyValuesHolder.ofFloat((String)"height", (float[])new float[]{this.domObject.getLayoutHeight(), WXViewUtils.getRealPxByWidth(WXUtils.getFloat(value), this.domObject.getViewPortWidth())});
                break;
            }
            case "marginTop": {
                holder = PropertyValuesHolder.ofFloat((String)"marginTop", (float[])new float[]{this.domObject.getMargin().get(1), WXViewUtils.getRealPxByWidth(WXUtils.getFloatByViewport(value, this.domObject.getViewPortWidth()), this.domObject.getViewPortWidth())});
                break;
            }
            case "marginLeft": {
                holder = PropertyValuesHolder.ofFloat((String)"marginLeft", (float[])new float[]{this.domObject.getMargin().get(0), WXViewUtils.getRealPxByWidth(WXUtils.getFloatByViewport(value, this.domObject.getViewPortWidth()), this.domObject.getViewPortWidth())});
                break;
            }
            case "marginRight": {
                holder = PropertyValuesHolder.ofFloat((String)"marginRight", (float[])new float[]{this.domObject.getMargin().get(2), WXViewUtils.getRealPxByWidth(WXUtils.getFloatByViewport(value, this.domObject.getViewPortWidth()), this.domObject.getViewPortWidth())});
                break;
            }
            case "marginBottom": {
                holder = PropertyValuesHolder.ofFloat((String)"marginBottom", (float[])new float[]{this.domObject.getMargin().get(3), WXViewUtils.getRealPxByWidth(WXUtils.getFloatByViewport(value, this.domObject.getViewPortWidth()), this.domObject.getViewPortWidth())});
                break;
            }
        }
        if (holder == null) {
            holder = PropertyValuesHolder.ofFloat((String)property, (float[])new float[]{1.0f, 1.0f});
        }
        return holder;
    }

    private void doLayoutPropertyValuesHolderAnimation(PropertyValuesHolder[] holders) {
        this.layoutValueAnimator = ValueAnimator.ofPropertyValuesHolder((PropertyValuesHolder[])holders);
        this.layoutValueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                PropertyValuesHolder[] holders;
                block16: for (PropertyValuesHolder holder : holders = animation.getValues()) {
                    String property;
                    switch (property = holder.getPropertyName()) {
                        case "width": {
                            WXTransition.this.domObject.setStyleWidth(((Float)animation.getAnimatedValue(property)).floatValue());
                            continue block16;
                        }
                        case "height": {
                            WXTransition.this.domObject.setStyleHeight(((Float)animation.getAnimatedValue(property)).floatValue());
                            continue block16;
                        }
                        case "marginTop": {
                            WXTransition.this.domObject.setMargin(1, ((Float)animation.getAnimatedValue(property)).floatValue());
                            continue block16;
                        }
                        case "marginLeft": {
                            WXTransition.this.domObject.setMargin(0, ((Float)animation.getAnimatedValue(property)).floatValue());
                            continue block16;
                        }
                        case "marginRight": {
                            WXTransition.this.domObject.setMargin(2, ((Float)animation.getAnimatedValue(property)).floatValue());
                            continue block16;
                        }
                        case "marginBottom": {
                            WXTransition.this.domObject.setMargin(3, ((Float)animation.getAnimatedValue(property)).floatValue());
                            continue block16;
                        }
                    }
                }
                DOMActionContext domActionContext = WXSDKManager.getInstance().getWXDomManager().getDomContext(WXTransition.this.domObject.getDomContext().getInstanceId());
                if (domActionContext == null) {
                    return;
                }
                domActionContext.markDirty();
                WXSDKManager.getInstance().getWXDomManager().sendEmptyMessageDelayed(251, 0L);
                if (WXEnvironment.isApkDebugable()) {
                    WXLogUtils.d("WXTransition send layout batch msg");
                }
            }
        });
        this.layoutValueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){
            boolean hasCancel = false;

            public void onAnimationCancel(Animator animation) {
                super.onAnimationCancel(animation);
                this.hasCancel = true;
            }

            public void onAnimationEnd(Animator animation) {
                if (this.hasCancel) {
                    return;
                }
                super.onAnimationEnd(animation);
                if (WXEnvironment.isApkDebugable()) {
                    WXLogUtils.d("WXTransition layout onTransitionAnimationEnd " + WXTransition.this.domObject.getRef());
                }
                WXTransition.this.onTransitionAnimationEnd();
            }
        });
        if (this.interpolator != null) {
            this.layoutValueAnimator.setInterpolator((TimeInterpolator)this.interpolator);
        }
        this.layoutValueAnimator.setStartDelay((long)this.delay);
        this.layoutValueAnimator.setDuration((long)this.duration);
        this.layoutValueAnimator.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void onTransitionAnimationEnd() {
        if (this.transitionEndEvent != null) {
            View view = this.getTargetView();
            if (view != null && this.transitionEndEvent != null) {
                view.post(this.transitionEndEvent);
            }
            this.transitionEndEvent = null;
        }
        Map<String, Object> map = this.targetStyles;
        synchronized (map) {
            if (this.targetStyles.size() > 0) {
                WXComponent component = this.getComponent();
                for (String property : this.properties) {
                    if (!this.targetStyles.containsKey(property)) continue;
                    Object targetValue = this.targetStyles.remove(property);
                    this.domObject.getStyles().put(property, targetValue);
                    if (component == null || component.getDomObject() == null) continue;
                    component.getDomObject().getStyles().put(property, targetValue);
                }
                this.targetStyles.clear();
            }
        }
    }

    private WXComponent getComponent() {
        DOMActionContext domActionContext = WXSDKManager.getInstance().getWXDomManager().getDomContext(this.domObject.getDomContext().getInstanceId());
        if (domActionContext != null) {
            WXComponent component = domActionContext.getCompByRef(this.domObject.getRef());
            return component;
        }
        return null;
    }

    private View getTargetView() {
        WXComponent component;
        if (this.domObject.getDomContext() == null) {
            return null;
        }
        DOMActionContext domActionContext = WXSDKManager.getInstance().getWXDomManager().getDomContext(this.domObject.getDomContext().getInstanceId());
        if (domActionContext != null && (component = domActionContext.getCompByRef(this.domObject.getRef())) != null && component.getHostView() != null) {
            return component.getHostView();
        }
        return null;
    }

    private static float parseTimeMillis(Map<String, Object> style, String key, float defaultValue) {
        String duration = WXUtils.getString(style.get(key), null);
        if (duration != null) {
            duration = duration.replaceAll("s", "");
        }
        if (TextUtils.isEmpty((CharSequence)duration)) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(duration);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private static Interpolator createTimeInterpolator(String interpolator) {
        block18: {
            if (!TextUtils.isEmpty((CharSequence)interpolator)) {
                switch (interpolator) {
                    case "ease-in": {
                        return PathInterpolatorCompat.create((float)0.42f, (float)0.0f, (float)1.0f, (float)1.0f);
                    }
                    case "ease-out": {
                        return PathInterpolatorCompat.create((float)0.0f, (float)0.0f, (float)0.58f, (float)1.0f);
                    }
                    case "ease-in-out": {
                        return PathInterpolatorCompat.create((float)0.42f, (float)0.0f, (float)0.58f, (float)1.0f);
                    }
                    case "ease": {
                        return PathInterpolatorCompat.create((float)0.25f, (float)0.1f, (float)0.25f, (float)1.0f);
                    }
                    case "linear": {
                        return PathInterpolatorCompat.create((float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
                    }
                }
                try {
                    SingleFunctionParser<Float> parser = new SingleFunctionParser<Float>(interpolator, new SingleFunctionParser.FlatMapper<Float>(){

                        @Override
                        public Float map(String raw) {
                            return Float.valueOf(Float.parseFloat(raw));
                        }
                    });
                    List<Float> params = parser.parse("cubic-bezier");
                    if (params != null && params.size() == 4) {
                        return PathInterpolatorCompat.create((float)params.get(0).floatValue(), (float)params.get(1).floatValue(), (float)params.get(2).floatValue(), (float)params.get(3).floatValue());
                    }
                }
                catch (RuntimeException e) {
                    if (!WXEnvironment.isApkDebugable()) break block18;
                    WXLogUtils.e("WXTransition", e);
                }
            }
        }
        return PathInterpolatorCompat.create((float)0.25f, (float)0.1f, (float)0.25f, (float)1.0f);
    }

    static {
        LAYOUT_PROPERTIES.add("width");
        LAYOUT_PROPERTIES.add("height");
        LAYOUT_PROPERTIES.add("marginTop");
        LAYOUT_PROPERTIES.add("marginBottom");
        LAYOUT_PROPERTIES.add("marginLeft");
        LAYOUT_PROPERTIES.add("marginRight");
        TRANSFORM_PROPERTIES = new HashSet<String>();
        TRANSFORM_PROPERTIES.add("opacity");
        TRANSFORM_PROPERTIES.add("backgroundColor");
        TRANSFORM_PROPERTIES.add("transform");
    }
}

