/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.dom.action;

import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.common.WXErrorCode;
import com.taobao.weex.dom.DOMAction;
import com.taobao.weex.dom.DOMActionContext;
import com.taobao.weex.dom.RenderAction;
import com.taobao.weex.dom.RenderActionContext;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.dom.WXEvent;
import com.taobao.weex.ui.component.WXComponent;

class RemoveEventAction
implements DOMAction,
RenderAction {
    private final String mRef;
    private final String mEvent;
    private WXDomObject mUpdatedDomObject;

    RemoveEventAction(String ref, Object event) {
        this.mRef = ref;
        this.mEvent = WXEvent.getEventName(event);
    }

    @Override
    public void executeDom(DOMActionContext context) {
        if (context.isDestory()) {
            return;
        }
        WXSDKInstance instance = context.getInstance();
        WXDomObject domObject = context.getDomByRef(this.mRef);
        if (domObject == null) {
            if (instance != null) {
                instance.commitUTStab("domModule", WXErrorCode.WX_ERR_DOM_REMOVEEVENT);
            }
            return;
        }
        domObject.removeEvent(this.mEvent);
        this.mUpdatedDomObject = domObject;
        context.postRenderTask(this);
        if (instance != null) {
            instance.commitUTStab("domModule", WXErrorCode.WX_SUCCESS);
        }
    }

    @Override
    public void executeRender(RenderActionContext context) {
        WXComponent comp = context.getComponent(this.mRef);
        if (comp != null) {
            comp.updateDom(this.mUpdatedDomObject);
            comp.removeEvent(this.mEvent);
        }
    }
}

