/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.dom.action;

import android.graphics.Rect;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.View;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.bridge.JSCallback;
import com.taobao.weex.bridge.SimpleJSCallback;
import com.taobao.weex.dom.RenderAction;
import com.taobao.weex.dom.RenderActionContext;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.utils.WXViewUtils;
import java.io.Serializable;
import java.util.HashMap;

class GetComponentRectAction
implements RenderAction {
    private final String mRef;
    private final String mCallback;

    GetComponentRectAction(String ref, String callback) {
        this.mRef = ref;
        this.mCallback = callback;
    }

    @Override
    public void executeRender(RenderActionContext context) {
        WXSDKInstance instance = context.getInstance();
        SimpleJSCallback jsCallback = new SimpleJSCallback(context.getInstance().getInstanceId(), this.mCallback);
        if (instance != null && !instance.isDestroy()) {
            if (TextUtils.isEmpty((CharSequence)this.mRef)) {
                HashMap<String, Object> options = new HashMap<String, Object>();
                options.put("result", false);
                options.put("errMsg", "Illegal parameter");
                jsCallback.invoke(options);
            } else if ("viewport".equalsIgnoreCase(this.mRef)) {
                this.callbackViewport(context, jsCallback);
            } else {
                WXComponent component = context.getComponent(this.mRef);
                HashMap<String, Object> options = new HashMap<String, Object>();
                if (component != null) {
                    int viewPort = instance.getInstanceViewPortWidth();
                    HashMap<String, Float> size = new HashMap<String, Float>();
                    Rect sizes = component.getComponentSize();
                    size.put("width", Float.valueOf(this.getWebPxValue(sizes.width(), viewPort)));
                    size.put("height", Float.valueOf(this.getWebPxValue(sizes.height(), viewPort)));
                    size.put("bottom", Float.valueOf(this.getWebPxValue(sizes.bottom, viewPort)));
                    size.put("left", Float.valueOf(this.getWebPxValue(sizes.left, viewPort)));
                    size.put("right", Float.valueOf(this.getWebPxValue(sizes.right, viewPort)));
                    size.put("top", Float.valueOf(this.getWebPxValue(sizes.top, viewPort)));
                    options.put("size", size);
                    options.put("result", true);
                } else {
                    options.put("errMsg", "Component does not exist");
                }
                jsCallback.invoke(options);
            }
        }
    }

    private void callbackViewport(RenderActionContext context, JSCallback jsCallback) {
        WXSDKInstance instance = context.getInstance();
        View container = instance.getContainerView();
        if (container != null) {
            HashMap<String, Serializable> options = new HashMap<String, Serializable>();
            HashMap<String, Float> sizes = new HashMap<String, Float>();
            int[] location = new int[2];
            instance.getContainerView().getLocationOnScreen(location);
            int viewport = instance.getInstanceViewPortWidth();
            sizes.put("left", Float.valueOf(0.0f));
            sizes.put("top", Float.valueOf(0.0f));
            sizes.put("right", Float.valueOf(this.getWebPxValue(container.getWidth(), viewport)));
            sizes.put("bottom", Float.valueOf(this.getWebPxValue(container.getHeight(), viewport)));
            sizes.put("width", Float.valueOf(this.getWebPxValue(container.getWidth(), viewport)));
            sizes.put("height", Float.valueOf(this.getWebPxValue(container.getHeight(), viewport)));
            options.put("size", sizes);
            options.put("result", Boolean.valueOf(true));
            jsCallback.invoke(options);
        } else {
            HashMap<String, Object> options = new HashMap<String, Object>();
            options.put("result", false);
            options.put("errMsg", "Component does not exist");
            jsCallback.invoke(options);
        }
    }

    @NonNull
    private float getWebPxValue(int value, int viewport) {
        return WXViewUtils.getWebPxByWidth(value, viewport);
    }
}

