/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.dom.action;

import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.common.WXErrorCode;
import com.taobao.weex.dom.DOMAction;
import com.taobao.weex.dom.DOMActionContext;
import com.taobao.weex.dom.RenderAction;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.dom.action.TraceableAction;
import com.taobao.weex.tracing.Stopwatch;
import com.taobao.weex.tracing.WXTracing;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentFactory;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.utils.WXLogUtils;
import java.util.List;

public abstract class AbstractAddElementAction
extends TraceableAction
implements DOMAction,
RenderAction {
    protected WXComponent generateComponentTree(DOMActionContext context, WXDomObject dom, WXVContainer parent) {
        if (dom == null) {
            return null;
        }
        long startNanos = System.nanoTime();
        WXComponent component = WXComponentFactory.newInstance(context.getInstance(), dom, parent);
        if (component != null) {
            component.mTraceInfo.domThreadStart = dom.mDomThreadTimestamp;
            component.mTraceInfo.rootEventId = this.mTracingEventId;
            component.mTraceInfo.domQueueTime = this.mDomQueueTime;
        }
        context.registerComponent(dom.getRef(), component);
        if (component instanceof WXVContainer) {
            WXVContainer parentC = (WXVContainer)component;
            int count = dom.childCount();
            WXDomObject child = null;
            for (int i = 0; i < count; ++i) {
                child = dom.getChild(i);
                if (child == null) continue;
                parentC.addChild(this.generateComponentTree(context, child, parentC));
            }
        }
        if (component != null) {
            component.mTraceInfo.domThreadNanos = System.nanoTime() - startNanos;
        }
        return component;
    }

    protected void addDomInternal(DOMActionContext context, JSONObject dom) {
        if (context.isDestory()) {
            return;
        }
        WXSDKInstance instance = context.getInstance();
        if (instance == null) {
            return;
        }
        WXErrorCode errCode = this.getErrorCode();
        if (dom == null) {
            instance.commitUTStab("domModule", errCode);
        }
        Stopwatch.tick();
        WXDomObject domObject = WXDomObject.parse(dom, instance, null);
        Stopwatch.split("parseDomObject");
        if (domObject == null || context.getDomByRef(domObject.getRef()) != null) {
            WXLogUtils.e("[DOMActionContextImpl] " + this.getStatementName() + " error,DOM object is null or already registered!!");
            instance.commitUTStab("domModule", errCode);
            return;
        }
        this.appendDomToTree(context, domObject);
        Stopwatch.split("appendDomToTree");
        domObject.traverseTree(context.getAddDOMConsumer(), context.getApplyStyleConsumer());
        Stopwatch.split("traverseTree");
        WXComponent component = this.createComponent(context, domObject);
        if (component == null) {
            instance.commitUTStab("domModule", errCode);
            return;
        }
        Stopwatch.split("createComponent");
        context.addDomInfo(domObject.getRef(), component);
        context.postRenderTask(this);
        this.addAnimationForDomTree(context, domObject);
        instance.commitUTStab("domModule", WXErrorCode.WX_SUCCESS);
        if (WXTracing.isAvailable()) {
            List<Stopwatch.ProcessEvent> events = Stopwatch.getProcessEvents();
            for (Stopwatch.ProcessEvent event : events) {
                this.submitPerformance(event.fname, "X", context.getInstanceId(), event.duration, event.startMillis, true);
            }
        }
    }

    public void addAnimationForDomTree(DOMActionContext context, WXDomObject domObject) {
        context.addAnimationForElement(domObject.getRef(), domObject.getStyles());
        for (int i = 0; i < domObject.childCount(); ++i) {
            this.addAnimationForDomTree(context, domObject.getChild(i));
        }
    }

    protected abstract WXComponent createComponent(DOMActionContext var1, WXDomObject var2);

    protected abstract void appendDomToTree(DOMActionContext var1, WXDomObject var2);

    protected abstract String getStatementName();

    protected abstract WXErrorCode getErrorCode();
}

