/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.bridge;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.bridge.Invoker;
import com.taobao.weex.bridge.JSCallback;
import com.taobao.weex.bridge.SimpleJSCallback;
import com.taobao.weex.utils.WXReflectionUtils;
import java.lang.reflect.Type;

public final class NativeInvokeHelper {
    private String mInstanceId;

    public NativeInvokeHelper(String instanceId) {
        this.mInstanceId = instanceId;
    }

    public Object invoke(final Object target, final Invoker invoker, JSONArray args) throws Exception {
        final Object[] params = this.prepareArguments(invoker.getParameterTypes(), args);
        if (!invoker.isRunOnUIThread()) {
            return invoker.invoke(target, params);
        }
        WXSDKManager.getInstance().postOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    invoker.invoke(target, params);
                }
                catch (Exception e) {
                    throw new RuntimeException(target + "Invoker " + invoker.toString(), e);
                }
            }
        }, 0L);
        return null;
    }

    private Object[] prepareArguments(Type[] paramClazzs, JSONArray args) throws Exception {
        Object[] params = new Object[paramClazzs.length];
        for (int i = 0; i < paramClazzs.length; ++i) {
            Type paramClazz = paramClazzs[i];
            if (i >= args.size()) {
                if (!paramClazz.getClass().isPrimitive()) {
                    params[i] = null;
                    continue;
                }
                throw new Exception("[prepareArguments] method argument list not match.");
            }
            Object value = args.get(i);
            if (paramClazz == JSONObject.class) {
                params[i] = value;
                continue;
            }
            if (JSCallback.class == paramClazz) {
                if (value instanceof String) {
                    params[i] = new SimpleJSCallback(this.mInstanceId, (String)value);
                    continue;
                }
                throw new Exception("Parameter type not match.");
            }
            params[i] = WXReflectionUtils.parseArgument(paramClazz, value);
        }
        return params;
    }
}

