/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import com.taobao.weex.InitConfig;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXGlobalEventModule;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.adapter.IDrawableLoader;
import com.taobao.weex.adapter.IWXHttpAdapter;
import com.taobao.weex.adapter.IWXImgLoaderAdapter;
import com.taobao.weex.adapter.IWXJSExceptionAdapter;
import com.taobao.weex.adapter.IWXUserTrackAdapter;
import com.taobao.weex.appfram.clipboard.WXClipboardModule;
import com.taobao.weex.appfram.navigator.IActivityNavBarSetter;
import com.taobao.weex.appfram.navigator.WXNavigatorModule;
import com.taobao.weex.appfram.pickers.WXPickersModule;
import com.taobao.weex.appfram.storage.IWXStorageAdapter;
import com.taobao.weex.appfram.storage.WXStorageModule;
import com.taobao.weex.appfram.websocket.WebSocketModule;
import com.taobao.weex.bridge.ModuleFactory;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.bridge.WXModuleManager;
import com.taobao.weex.bridge.WXServiceManager;
import com.taobao.weex.common.Destroyable;
import com.taobao.weex.common.TypeModuleFactory;
import com.taobao.weex.common.WXException;
import com.taobao.weex.common.WXInstanceWrap;
import com.taobao.weex.common.WXModule;
import com.taobao.weex.dom.BasicEditTextDomObject;
import com.taobao.weex.dom.TextAreaEditTextDomObject;
import com.taobao.weex.dom.WXCellDomObject;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.dom.WXDomRegistry;
import com.taobao.weex.dom.WXListDomObject;
import com.taobao.weex.dom.WXRecyclerDomObject;
import com.taobao.weex.dom.WXScrollerDomObject;
import com.taobao.weex.dom.WXSwitchDomObject;
import com.taobao.weex.dom.WXTextDomObject;
import com.taobao.weex.http.WXStreamModule;
import com.taobao.weex.ui.ExternalLoaderComponentHolder;
import com.taobao.weex.ui.IExternalComponentGetter;
import com.taobao.weex.ui.IExternalModuleGetter;
import com.taobao.weex.ui.IFComponentHolder;
import com.taobao.weex.ui.SimpleComponentHolder;
import com.taobao.weex.ui.WXComponentRegistry;
import com.taobao.weex.ui.animation.WXAnimationModule;
import com.taobao.weex.ui.component.Textarea;
import com.taobao.weex.ui.component.WXA;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXDiv;
import com.taobao.weex.ui.component.WXEmbed;
import com.taobao.weex.ui.component.WXHeader;
import com.taobao.weex.ui.component.WXImage;
import com.taobao.weex.ui.component.WXIndicator;
import com.taobao.weex.ui.component.WXInput;
import com.taobao.weex.ui.component.WXLoading;
import com.taobao.weex.ui.component.WXLoadingIndicator;
import com.taobao.weex.ui.component.WXRefresh;
import com.taobao.weex.ui.component.WXScroller;
import com.taobao.weex.ui.component.WXSlider;
import com.taobao.weex.ui.component.WXSliderNeighbor;
import com.taobao.weex.ui.component.WXSwitch;
import com.taobao.weex.ui.component.WXText;
import com.taobao.weex.ui.component.WXVideo;
import com.taobao.weex.ui.component.WXWeb;
import com.taobao.weex.ui.component.list.HorizontalListComponent;
import com.taobao.weex.ui.component.list.SimpleListComponent;
import com.taobao.weex.ui.component.list.WXCell;
import com.taobao.weex.ui.component.list.WXListComponent;
import com.taobao.weex.ui.component.list.template.WXRecyclerTemplateList;
import com.taobao.weex.ui.module.WXLocalModule;
import com.taobao.weex.ui.module.WXMetaModule;
import com.taobao.weex.ui.module.WXModalUIModule;
import com.taobao.weex.ui.module.WXTimerModule;
import com.taobao.weex.ui.module.WXWebViewModule;
import com.taobao.weex.utils.LogLevel;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXSoInstallMgrSdk;
import com.taobao.weex.utils.batch.BatchOperationHelper;
import java.util.HashMap;
import java.util.Map;

public class WXSDKEngine {
    public static final String JS_FRAMEWORK_RELOAD = "js_framework_reload";
    private static final String V8_SO_NAME = "weexjsc";
    private static volatile boolean mIsInit = false;
    private static final Object mLock = new Object();
    private static final String TAG = "WXSDKEngine";

    @Deprecated
    public static void init(Application application) {
        WXSDKEngine.init(application, null);
    }

    @Deprecated
    public static void init(Application application, IWXUserTrackAdapter utAdapter) {
        WXSDKEngine.init(application, utAdapter, null);
    }

    @Deprecated
    public static void init(Application application, IWXUserTrackAdapter utAdapter, String framework) {
        WXSDKEngine.initialize(application, new InitConfig.Builder().setUtAdapter(utAdapter).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isInitialized() {
        Object object = mLock;
        synchronized (object) {
            return mIsInit && WXEnvironment.JsFrameworkInit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(Application application, InitConfig config) {
        Object object = mLock;
        synchronized (object) {
            long start;
            if (mIsInit) {
                return;
            }
            WXEnvironment.sSDKInitStart = start = System.currentTimeMillis();
            if (WXEnvironment.isApkDebugable()) {
                WXEnvironment.sLogLevel = LogLevel.DEBUG;
            } else if (WXEnvironment.sApplication != null) {
                WXEnvironment.sLogLevel = LogLevel.WARN;
            } else {
                WXLogUtils.e(TAG, "WXEnvironment.sApplication is " + WXEnvironment.sApplication);
            }
            WXSDKEngine.doInitInternal(application, config);
            WXEnvironment.sSDKInitInvokeTime = System.currentTimeMillis() - start;
            WXLogUtils.renderPerformanceLog("SDKInitInvokeTime", WXEnvironment.sSDKInitInvokeTime);
            mIsInit = true;
        }
    }

    private static void doInitInternal(final Application application, final InitConfig config) {
        WXEnvironment.sApplication = application;
        if (application == null) {
            WXLogUtils.e(TAG, " doInitInternal application is null");
        }
        WXEnvironment.JsFrameworkInit = false;
        WXBridgeManager.getInstance().post(new Runnable(){

            @Override
            public void run() {
                long start = System.currentTimeMillis();
                WXSDKManager sm = WXSDKManager.getInstance();
                sm.onSDKEngineInitialize();
                if (config != null) {
                    sm.setInitConfig(config);
                }
                WXSoInstallMgrSdk.init((Context)application, sm.getIWXSoLoaderAdapter(), sm.getWXStatisticsListener());
                boolean isSoInitSuccess = WXSoInstallMgrSdk.initSo(WXSDKEngine.V8_SO_NAME, 1, config != null ? config.getUtAdapter() : null);
                if (!isSoInitSuccess) {
                    return;
                }
                sm.initScriptsFramework(config != null ? config.getFramework() : null);
                WXEnvironment.sSDKInitExecuteTime = System.currentTimeMillis() - start;
                WXLogUtils.renderPerformanceLog("SDKInitExecuteTime", WXEnvironment.sSDKInitExecuteTime);
            }
        });
        WXSDKEngine.register();
    }

    @Deprecated
    public static void init(Application application, String framework, IWXUserTrackAdapter utAdapter, IWXImgLoaderAdapter imgLoaderAdapter, IWXHttpAdapter httpAdapter) {
        WXSDKEngine.initialize(application, new InitConfig.Builder().setUtAdapter(utAdapter).setHttpAdapter(httpAdapter).setImgAdapter(imgLoaderAdapter).build());
    }

    public static void setJSExcetptionAdapter(IWXJSExceptionAdapter excetptionAdapter) {
        WXSDKManager.getInstance().setIWXJSExceptionAdapter(excetptionAdapter);
    }

    private static void register() {
        BatchOperationHelper batchHelper = new BatchOperationHelper(WXBridgeManager.getInstance());
        try {
            WXSDKEngine.registerComponent(new SimpleComponentHolder(WXText.class, new WXText.Creator()), false, "text");
            WXSDKEngine.registerComponent(new SimpleComponentHolder(WXDiv.class, new WXDiv.Ceator()), false, "container", "div", "header", "footer");
            WXSDKEngine.registerComponent(new SimpleComponentHolder(WXImage.class, new WXImage.Ceator()), false, "image", "img");
            WXSDKEngine.registerComponent(new SimpleComponentHolder(WXScroller.class, new WXScroller.Creator()), false, "scroller");
            WXSDKEngine.registerComponent(new SimpleComponentHolder(WXSlider.class, new WXSlider.Creator()), true, "slider", "cycleslider");
            WXSDKEngine.registerComponent(new SimpleComponentHolder(WXSliderNeighbor.class, new WXSliderNeighbor.Creator()), true, "slider-neighbor");
            String simpleList = "simplelist";
            WXSDKEngine.registerComponent(SimpleListComponent.class, false, simpleList);
            WXSDKEngine.registerComponent(WXListComponent.class, false, "list", "vlist", "recycler", "waterfall");
            WXSDKEngine.registerComponent(WXRecyclerTemplateList.class, false, "recycle-list");
            WXSDKEngine.registerComponent(HorizontalListComponent.class, false, "hlist");
            WXSDKEngine.registerComponent("cell", WXCell.class, true);
            WXSDKEngine.registerComponent("cell-slot", WXCell.class, true);
            WXSDKEngine.registerComponent("indicator", WXIndicator.class, true);
            WXSDKEngine.registerComponent("video", WXVideo.class, false);
            WXSDKEngine.registerComponent("input", WXInput.class, false);
            WXSDKEngine.registerComponent("textarea", Textarea.class, false);
            WXSDKEngine.registerComponent("switch", WXSwitch.class, false);
            WXSDKEngine.registerComponent("a", WXA.class, false);
            WXSDKEngine.registerComponent("embed", WXEmbed.class, true);
            WXSDKEngine.registerComponent("web", WXWeb.class);
            WXSDKEngine.registerComponent("refresh", WXRefresh.class);
            WXSDKEngine.registerComponent("loading", WXLoading.class);
            WXSDKEngine.registerComponent("loading-indicator", WXLoadingIndicator.class);
            WXSDKEngine.registerComponent("header", WXHeader.class);
            WXSDKEngine.registerModule("modal", WXModalUIModule.class, false);
            WXSDKEngine.registerModule("instanceWrap", WXInstanceWrap.class, true);
            WXSDKEngine.registerModule("animation", WXAnimationModule.class, true);
            WXSDKEngine.registerModule("webview", WXWebViewModule.class, true);
            WXSDKEngine.registerModule("navigator", WXNavigatorModule.class);
            WXSDKEngine.registerModule("stream", WXStreamModule.class);
            WXSDKEngine.registerModule("timer", WXTimerModule.class, false);
            WXSDKEngine.registerModule("storage", WXStorageModule.class, true);
            WXSDKEngine.registerModule("clipboard", WXClipboardModule.class, true);
            WXSDKEngine.registerModule("globalEvent", WXGlobalEventModule.class);
            WXSDKEngine.registerModule("picker", WXPickersModule.class);
            WXSDKEngine.registerModule("meta", WXMetaModule.class, true);
            WXSDKEngine.registerModule("webSocket", WebSocketModule.class);
            WXSDKEngine.registerModule("local", WXLocalModule.class);
            WXSDKEngine.registerDomObject(simpleList, WXListDomObject.class);
            WXSDKEngine.registerDomObject("indicator", WXIndicator.IndicatorDomNode.class);
            WXSDKEngine.registerDomObject("text", WXTextDomObject.class);
            WXSDKEngine.registerDomObject("header", WXCellDomObject.class);
            WXSDKEngine.registerDomObject("cell", WXCellDomObject.class);
            WXSDKEngine.registerDomObject("cell-slot", WXCellDomObject.class);
            WXSDKEngine.registerDomObject("input", BasicEditTextDomObject.class);
            WXSDKEngine.registerDomObject("textarea", TextAreaEditTextDomObject.class);
            WXSDKEngine.registerDomObject("switch", WXSwitchDomObject.class);
            WXSDKEngine.registerDomObject("list", WXListDomObject.class);
            WXSDKEngine.registerDomObject("recycle-list", WXRecyclerDomObject.class);
            WXSDKEngine.registerDomObject("vlist", WXListDomObject.class);
            WXSDKEngine.registerDomObject("hlist", WXListDomObject.class);
            WXSDKEngine.registerDomObject("scroller", WXScrollerDomObject.class);
            WXSDKEngine.registerDomObject("recycler", WXRecyclerDomObject.class);
            WXSDKEngine.registerDomObject("waterfall", WXRecyclerDomObject.class);
        }
        catch (WXException e) {
            WXLogUtils.e("[WXSDKEngine] register:", e);
        }
        batchHelper.flush();
    }

    public static boolean registerComponent(String type, Class<? extends WXComponent> clazz, boolean appendTree) throws WXException {
        return WXSDKEngine.registerComponent(clazz, appendTree, type);
    }

    public static boolean registerComponent(String type, IExternalComponentGetter componentGetter, boolean appendTree) throws WXException {
        return WXSDKEngine.registerComponent(new ExternalLoaderComponentHolder(type, componentGetter), appendTree, type);
    }

    public static boolean registerComponent(Class<? extends WXComponent> clazz, boolean appendTree, String ... names) throws WXException {
        if (clazz == null) {
            return false;
        }
        SimpleComponentHolder holder = new SimpleComponentHolder(clazz);
        return WXSDKEngine.registerComponent(holder, appendTree, names);
    }

    public static boolean registerComponent(IFComponentHolder holder, boolean appendTree, String ... names) throws WXException {
        boolean result = true;
        for (String name : names) {
            HashMap<String, Object> componentInfo = new HashMap<String, Object>();
            if (appendTree) {
                componentInfo.put("append", "tree");
            }
            result = result && WXComponentRegistry.registerComponent(name, holder, componentInfo);
        }
        return result;
    }

    public static <T extends WXModule> boolean registerModule(String moduleName, Class<T> moduleClass, boolean global) throws WXException {
        return moduleClass != null && WXSDKEngine.registerModule(moduleName, new TypeModuleFactory<T>(moduleClass), global);
    }

    public static <T extends WXModule> boolean registerModuleWithFactory(String moduleName, DestroyableModuleFactory factory, boolean global) throws WXException {
        return WXSDKEngine.registerModule(moduleName, factory, global);
    }

    public static <T extends WXModule> boolean registerModuleWithFactory(String moduleName, IExternalModuleGetter factory, boolean global) throws WXException {
        return WXSDKEngine.registerModule(moduleName, factory.getExternalModuleClass(moduleName, (Context)WXEnvironment.getApplication()), global);
    }

    private static <T extends WXModule> boolean registerModule(String moduleName, ModuleFactory factory, boolean global) throws WXException {
        return WXModuleManager.registerModule(moduleName, factory, global);
    }

    public static boolean registerModule(String moduleName, Class<? extends WXModule> moduleClass) throws WXException {
        return WXSDKEngine.registerModule(moduleName, moduleClass, false);
    }

    public static boolean registerService(String name, String serviceScript, Map<String, String> options) {
        return WXServiceManager.registerService(name, serviceScript, options);
    }

    public static boolean unRegisterService(String name) {
        return WXServiceManager.unRegisterService(name);
    }

    public static boolean registerDomObject(String type, Class<? extends WXDomObject> clazz) throws WXException {
        return WXDomRegistry.registerDomObject(type, clazz);
    }

    public static void callback(String instanceId, String funcId, Map<String, Object> data) {
        WXSDKManager.getInstance().callback(instanceId, funcId, data);
    }

    public static void restartBridge(boolean debug) {
        WXEnvironment.sDebugMode = debug;
        WXSDKManager.getInstance().restartBridge();
    }

    public static boolean registerComponent(String type, Class<? extends WXComponent> clazz) throws WXException {
        return WXComponentRegistry.registerComponent(type, new SimpleComponentHolder(clazz), new HashMap<String, Object>());
    }

    public static boolean registerComponent(Map<String, Object> componentInfo, Class<? extends WXComponent> clazz) throws WXException {
        if (componentInfo == null) {
            return false;
        }
        String type = (String)componentInfo.get("type");
        if (TextUtils.isEmpty((CharSequence)type)) {
            return false;
        }
        return WXComponentRegistry.registerComponent(type, new SimpleComponentHolder(clazz), componentInfo);
    }

    public static void addCustomOptions(String key, String value) {
        WXEnvironment.addCustomOptions(key, value);
    }

    public static IWXUserTrackAdapter getIWXUserTrackAdapter() {
        return WXSDKManager.getInstance().getIWXUserTrackAdapter();
    }

    public static IWXImgLoaderAdapter getIWXImgLoaderAdapter() {
        return WXSDKManager.getInstance().getIWXImgLoaderAdapter();
    }

    public static IDrawableLoader getDrawableLoader() {
        return WXSDKManager.getInstance().getDrawableLoader();
    }

    public static IWXHttpAdapter getIWXHttpAdapter() {
        return WXSDKManager.getInstance().getIWXHttpAdapter();
    }

    public static IWXStorageAdapter getIWXStorageAdapter() {
        return WXSDKManager.getInstance().getIWXStorageAdapter();
    }

    public static IActivityNavBarSetter getActivityNavBarSetter() {
        return WXSDKManager.getInstance().getActivityNavBarSetter();
    }

    public static void setActivityNavBarSetter(IActivityNavBarSetter activityNavBarSetter) {
        WXSDKManager.getInstance().setActivityNavBarSetter(activityNavBarSetter);
    }

    public static void reload(final Context context, String framework, boolean remoteDebug) {
        WXEnvironment.sRemoteDebugMode = remoteDebug;
        WXBridgeManager.getInstance().restart();
        WXBridgeManager.getInstance().initScriptsFramework(framework);
        WXModuleManager.reload();
        WXComponentRegistry.reload();
        WXSDKManager.getInstance().postOnUiThread(new Runnable(){

            @Override
            public void run() {
                LocalBroadcastManager.getInstance((Context)context).sendBroadcast(new Intent(WXSDKEngine.JS_FRAMEWORK_RELOAD));
            }
        }, 0L);
    }

    public static void reload(Context context, boolean remoteDebug) {
        WXSDKEngine.reload(context, null, remoteDebug);
    }

    public static void reload() {
        WXSDKEngine.reload((Context)WXEnvironment.getApplication(), WXEnvironment.sRemoteDebugMode);
    }

    public static abstract class DestroyableModuleFactory<T extends DestroyableModule>
    extends TypeModuleFactory<T> {
        public DestroyableModuleFactory(Class<T> clz) {
            super(clz);
        }
    }

    public static abstract class DestroyableModule
    extends WXModule
    implements Destroyable {
    }
}

