/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.utils;

import android.support.annotation.NonNull;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class FunctionParser<K, V> {
    public static final char SPACE = ' ';
    private Mapper<K, V> mapper;
    private Lexer lexer;

    public FunctionParser(@NonNull String source, @NonNull Mapper<K, V> mapper) {
        this.lexer = new Lexer(source);
        this.mapper = mapper;
    }

    public LinkedHashMap<K, V> parse() {
        this.lexer.moveOn();
        return this.definition();
    }

    private LinkedHashMap<K, V> definition() {
        LinkedHashMap<K, V> result = new LinkedHashMap<K, V>();
        do {
            result.putAll(this.function());
        } while (this.lexer.getCurrentToken() == Token.FUNC_NAME);
        return result;
    }

    private Map<K, V> function() {
        LinkedList<String> list = new LinkedList<String>();
        String functionName = this.match(Token.FUNC_NAME);
        this.match(Token.LEFT_PARENT);
        list.add(this.match(Token.PARAM_VALUE));
        while (this.lexer.getCurrentToken() == Token.COMMA) {
            this.match(Token.COMMA);
            list.add(this.match(Token.PARAM_VALUE));
        }
        this.match(Token.RIGHT_PARENT);
        return this.mapper.map(functionName, list);
    }

    private String match(Token token) {
        if (token == this.lexer.getCurrentToken()) {
            String value = this.lexer.getCurrentTokenValue();
            this.lexer.moveOn();
            return value;
        }
        throw new WXInterpretationException("Token doesn't match");
    }

    private static class Lexer {
        private static final String LEFT_PARENT = "(";
        private static final String RIGHT_PARENT = ")";
        private static final String COMMA = ",";
        private static final char A_LOWER = 'a';
        private static final char Z_LOWER = 'z';
        private static final char A_UPPER = 'A';
        private static final char Z_UPPER = 'Z';
        private static final char ZERO = '0';
        private static final char NINE = '9';
        private static final char DOT = '.';
        private static final char MINUS = '-';
        private static final char PLUS = '+';
        private String source;
        private Token current;
        private String value;
        private int pointer = 0;

        private Lexer(String source) {
            this.source = source;
        }

        private Token getCurrentToken() {
            return this.current;
        }

        private String getCurrentTokenValue() {
            return this.value;
        }

        private boolean moveOn() {
            int start = this.pointer;
            while (this.pointer < this.source.length()) {
                char curChar = this.source.charAt(this.pointer);
                if (curChar == ' ') {
                    if (start != this.pointer++) break;
                    ++start;
                    continue;
                }
                if (this.isCharacterOrDigit(curChar) || curChar == '.' || curChar == '%' || curChar == '-' || curChar == '+') {
                    ++this.pointer;
                    continue;
                }
                if (start != this.pointer) break;
                ++this.pointer;
                break;
            }
            if (start != this.pointer) {
                String symbol = this.source.substring(start, this.pointer);
                this.moveOn(symbol);
                return true;
            }
            this.current = null;
            this.value = null;
            return false;
        }

        private void moveOn(String token) {
            if (LEFT_PARENT.equals(token)) {
                this.current = Token.LEFT_PARENT;
                this.value = LEFT_PARENT;
            } else if (RIGHT_PARENT.equals(token)) {
                this.current = Token.RIGHT_PARENT;
                this.value = RIGHT_PARENT;
            } else if (COMMA.equals(token)) {
                this.current = Token.COMMA;
                this.value = COMMA;
            } else if (this.isFuncName(token)) {
                this.current = Token.FUNC_NAME;
                this.value = token;
            } else {
                this.current = Token.PARAM_VALUE;
                this.value = token;
            }
        }

        private boolean isFuncName(CharSequence funcName) {
            for (int i = 0; i < funcName.length(); ++i) {
                char letter = funcName.charAt(i);
                if ('a' <= letter && letter <= 'z' || 'A' <= letter && letter <= 'Z' || letter == '-') continue;
                return false;
            }
            return true;
        }

        private boolean isCharacterOrDigit(char letter) {
            return '0' <= letter && letter <= '9' || 'a' <= letter && letter <= 'z' || 'A' <= letter && letter <= 'Z';
        }
    }

    private static class WXInterpretationException
    extends RuntimeException {
        private WXInterpretationException(String msg) {
            super(msg);
        }
    }

    public static interface Mapper<K, V> {
        public Map<K, V> map(String var1, List<String> var2);
    }

    private static enum Token {
        FUNC_NAME,
        PARAM_VALUE,
        LEFT_PARENT,
        RIGHT_PARENT,
        COMMA;

    }
}

