/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.MotionEvent;
import android.view.View;
import android.widget.FrameLayout;
import com.taobao.weex.ui.component.WXDiv;
import com.taobao.weex.ui.flat.widget.Widget;
import com.taobao.weex.ui.view.IRenderResult;
import com.taobao.weex.ui.view.IRenderStatus;
import com.taobao.weex.ui.view.gesture.WXGesture;
import com.taobao.weex.ui.view.gesture.WXGestureObservable;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.lang.ref.WeakReference;
import java.util.List;

public class WXFrameLayout
extends FrameLayout
implements WXGestureObservable,
IRenderStatus<WXDiv>,
IRenderResult<WXDiv> {
    private WXGesture wxGesture;
    private WeakReference<WXDiv> mWeakReference;
    private List<Widget> mWidgets;

    public WXFrameLayout(Context context) {
        super(context);
    }

    @Override
    public void registerGestureListener(WXGesture wxGesture) {
        this.wxGesture = wxGesture;
    }

    public boolean onTouchEvent(MotionEvent event) {
        boolean result = super.onTouchEvent(event);
        if (this.wxGesture != null) {
            result |= this.wxGesture.onTouch((View)this, event);
        }
        return result;
    }

    @Override
    public void holdComponent(WXDiv component) {
        this.mWeakReference = new WeakReference<WXDiv>(component);
    }

    @Override
    @Nullable
    public WXDiv getComponent() {
        return null != this.mWeakReference ? (WXDiv)this.mWeakReference.get() : null;
    }

    public void mountFlatGUI(List<Widget> widgets) {
        this.mWidgets = widgets;
        if (this.mWidgets != null) {
            this.setWillNotDraw(true);
        }
        this.invalidate();
    }

    public void unmountFlatGUI() {
        this.mWidgets = null;
        this.setWillNotDraw(false);
        this.invalidate();
    }

    protected boolean verifyDrawable(@NonNull Drawable who) {
        return this.mWidgets != null || super.verifyDrawable(who);
    }

    protected void dispatchDraw(Canvas canvas) {
        try {
            if (this.mWidgets != null) {
                canvas.save();
                canvas.translate((float)this.getPaddingLeft(), (float)this.getPaddingTop());
                for (Widget widget : this.mWidgets) {
                    widget.draw(canvas);
                }
                canvas.restore();
            } else {
                WXViewUtils.clipCanvasWithinBorderBox((View)this, canvas);
                super.dispatchDraw(canvas);
            }
        }
        catch (Throwable e) {
            WXLogUtils.e("FlatGUI Crashed when dispatchDraw", WXLogUtils.getStackTrace(e));
        }
    }
}

