/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.FrameLayout;
import com.taobao.weex.ui.view.WXCircleViewPager;
import com.taobao.weex.ui.view.gesture.WXGesture;
import com.taobao.weex.ui.view.gesture.WXGestureObservable;
import com.taobao.weex.utils.WXViewUtils;

public class WXBaseCircleIndicator
extends FrameLayout
implements ViewPager.OnPageChangeListener,
WXGestureObservable {
    private final Paint mPaintPage = new Paint();
    private final Paint mPaintStroke = new Paint();
    private final Paint mPaintFill = new Paint();
    private WXGesture wxGesture;
    private WXCircleViewPager mCircleViewPager;
    private float radius;
    private float circlePadding;
    private int pageColor;
    private int fillColor;
    private int realCurrentItem;
    private ViewPager.OnPageChangeListener mListener;

    public WXBaseCircleIndicator(Context context) {
        super(context);
        this.getAttrs(context);
        this.init();
    }

    private void getAttrs(Context context) {
        this.radius = WXViewUtils.dip2px(5.0f);
        this.circlePadding = WXViewUtils.dip2px(5.0f);
        this.pageColor = Color.parseColor((String)"#ffffff");
        this.fillColor = Color.parseColor((String)"#ffd545");
    }

    private void init() {
        this.mPaintStroke.setAntiAlias(true);
        this.mPaintStroke.setStyle(Paint.Style.STROKE);
        this.mPaintFill.setStyle(Paint.Style.FILL);
        this.mPaintFill.setAntiAlias(true);
        this.mPaintPage.setAntiAlias(true);
        this.mPaintPage.setColor(this.pageColor);
        this.mPaintFill.setStyle(Paint.Style.FILL);
        this.mPaintFill.setColor(this.fillColor);
        this.setWillNotDraw(false);
    }

    public WXBaseCircleIndicator(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.getAttrs(context);
        this.init();
    }

    public void setOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        this.mListener = listener;
    }

    public WXCircleViewPager getCircleViewPager() {
        return this.mCircleViewPager;
    }

    public void setCircleViewPager(WXCircleViewPager mCircleViewPager) {
        this.mCircleViewPager = mCircleViewPager;
        if (this.mCircleViewPager != null) {
            this.mCircleViewPager.addOnPageChangeListener(this);
            this.realCurrentItem = mCircleViewPager.getRealCurrentItem();
        }
        this.requestLayout();
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        if (this.mListener != null) {
            this.mListener.onPageScrolled(position, positionOffset, positionOffsetPixels);
        }
    }

    public void onPageSelected(int position) {
        this.realCurrentItem = this.mCircleViewPager.getRealCurrentItem();
        this.invalidate();
        if (this.mListener != null) {
            this.mListener.onPageSelected(position);
        }
    }

    public void onPageScrollStateChanged(int state) {
        if (this.mListener != null) {
            this.mListener.onPageScrollStateChanged(state);
        }
    }

    public float getRadius() {
        return this.radius;
    }

    public void setRadius(float radius) {
        this.radius = radius;
    }

    public float getCirclePadding() {
        return this.circlePadding;
    }

    public void setCirclePadding(float circlePadding) {
        this.circlePadding = circlePadding;
    }

    public int getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(int fillColor) {
        this.fillColor = fillColor;
        this.mPaintFill.setColor(fillColor);
    }

    public void setPageColor(int pageColor) {
        this.pageColor = pageColor;
        this.mPaintPage.setColor(pageColor);
    }

    public int getRealCurrentItem() {
        return this.realCurrentItem;
    }

    public void setRealCurrentItem(int realCurrentItem) {
        this.realCurrentItem = realCurrentItem;
    }

    @Override
    public void registerGestureListener(WXGesture wxGesture) {
        this.wxGesture = wxGesture;
    }

    public boolean onTouchEvent(MotionEvent event) {
        boolean result = super.onTouchEvent(event);
        if (this.wxGesture != null) {
            result |= this.wxGesture.onTouch((View)this, event);
        }
        return result;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        float firstX = (float)(this.getWidth() / 2 + this.getPaddingLeft()) - (float)this.getCount() / 2.0f * (this.radius + this.circlePadding);
        float firstY = this.getHeight() / 2 + this.getPaddingTop();
        for (int i = 0; i < this.getCount(); ++i) {
            float dx = firstX + this.circlePadding * (float)i + this.radius * 2.0f * (float)i;
            float dy = firstY;
            if (this.mPaintStroke.getStrokeWidth() > 0.0f) {
                canvas.drawCircle(dx, dy, this.radius, this.mPaintStroke);
            }
            if (this.mPaintPage.getAlpha() <= 0) continue;
            canvas.drawCircle(dx, dy, this.radius, this.mPaintPage);
        }
        float dx = firstX + (float)this.realCurrentItem * this.circlePadding + this.radius * 2.0f * (float)this.realCurrentItem;
        float dy = firstY;
        canvas.drawCircle(dx, dy, this.radius, this.mPaintFill);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int viewWidth = widthMode == 0x40000000 ? widthSize : (int)((float)this.getPaddingLeft() + this.radius * 2.0f * (float)this.getCount() + this.circlePadding * (float)(this.getCount() - 1) + (float)this.getPaddingRight()) + 1;
        int viewHeight = heightMode == 0x40000000 ? heightSize : (int)((float)this.getPaddingTop() + this.radius * 2.0f + (float)this.getPaddingBottom()) + 1;
        this.setMeasuredDimension(viewWidth, viewHeight);
    }

    public int getCount() {
        if (this.mCircleViewPager == null || this.mCircleViewPager.getAdapter() == null) {
            return 0;
        }
        return this.mCircleViewPager.getRealCount();
    }
}

