/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component.list;

import android.content.Context;
import android.util.Pair;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.annotation.Component;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.dom.WXRecyclerDomObject;
import com.taobao.weex.ui.component.WXBaseRefresh;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXLoading;
import com.taobao.weex.ui.component.WXRefresh;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.component.list.BasicListComponent;
import com.taobao.weex.ui.view.listview.WXRecyclerView;
import com.taobao.weex.ui.view.refresh.wrapper.BounceRecyclerView;
import java.util.Map;

@Component(lazyload=false)
public class WXListComponent
extends BasicListComponent<BounceRecyclerView> {
    private String TAG = "WXListComponent";
    private WXRecyclerDomObject mRecyclerDom;
    private float mPaddingLeft;
    private float mPaddingRight;

    @Deprecated
    public WXListComponent(WXSDKInstance instance, WXDomObject dom, WXVContainer parent, String instanceId, boolean isLazy) {
        this(instance, dom, parent, isLazy);
    }

    public WXListComponent(WXSDKInstance instance, WXDomObject node, WXVContainer parent, boolean lazy) {
        super(instance, node, parent);
        if (node != null && node instanceof WXRecyclerDomObject) {
            this.mRecyclerDom = (WXRecyclerDomObject)node;
            this.mRecyclerDom.preCalculateCellWidth();
            this.mLayoutType = "waterfall".equals(node.getType()) ? 3 : this.mRecyclerDom.getLayoutType();
            this.updateRecyclerAttr();
        }
    }

    @Override
    protected BounceRecyclerView generateListView(Context context, int orientation) {
        return new BounceRecyclerView(context, this.mLayoutType, this.mColumnCount, this.mColumnGap, orientation);
    }

    @Override
    public void addChild(final WXComponent child, int index) {
        super.addChild(child, index);
        if (child == null || index < -1) {
            return;
        }
        if (child instanceof WXRefresh && this.getHostView() != null) {
            ((BounceRecyclerView)this.getHostView()).setOnRefreshListener((WXRefresh)child);
            ((BounceRecyclerView)this.getHostView()).postDelayed(new Runnable(){

                @Override
                public void run() {
                    ((BounceRecyclerView)WXListComponent.this.getHostView()).setHeaderView(child);
                }
            }, 100L);
        }
        if (child instanceof WXLoading && this.getHostView() != null) {
            ((BounceRecyclerView)this.getHostView()).setOnLoadingListener((WXLoading)child);
            ((BounceRecyclerView)this.getHostView()).postDelayed(new Runnable(){

                @Override
                public void run() {
                    ((BounceRecyclerView)WXListComponent.this.getHostView()).setFooterView(child);
                }
            }, 100L);
        }
        if (this.mRecyclerDom != null && this.getHostView() != null && (this.mColumnWidth != this.mRecyclerDom.getColumnWidth() || this.mColumnCount != this.mRecyclerDom.getColumnCount() || this.mColumnGap != this.mRecyclerDom.getColumnGap())) {
            this.updateRecyclerAttr();
            ((WXRecyclerView)((BounceRecyclerView)this.getHostView()).getInnerView()).initView(this.getContext(), this.mLayoutType, this.mColumnCount, this.mColumnGap, this.getOrientation());
        }
    }

    private void updateRecyclerAttr() {
        if (this.mRecyclerDom != null) {
            this.mColumnCount = this.mRecyclerDom.getColumnCount();
            this.mColumnGap = this.mRecyclerDom.getColumnGap();
            this.mColumnWidth = this.mRecyclerDom.getColumnWidth();
            this.mPaddingLeft = this.mRecyclerDom.getPadding().get(0);
            this.mPaddingRight = this.mRecyclerDom.getPadding().get(2);
        }
    }

    @WXComponentProp(name="columnWidth")
    public void setColumnWidth(int columnCount) {
        if (this.mRecyclerDom != null && this.mRecyclerDom.getColumnWidth() != this.mColumnWidth) {
            this.markComponentUsable();
            this.updateRecyclerAttr();
            WXRecyclerView wxRecyclerView = (WXRecyclerView)((BounceRecyclerView)this.getHostView()).getInnerView();
            wxRecyclerView.initView(this.getContext(), this.mLayoutType, this.mColumnCount, this.mColumnGap, this.getOrientation());
        }
    }

    @WXComponentProp(name="columnCount")
    public void setColumnCount(int columnCount) {
        if (this.mRecyclerDom != null && this.mRecyclerDom.getColumnCount() != this.mColumnCount) {
            this.markComponentUsable();
            this.updateRecyclerAttr();
            WXRecyclerView wxRecyclerView = (WXRecyclerView)((BounceRecyclerView)this.getHostView()).getInnerView();
            wxRecyclerView.initView(this.getContext(), this.mLayoutType, this.mColumnCount, this.mColumnGap, this.getOrientation());
        }
    }

    @WXComponentProp(name="columnGap")
    public void setColumnGap(float columnGap) throws InterruptedException {
        if (this.mRecyclerDom != null && this.mRecyclerDom.getColumnGap() != this.mColumnGap) {
            this.markComponentUsable();
            this.updateRecyclerAttr();
            WXRecyclerView wxRecyclerView = (WXRecyclerView)((BounceRecyclerView)this.getHostView()).getInnerView();
            wxRecyclerView.initView(this.getContext(), this.mLayoutType, this.mColumnCount, this.mColumnGap, this.getOrientation());
        }
    }

    @Override
    @WXComponentProp(name="scrollable")
    public void setScrollable(boolean scrollable) {
        WXRecyclerView inner = (WXRecyclerView)((BounceRecyclerView)this.getHostView()).getInnerView();
        inner.setScrollable(scrollable);
    }

    @Override
    public void updateProperties(Map<String, Object> props) {
        super.updateProperties(props);
        if ((props.containsKey("padding") || props.containsKey("paddingLeft") || props.containsKey("paddingRight")) && this.mRecyclerDom != null && (this.mPaddingLeft != this.mRecyclerDom.getPadding().get(0) || this.mPaddingRight != this.mRecyclerDom.getPadding().get(2))) {
            this.markComponentUsable();
            this.updateRecyclerAttr();
            WXRecyclerView wxRecyclerView = (WXRecyclerView)((BounceRecyclerView)this.getHostView()).getInnerView();
            wxRecyclerView.initView(this.getContext(), this.mLayoutType, this.mColumnCount, this.mColumnGap, this.getOrientation());
        }
    }

    @Override
    public void createChildViewAt(int index) {
        Pair<WXComponent, Integer> ret = this.rearrangeIndexAndGetChild(index);
        if (ret.first != null) {
            final WXComponent child = this.getChild((Integer)ret.second);
            if (child instanceof WXBaseRefresh) {
                child.createView();
                if (child instanceof WXRefresh) {
                    ((BounceRecyclerView)this.getHostView()).setOnRefreshListener((WXRefresh)child);
                    ((BounceRecyclerView)this.getHostView()).postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            ((BounceRecyclerView)WXListComponent.this.getHostView()).setHeaderView(child);
                        }
                    }, 100L);
                } else if (child instanceof WXLoading) {
                    ((BounceRecyclerView)this.getHostView()).setOnLoadingListener((WXLoading)child);
                    ((BounceRecyclerView)this.getHostView()).postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            ((BounceRecyclerView)WXListComponent.this.getHostView()).setFooterView(child);
                        }
                    }, 100L);
                }
            } else {
                super.createChildViewAt((Integer)ret.second);
            }
        }
    }

    @Override
    public void remove(WXComponent child, boolean destroy) {
        super.remove(child, destroy);
        if (child instanceof WXLoading) {
            ((BounceRecyclerView)this.getHostView()).removeFooterView(child);
        } else if (child instanceof WXRefresh) {
            ((BounceRecyclerView)this.getHostView()).removeHeaderView(child);
        }
    }
}

