/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.dom;

import android.text.TextUtils;
import android.util.Pair;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.dom.ApplyStyleConsumer;
import com.taobao.weex.dom.DOMActionContext;
import com.taobao.weex.dom.RenderAction;
import com.taobao.weex.dom.RenderActionTask;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.dom.action.Actions;
import com.taobao.weex.dom.flex.CSSLayoutContext;
import com.taobao.weex.tracing.Stopwatch;
import com.taobao.weex.tracing.WXTracing;
import com.taobao.weex.ui.IWXRenderTask;
import com.taobao.weex.ui.WXRenderManager;
import com.taobao.weex.ui.animation.WXAnimationBean;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.utils.WXLogUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

class DOMActionContextImpl
implements DOMActionContext {
    final ConcurrentHashMap<String, WXDomObject> mRegistry;
    private WXDomObject.Consumer mAddDOMConsumer;
    private WXDomObject.Consumer mUnregisterDomConsumer;
    private String mInstanceId;
    private WXRenderManager mWXRenderManager;
    private ArrayList<IWXRenderTask> mNormalTasks;
    private Set<Pair<String, Map<String, Object>>> animations;
    private CSSLayoutContext mLayoutContext;
    private volatile boolean mDirty;
    private boolean mDestroy = false;
    private Map<String, AddDomInfo> mAddDom = new HashMap<String, AddDomInfo>();

    public DOMActionContextImpl(String instanceId, WXRenderManager renderManager) {
        this.mInstanceId = instanceId;
        this.mLayoutContext = new CSSLayoutContext();
        this.mRegistry = new ConcurrentHashMap();
        this.mNormalTasks = new ArrayList();
        this.animations = new LinkedHashSet<Pair<String, Map<String, Object>>>();
        this.mWXRenderManager = renderManager;
        this.mAddDOMConsumer = new AddDOMConsumer(this.mRegistry);
        this.mUnregisterDomConsumer = new RemoveElementConsumer(this.mRegistry);
    }

    @Override
    public String getInstanceId() {
        return this.mInstanceId;
    }

    @Override
    public WXDomObject.Consumer getAddDOMConsumer() {
        return this.mAddDOMConsumer;
    }

    @Override
    public WXDomObject.Consumer getRemoveElementConsumer() {
        return this.mUnregisterDomConsumer;
    }

    @Override
    public WXDomObject.Consumer getApplyStyleConsumer() {
        return ApplyStyleConsumer.getInstance();
    }

    @Override
    public void addDomInfo(String ref, WXComponent component) {
        AddDomInfo addDomInfo = new AddDomInfo();
        addDomInfo.component = component;
        this.mAddDom.put(ref, addDomInfo);
    }

    public void destroy() {
        this.mDestroy = true;
        this.mRegistry.clear();
        this.mAddDOMConsumer = null;
        this.mNormalTasks.clear();
        this.mAddDom.clear();
        this.mLayoutContext = null;
        this.mWXRenderManager = null;
        this.animations.clear();
    }

    void rebuildingFixedDomTree(WXDomObject root) {
        if (root != null && root.getFixedStyleRefs() != null) {
            int size = root.getFixedStyleRefs().size();
            for (int i = 0; i < size; ++i) {
                String fixedRef = root.getFixedStyleRefs().get(i);
                WXDomObject wxDomObject = this.mRegistry.get(fixedRef);
                if (wxDomObject == null || wxDomObject.parent == null) continue;
                wxDomObject.parent.remove(wxDomObject);
                root.add(wxDomObject, -1);
            }
        }
    }

    void batch() {
        if (!this.mDirty || this.mDestroy) {
            return;
        }
        long start = System.currentTimeMillis();
        long startNanos = System.nanoTime();
        WXDomObject rootDom = this.mRegistry.get("_root");
        this.layout(rootDom);
        if (WXTracing.isAvailable()) {
            WXTracing.TraceEvent batchEvent = WXTracing.newEvent("domBatch", this.mInstanceId, -1);
            batchEvent.duration = Stopwatch.millisUntilNow(startNanos);
            batchEvent.ts = start;
            batchEvent.ph = "X";
            WXTracing.submit(batchEvent);
        }
    }

    void layout(WXDomObject rootDom) {
        boolean isPreRenderMode;
        if (rootDom == null) {
            return;
        }
        long start0 = System.currentTimeMillis();
        this.rebuildingFixedDomTree(rootDom);
        rootDom.traverseTree(new WXDomObject.Consumer(){

            @Override
            public void accept(WXDomObject dom) {
                if (!dom.hasUpdate() || DOMActionContextImpl.this.mDestroy) {
                    return;
                }
                dom.layoutBefore();
            }
        });
        long start = System.currentTimeMillis();
        rootDom.calculateLayout(this.mLayoutContext);
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(this.mInstanceId);
        if (instance != null) {
            instance.cssLayoutTime(System.currentTimeMillis() - start);
        }
        rootDom.traverseTree(new WXDomObject.Consumer(){

            @Override
            public void accept(WXDomObject dom) {
                if (!dom.hasUpdate() || DOMActionContextImpl.this.mDestroy) {
                    return;
                }
                dom.layoutAfter();
            }
        });
        start = System.currentTimeMillis();
        rootDom.traverseTree(new ApplyUpdateConsumer());
        if (instance != null) {
            instance.applyUpdateTime(System.currentTimeMillis() - start);
        }
        start = System.currentTimeMillis();
        this.updateDomObj();
        if (instance != null) {
            instance.updateDomObjTime(System.currentTimeMillis() - start);
        }
        this.parseAnimation();
        boolean bl = isPreRenderMode = instance != null && instance.isPreRenderMode();
        if (!isPreRenderMode) {
            this.consumeRenderTasks();
        }
        this.mAddDom.clear();
        this.animations.clear();
        this.mDirty = false;
        if (instance != null) {
            instance.batchTime(System.currentTimeMillis() - start0);
        }
    }

    void consumeRenderTasks() {
        int count = this.mNormalTasks.size();
        for (int i = 0; i < count && !this.mDestroy; ++i) {
            this.mWXRenderManager.runOnThread(this.mInstanceId, this.mNormalTasks.get(i));
        }
        this.mNormalTasks.clear();
    }

    private void parseAnimation() {
        for (Pair<String, Map<String, Object>> pair : this.animations) {
            WXAnimationBean animationBean;
            if (TextUtils.isEmpty((CharSequence)((CharSequence)pair.first)) || (animationBean = this.createAnimationBean((String)pair.first, (Map)pair.second)) == null) continue;
            this.postRenderTask(Actions.getAnimationAction((String)pair.first, animationBean));
        }
    }

    private void updateDomObj() {
        long start = System.currentTimeMillis();
        for (Map.Entry<String, AddDomInfo> entry : this.mAddDom.entrySet()) {
            AddDomInfo value = entry.getValue();
            this.updateDomObj(value.component);
        }
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.d("updateDomObj", "time:" + (System.currentTimeMillis() - start));
        }
    }

    private void updateDomObj(WXComponent component) {
        if (component == null) {
            return;
        }
        WXDomObject domObject = this.mRegistry.get(component.getRef());
        if (domObject == null) {
            return;
        }
        domObject.old();
        component.updateDom(domObject);
        if (component instanceof WXVContainer) {
            WXVContainer container = (WXVContainer)component;
            int count = container.childCount();
            for (int i = 0; i < count; ++i) {
                this.updateDomObj(container.getChild(i));
            }
        }
    }

    @Override
    public void addAnimationForElement(String ref, Map<String, Object> animMap) {
        this.animations.add((Pair<String, Map<String, Object>>)new Pair((Object)ref, animMap));
        this.mDirty = true;
    }

    @Override
    public void postRenderTask(RenderAction action) {
        this.mNormalTasks.add(new RenderActionTask(action, this.mWXRenderManager.getRenderContext(this.mInstanceId)));
        this.mDirty = true;
    }

    @Override
    public void registerDOMObject(String ref, WXDomObject obj) {
        this.mRegistry.put(ref, obj);
    }

    @Override
    public void unregisterDOMObject(String ref) {
        this.mRegistry.remove(ref);
    }

    @Override
    public void registerComponent(String ref, WXComponent comp) {
        this.mWXRenderManager.registerComponent(this.mInstanceId, ref, comp);
    }

    @Override
    public WXComponent getCompByRef(String ref) {
        return this.mWXRenderManager.getWXComponent(this.mInstanceId, ref);
    }

    @Override
    public boolean isDestory() {
        return false;
    }

    @Override
    public WXSDKInstance getInstance() {
        return this.mWXRenderManager.getWXSDKInstance(this.mInstanceId);
    }

    @Override
    public WXDomObject getDomByRef(String ref) {
        return this.mRegistry.get(ref);
    }

    private WXAnimationBean createAnimationBean(String ref, Map<String, Object> style) {
        if (style != null) {
            try {
                Object transform = style.get("transform");
                if (transform instanceof String && !TextUtils.isEmpty((CharSequence)((String)transform))) {
                    String transformOrigin = (String)style.get("transformOrigin");
                    WXAnimationBean animationBean = new WXAnimationBean();
                    WXDomObject domObject = this.mRegistry.get(ref);
                    int width = (int)domObject.getLayoutWidth();
                    int height = (int)domObject.getLayoutHeight();
                    animationBean.styles = new WXAnimationBean.Style();
                    animationBean.styles.init(transformOrigin, (String)transform, width, height, WXSDKManager.getInstanceViewPortWidth(this.mInstanceId));
                    return animationBean;
                }
            }
            catch (RuntimeException e) {
                WXLogUtils.e("", e);
                return null;
            }
        }
        return null;
    }

    static class AddDomInfo {
        public WXComponent component;

        AddDomInfo() {
        }
    }

    private static class AddDOMConsumer
    implements WXDomObject.Consumer {
        final ConcurrentHashMap<String, WXDomObject> mRegistry;

        AddDOMConsumer(ConcurrentHashMap<String, WXDomObject> r) {
            this.mRegistry = r;
        }

        @Override
        public void accept(WXDomObject dom) {
            dom.young();
            this.mRegistry.put(dom.getRef(), dom);
            WXDomObject rootDom = this.mRegistry.get("_root");
            if (rootDom != null && dom.isFixed()) {
                rootDom.add2FixedDomList(dom.getRef());
            }
        }
    }

    private static class RemoveElementConsumer
    implements WXDomObject.Consumer {
        final ConcurrentHashMap<String, WXDomObject> mRegistry;

        RemoveElementConsumer(ConcurrentHashMap<String, WXDomObject> r) {
            this.mRegistry = r;
        }

        @Override
        public void accept(WXDomObject dom) {
            this.mRegistry.remove(dom.getRef());
        }
    }

    private class ApplyUpdateConsumer
    implements WXDomObject.Consumer {
        private ApplyUpdateConsumer() {
        }

        @Override
        public void accept(WXDomObject dom) {
            if (dom.hasUpdate()) {
                dom.markUpdateSeen();
                if (!dom.isYoung()) {
                    final WXDomObject copy = dom.clone();
                    if (copy == null) {
                        return;
                    }
                    DOMActionContextImpl.this.mNormalTasks.add(new IWXRenderTask(){

                        @Override
                        public void execute() {
                            DOMActionContextImpl.this.mWXRenderManager.setLayout(DOMActionContextImpl.this.mInstanceId, copy.getRef(), copy);
                            if (copy.getExtra() != null) {
                                DOMActionContextImpl.this.mWXRenderManager.setExtra(DOMActionContextImpl.this.mInstanceId, copy.getRef(), copy.getExtra());
                            }
                        }

                        public String toString() {
                            return "setLayout & setExtra";
                        }
                    });
                }
            }
        }
    }
}

