/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component.list;

import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.RestrictTo;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.annotation.Component;
import com.taobao.weex.dom.WXAttr;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.flat.WidgetContainer;
import com.taobao.weex.ui.view.WXFrameLayout;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXUtils;

@Component(lazyload=false)
public class WXCell
extends WidgetContainer<WXFrameLayout> {
    private int mLastLocationY = 0;
    private ViewGroup mRealView;
    private View mTempStickyView;
    private View mHeadView;
    private boolean mLazy = true;
    private int mScrollPositon = -1;
    private boolean mFlatUIEnabled = false;

    @Deprecated
    public WXCell(WXSDKInstance instance, WXDomObject dom, WXVContainer parent, String instanceId, boolean isLazy) {
        super(instance, dom, parent);
    }

    public WXCell(WXSDKInstance instance, WXDomObject dom, WXVContainer parent, boolean isLazy) {
        super(instance, dom, parent);
        if (Build.VERSION.SDK_INT < 21) {
            try {
                WXAttr attr = this.getDomObject().getAttrs();
                if (attr.containsKey("flat")) {
                    this.mFlatUIEnabled = WXUtils.getBoolean(attr.get("flat"), false);
                }
            }
            catch (NullPointerException e) {
                WXLogUtils.e("Cell", WXLogUtils.getStackTrace(e));
            }
        }
    }

    @Override
    public boolean isLazy() {
        return this.mLazy && !this.isFixed();
    }

    public void lazy(boolean lazy) {
        this.mLazy = lazy;
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public boolean isFlatUIEnabled() {
        return this.mFlatUIEnabled;
    }

    @Override
    protected WXFrameLayout initComponentHostView(@NonNull Context context) {
        if (this.isSticky()) {
            WXFrameLayout view = new WXFrameLayout(context);
            this.mRealView = new WXFrameLayout(context);
            view.addView((View)this.mRealView);
            if (this.isFlatUIEnabled()) {
                view.setLayerType(2, null);
            }
            return view;
        }
        WXFrameLayout view = new WXFrameLayout(context);
        this.mRealView = view;
        if (this.isFlatUIEnabled()) {
            view.setLayerType(2, null);
        }
        return view;
    }

    public int getLocationFromStart() {
        return this.mLastLocationY;
    }

    public void setLocationFromStart(int l) {
        this.mLastLocationY = l;
    }

    void setScrollPositon(int pos) {
        this.mScrollPositon = pos;
    }

    public int getScrollPositon() {
        return this.mScrollPositon;
    }

    @Override
    public ViewGroup getRealView() {
        return this.mRealView;
    }

    public void removeSticky() {
        this.mHeadView = ((WXFrameLayout)this.getHostView()).getChildAt(0);
        int[] location = new int[2];
        int[] parentLocation = new int[2];
        ((WXFrameLayout)this.getHostView()).getLocationOnScreen(location);
        this.getParentScroller().getView().getLocationOnScreen(parentLocation);
        int headerViewOffsetX = location[0] - parentLocation[0];
        int headerViewOffsetY = this.getParent().getHostView().getTop();
        ((WXFrameLayout)this.getHostView()).removeView(this.mHeadView);
        this.mRealView = (ViewGroup)this.mHeadView;
        this.mTempStickyView = new FrameLayout(this.getContext());
        FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams((int)this.getDomObject().getLayoutWidth(), (int)this.getDomObject().getLayoutHeight());
        ((WXFrameLayout)this.getHostView()).addView(this.mTempStickyView, (ViewGroup.LayoutParams)lp);
        this.mHeadView.setTranslationX((float)headerViewOffsetX);
        this.mHeadView.setTranslationY((float)headerViewOffsetY);
    }

    public void recoverySticky() {
        ((WXFrameLayout)this.getHostView()).removeView(this.mTempStickyView);
        ((WXFrameLayout)this.getHostView()).addView(this.mHeadView);
        this.mHeadView.setTranslationX(0.0f);
        this.mHeadView.setTranslationY(0.0f);
    }

    @Override
    protected void mountFlatGUI() {
        if (this.getHostView() != null) {
            ((WXFrameLayout)this.getHostView()).mountFlatGUI(this.widgets);
        }
    }

    @Override
    public void unmountFlatGUI() {
        if (this.getHostView() != null) {
            ((WXFrameLayout)this.getHostView()).unmountFlatGUI();
        }
    }

    @Override
    public boolean intendToBeFlatContainer() {
        return this.getInstance().getFlatUIContext().isFlatUIEnabled(this) && WXCell.class.equals(this.getClass()) && !this.isSticky();
    }
}

