/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.dom.action;

import com.taobao.weex.LayoutFinishListener;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.common.WXRenderStrategy;
import com.taobao.weex.common.WXThread;
import com.taobao.weex.dom.DOMActionContext;
import com.taobao.weex.dom.RenderActionContext;
import com.taobao.weex.dom.action.AbstractLayoutFinishAction;
import com.taobao.weex.tracing.Stopwatch;
import com.taobao.weex.tracing.WXTracing;

final class CreateFinishAction
extends AbstractLayoutFinishAction {
    CreateFinishAction() {
    }

    @Override
    public void executeDom(DOMActionContext context) {
        LayoutFinishListener listener;
        super.executeDom(context);
        final WXSDKInstance instance = context.getInstance();
        if (instance != null && (listener = instance.getLayoutFinishListener()) != null) {
            WXSDKManager.getInstance().getWXRenderManager().postOnUiThread(WXThread.secure(new Runnable(){

                @Override
                public void run() {
                    listener.onLayoutFinish(instance);
                }
            }), 0L);
        }
    }

    @Override
    public void executeRender(RenderActionContext context) {
        WXSDKInstance instance = context.getInstance();
        if (instance.getRenderStrategy() == WXRenderStrategy.APPEND_ONCE) {
            instance.onCreateFinish();
        }
        instance.onRenderSuccess(this.mLayoutWidth, this.mLayoutHeight);
        if (WXTracing.isAvailable()) {
            double renderTime = Stopwatch.millisUntilNow(context.getInstance().mRenderStartNanos);
            this.submitPerformance("renderFinish", "X", instance.getInstanceId(), renderTime, System.currentTimeMillis(), new boolean[0]);
        }
    }
}

