/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.dom;

import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.dom.DOMAction;
import com.taobao.weex.dom.WXDomManager;
import com.taobao.weex.dom.WXDomTask;
import com.taobao.weex.dom.action.Actions;
import com.taobao.weex.dom.action.TraceableAction;

public class WXDomHandler
implements Handler.Callback {
    public static final int DELAY_TIME = 16;
    private WXDomManager mWXDomManager;
    private boolean mHasBatch = false;

    public WXDomHandler(WXDomManager domManager) {
        this.mWXDomManager = domManager;
    }

    public boolean handleMessage(Message msg) {
        if (msg == null) {
            return false;
        }
        int what = msg.what;
        Object obj = msg.obj;
        WXDomTask task = null;
        if (obj != null && obj instanceof WXDomTask) {
            task = (WXDomTask)obj;
            Object action = ((WXDomTask)obj).args.get(0);
            if (action != null && action instanceof TraceableAction) {
                ((TraceableAction)action).mDomQueueTime = SystemClock.uptimeMillis() - msg.getWhen();
            }
        }
        if (!this.mHasBatch) {
            this.mHasBatch = true;
            this.mWXDomManager.sendEmptyMessageDelayed(255, 16L);
        }
        switch (what) {
            case 254: {
                this.mWXDomManager.executeAction(task.instanceId, (DOMAction)task.args.get(0), (Boolean)task.args.get(1));
                break;
            }
            case 2: {
                this.mWXDomManager.executeAction(task.instanceId, Actions.getUpdateStyle((String)task.args.get(0), (JSONObject)task.args.get(1), task.args.size() > 2 && (Boolean)task.args.get(2) != false), false);
                break;
            }
            case 255: {
                this.mWXDomManager.batch();
                this.mHasBatch = false;
                break;
            }
            case 250: {
                this.mWXDomManager.consumeRenderTask(task.instanceId);
                break;
            }
        }
        return true;
    }

    public static class MsgType {
        @Deprecated
        public static final int WX_DOM_CREATE_BODY = 0;
        @Deprecated
        public static final int WX_DOM_UPDATE_ATTRS = 1;
        @Deprecated
        public static final int WX_DOM_UPDATE_STYLE = 2;
        @Deprecated
        public static final int WX_DOM_ADD_DOM = 3;
        @Deprecated
        public static final int WX_DOM_REMOVE_DOM = 4;
        @Deprecated
        public static final int WX_DOM_MOVE_DOM = 5;
        @Deprecated
        public static final int WX_DOM_ADD_EVENT = 6;
        @Deprecated
        public static final int WX_DOM_REMOVE_EVENT = 7;
        @Deprecated
        public static final int WX_DOM_SCROLLTO = 8;
        @Deprecated
        public static final int WX_DOM_CREATE_FINISH = 9;
        @Deprecated
        public static final int WX_DOM_REFRESH_FINISH = 10;
        @Deprecated
        public static final int WX_DOM_UPDATE_FINISH = 11;
        @Deprecated
        public static final int WX_ANIMATION = 12;
        @Deprecated
        public static final int WX_DOM_ADD_RULE = 13;
        @Deprecated
        public static final int WX_DOM_INVOKE = 14;
        public static final int WX_EXECUTE_ACTION = 254;
        public static final int WX_DOM_BATCH = 255;
        public static final int WX_CONSUME_RENDER_TASKS = 250;
        @Deprecated
        public static final int WX_COMPONENT_SIZE = 4081;
    }
}

