/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.common;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.utils.WXLogUtils;

public class WXThread
extends HandlerThread {
    private Handler mHandler;
    private static final String SYSTEM_ACTION_PREFIX = "android.view.";

    public static Runnable secure(Runnable runnable) {
        if (runnable == null || runnable instanceof SafeRunnable) {
            return runnable;
        }
        String className = runnable.getClass().getCanonicalName();
        if (className != null && className.startsWith(SYSTEM_ACTION_PREFIX)) {
            return runnable;
        }
        return new SafeRunnable(runnable);
    }

    public static Handler.Callback secure(Handler.Callback callback) {
        if (callback == null || callback instanceof SafeCallback) {
            return callback;
        }
        return new SafeCallback(callback);
    }

    public WXThread(String name) {
        super(name);
        this.start();
        this.mHandler = new Handler(this.getLooper());
    }

    public WXThread(String name, Handler.Callback callback) {
        super(name);
        this.start();
        this.mHandler = new Handler(this.getLooper(), WXThread.secure(callback));
    }

    public WXThread(String name, int priority, Handler.Callback callback) {
        super(name, priority);
        this.start();
        this.mHandler = new Handler(this.getLooper(), WXThread.secure(callback));
    }

    public WXThread(String name, int priority) {
        super(name, priority);
        this.start();
        this.mHandler = new Handler(this.getLooper());
    }

    public Handler getHandler() {
        return this.mHandler;
    }

    public boolean isWXThreadAlive() {
        return this.mHandler != null && this.getLooper() != null && this.isAlive();
    }

    public boolean quit() {
        if (this.mHandler != null) {
            this.mHandler.removeCallbacksAndMessages(null);
        }
        return super.quit();
    }

    static class SafeCallback
    implements Handler.Callback {
        static final String TAG = "SafeCallback";
        final Handler.Callback mCallback;

        SafeCallback(Handler.Callback cb) {
            this.mCallback = cb;
        }

        public boolean handleMessage(Message msg) {
            boolean result;
            block3: {
                result = false;
                try {
                    if (this.mCallback != null) {
                        result = this.mCallback.handleMessage(msg);
                    }
                }
                catch (Throwable e) {
                    if (!WXEnvironment.isApkDebugable()) break block3;
                    WXLogUtils.e(TAG, "SafeCallback handleMessage throw expection:" + e.getMessage());
                    throw e;
                }
            }
            return result;
        }
    }

    static class SafeRunnable
    implements Runnable {
        static final String TAG = "SafeRunnable";
        final Runnable mTask;

        SafeRunnable(Runnable task) {
            this.mTask = task;
        }

        @Override
        public void run() {
            block3: {
                try {
                    if (this.mTask != null) {
                        this.mTask.run();
                    }
                }
                catch (Throwable e) {
                    if (!WXEnvironment.isApkDebugable()) break block3;
                    WXLogUtils.e(TAG, "SafeRunnable run throw expection:" + e.getMessage());
                    throw e;
                }
            }
        }
    }
}

