/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.utils;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import com.taobao.weex.adapter.IWXUserTrackAdapter;
import com.taobao.weex.common.WXErrorCode;
import com.taobao.weex.common.WXPerformance;
import com.taobao.weex.utils.WXLogUtils;
import dalvik.system.PathClassLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class WXSoInstallMgrSdk {
    static final String LOGTAG = "INIT_SO";
    private static final String ARMEABI = "armeabi";
    private static final String X86 = "x86";
    private static final String MIPS = "mips";
    private static final int ARMEABI_Size = 3583820;
    private static final int X86_Size = 4340864;
    static Context mContext = null;

    public static void init(Context c) {
        mContext = c;
    }

    public static boolean isX86() {
        String cpuType = WXSoInstallMgrSdk._cpuType();
        return cpuType.equalsIgnoreCase(X86);
    }

    public static boolean isCPUSupport() {
        String cpuType = WXSoInstallMgrSdk._cpuType();
        return !cpuType.equalsIgnoreCase(MIPS);
    }

    public static boolean initSo(String libName, int version, IWXUserTrackAdapter utAdapter) {
        String cpuType = WXSoInstallMgrSdk._cpuType();
        if (cpuType.equalsIgnoreCase(MIPS)) {
            return false;
        }
        boolean InitSuc = false;
        if (WXSoInstallMgrSdk.checkSoIsValid(libName, 3583820L) || WXSoInstallMgrSdk.checkSoIsValid(libName, 4336768L)) {
            try {
                System.loadLibrary(libName);
                WXSoInstallMgrSdk.commit(utAdapter, null, null);
                InitSuc = true;
            }
            catch (Error | Exception e2) {
                if (cpuType.contains(ARMEABI) || cpuType.contains(X86)) {
                    WXSoInstallMgrSdk.commit(utAdapter, WXErrorCode.WX_ERR_LOAD_SO.getErrorCode(), WXErrorCode.WX_ERR_LOAD_SO.getErrorMsg() + ":" + e2.getMessage());
                }
                InitSuc = false;
            }
            try {
                if (!InitSuc) {
                    if (WXSoInstallMgrSdk.isExist(libName, version)) {
                        boolean res = WXSoInstallMgrSdk._loadUnzipSo(libName, version, utAdapter);
                        if (res) {
                            return res;
                        }
                        WXSoInstallMgrSdk.removeSoIfExit(libName, version);
                    }
                    if (cpuType.equalsIgnoreCase(MIPS)) {
                        return false;
                    }
                    try {
                        InitSuc = WXSoInstallMgrSdk.unZipSelectedFiles(libName, version, utAdapter);
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            catch (Error | Exception e) {
                InitSuc = false;
                e.printStackTrace();
            }
        }
        return InitSuc;
    }

    private static String _getFieldReflectively(Build build, String fieldName) {
        try {
            Field field = Build.class.getField(fieldName);
            return field.get(build).toString();
        }
        catch (Exception ex) {
            return "Unknown";
        }
    }

    private static String _cpuType() {
        String abi = WXSoInstallMgrSdk._getFieldReflectively(new Build(), "CPU_ABI");
        if (abi == null || abi.length() == 0 || abi.equals("Unknown")) {
            abi = ARMEABI;
        }
        abi = abi.toLowerCase();
        return abi;
    }

    static boolean checkSoIsValid(String libName, long size) {
        Context context = mContext;
        if (null == context) {
            return false;
        }
        try {
            long start = System.currentTimeMillis();
            if (WXSoInstallMgrSdk.class.getClassLoader() instanceof PathClassLoader) {
                String path = ((PathClassLoader)WXSoInstallMgrSdk.class.getClassLoader()).findLibrary(libName);
                File file = new File(path);
                if (!file.exists() || size == file.length()) {
                    WXLogUtils.w("weex so size check path :" + path + "   " + (System.currentTimeMillis() - start));
                    return true;
                }
                return false;
            }
        }
        catch (Throwable e) {
            WXLogUtils.e("weex so size check fail exception :" + e.getMessage());
        }
        return true;
    }

    static String _targetSoFile(String libName, int version) {
        Context context = mContext;
        if (null == context) {
            return "";
        }
        String path = "/data/data/" + context.getPackageName() + "/files";
        File f = context.getFilesDir();
        if (f != null) {
            path = f.getPath();
        }
        return path + "/lib" + libName + "bk" + version + ".so";
    }

    static void removeSoIfExit(String libName, int version) {
        String file = WXSoInstallMgrSdk._targetSoFile(libName, version);
        File a = new File(file);
        if (a.exists()) {
            a.delete();
        }
    }

    static boolean isExist(String libName, int version) {
        String file = WXSoInstallMgrSdk._targetSoFile(libName, version);
        File a = new File(file);
        return a.exists();
    }

    static boolean _loadUnzipSo(String libName, int version, IWXUserTrackAdapter utAdapter) {
        boolean initSuc = false;
        try {
            if (WXSoInstallMgrSdk.isExist(libName, version)) {
                System.load(WXSoInstallMgrSdk._targetSoFile(libName, version));
                WXSoInstallMgrSdk.commit(utAdapter, "2000", "Load file extract from apk successfully.");
            }
            initSuc = true;
        }
        catch (Throwable e) {
            WXSoInstallMgrSdk.commit(utAdapter, WXErrorCode.WX_ERR_COPY_FROM_APK.getErrorCode(), WXErrorCode.WX_ERR_COPY_FROM_APK.getErrorMsg() + ":" + e.getMessage());
            initSuc = false;
            WXLogUtils.e("", e);
        }
        return initSuc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean unZipSelectedFiles(String libName, int version, IWXUserTrackAdapter utAdapter) throws ZipException, IOException {
        String sourcePath = "lib/armeabi/lib" + libName + ".so";
        String zipPath = "";
        Context context = mContext;
        if (context == null) {
            return false;
        }
        ApplicationInfo aInfo = context.getApplicationInfo();
        if (null != aInfo) {
            zipPath = aInfo.sourceDir;
        }
        ZipFile zf = new ZipFile(zipPath);
        try {
            Enumeration<? extends ZipEntry> entries = zf.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!entry.getName().startsWith(sourcePath)) continue;
                InputStream in = null;
                FileOutputStream os = null;
                AbstractInterruptibleChannel channel = null;
                int total = 0;
                try {
                    int realLength;
                    WXSoInstallMgrSdk.removeSoIfExit(libName, version);
                    in = zf.getInputStream(entry);
                    os = context.openFileOutput("lib" + libName + "bk" + version + ".so", 0);
                    channel = os.getChannel();
                    byte[] buffers = new byte[1024];
                    while ((realLength = in.read(buffers)) > 0) {
                        ((FileChannel)channel).write(ByteBuffer.wrap(buffers, 0, realLength));
                        total += realLength;
                    }
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (zf != null) {
                        zf.close();
                        zf = null;
                    }
                }
                if (total > 0) {
                    boolean bl = WXSoInstallMgrSdk._loadUnzipSo(libName, version, utAdapter);
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (zf != null) {
                zf.close();
                zf = null;
            }
        }
        return false;
    }

    static void commit(IWXUserTrackAdapter utAdapter, String errCode, String errMsg) {
        if (utAdapter == null) {
            return;
        }
        if (errCode != null && errMsg != null) {
            WXPerformance p = new WXPerformance();
            p.errCode = errCode;
            p.errMsg = errMsg;
            utAdapter.commit(null, null, "environment", p, null);
        } else {
            utAdapter.commit(null, null, "environment", null, null);
        }
    }
}

