/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component.list;

import android.content.Context;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.annotation.Component;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.dom.WXRecyclerDomObject;
import com.taobao.weex.ui.component.WXBaseRefresh;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXLoading;
import com.taobao.weex.ui.component.WXRefresh;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.component.list.BasicListComponent;
import com.taobao.weex.ui.view.listview.WXRecyclerView;
import com.taobao.weex.ui.view.refresh.wrapper.BounceRecyclerView;
import com.taobao.weex.utils.WXLogUtils;
import java.util.Map;

@Component(lazyload=false)
public class WXListComponent
extends BasicListComponent<BounceRecyclerView> {
    private String TAG = "WXListComponent";
    private WXRecyclerDomObject mDomObject;
    private float mPaddingLeft;
    private float mPaddingRight;

    @Deprecated
    public WXListComponent(WXSDKInstance instance, WXDomObject dom, WXVContainer parent, String instanceId, boolean isLazy) {
        this(instance, dom, parent, isLazy);
    }

    public WXListComponent(WXSDKInstance instance, WXDomObject node, WXVContainer parent, boolean lazy) {
        super(instance, node, parent);
        if (node != null && node instanceof WXRecyclerDomObject) {
            this.mDomObject = (WXRecyclerDomObject)node;
            this.mDomObject.preCalculateCellWidth();
            this.mLayoutType = "waterfall".equals(node.getType()) ? 3 : this.mDomObject.getLayoutType();
            this.updateRecyclerAttr();
        }
    }

    @Override
    protected BounceRecyclerView generateListView(Context context, int orientation) {
        return new BounceRecyclerView(context, this.mLayoutType, this.mColumnCount, this.mColumnGap, orientation);
    }

    @Override
    public void addChild(WXComponent child, int index) {
        super.addChild(child, index);
        if (child == null || index < -1) {
            return;
        }
        this.setRefreshOrLoading(child);
    }

    private boolean setRefreshOrLoading(final WXComponent child) {
        if (this.getHostView() == null) {
            WXLogUtils.e(this.TAG, "setRefreshOrLoading: HostView == null !!!!!! check list attr has append =tree");
            return true;
        }
        if (child instanceof WXRefresh) {
            ((BounceRecyclerView)this.getHostView()).setOnRefreshListener((WXRefresh)child);
            ((BounceRecyclerView)this.getHostView()).postDelayed(new Runnable(){

                @Override
                public void run() {
                    ((BounceRecyclerView)WXListComponent.this.getHostView()).setHeaderView(child);
                }
            }, 100L);
            return true;
        }
        if (child instanceof WXLoading) {
            ((BounceRecyclerView)this.getHostView()).setOnLoadingListener((WXLoading)child);
            ((BounceRecyclerView)this.getHostView()).postDelayed(new Runnable(){

                @Override
                public void run() {
                    ((BounceRecyclerView)WXListComponent.this.getHostView()).setFooterView(child);
                }
            }, 100L);
            return true;
        }
        return false;
    }

    private void updateRecyclerAttr() {
        this.mColumnCount = this.mDomObject.getColumnCount();
        this.mColumnGap = this.mDomObject.getColumnGap();
        this.mColumnWidth = this.mDomObject.getColumnWidth();
        this.mPaddingLeft = this.mDomObject.getPadding().get(0);
        this.mPaddingRight = this.mDomObject.getPadding().get(2);
    }

    @WXComponentProp(name="columnWidth")
    public void setColumnWidth(int columnCount) {
        if (this.mDomObject.getColumnWidth() != this.mColumnWidth) {
            this.markComponentUsable();
            this.updateRecyclerAttr();
            WXRecyclerView wxRecyclerView = (WXRecyclerView)((BounceRecyclerView)this.getHostView()).getInnerView();
            wxRecyclerView.initView(this.getContext(), this.mLayoutType, this.mColumnCount, this.mColumnGap, this.getOrientation());
        }
    }

    @WXComponentProp(name="columnCount")
    public void setColumnCount(int columnCount) {
        if (this.mDomObject.getColumnCount() != this.mColumnCount) {
            this.markComponentUsable();
            this.updateRecyclerAttr();
            WXRecyclerView wxRecyclerView = (WXRecyclerView)((BounceRecyclerView)this.getHostView()).getInnerView();
            wxRecyclerView.initView(this.getContext(), this.mLayoutType, this.mColumnCount, this.mColumnGap, this.getOrientation());
        }
    }

    @WXComponentProp(name="columnGap")
    public void setColumnGap(float columnGap) throws InterruptedException {
        if (this.mDomObject.getColumnGap() != this.mColumnGap) {
            this.markComponentUsable();
            this.updateRecyclerAttr();
            WXRecyclerView wxRecyclerView = (WXRecyclerView)((BounceRecyclerView)this.getHostView()).getInnerView();
            wxRecyclerView.initView(this.getContext(), this.mLayoutType, this.mColumnCount, this.mColumnGap, this.getOrientation());
        }
    }

    @Override
    @WXComponentProp(name="scrollable")
    public void setScrollable(boolean scrollable) {
        WXRecyclerView inner = (WXRecyclerView)((BounceRecyclerView)this.getHostView()).getInnerView();
        inner.setScrollable(scrollable);
    }

    @Override
    public void updateProperties(Map<String, Object> props) {
        super.updateProperties(props);
        if ((props.containsKey("padding") || props.containsKey("paddingLeft") || props.containsKey("paddingRight")) && (this.mPaddingLeft != this.mDomObject.getPadding().get(0) || this.mPaddingRight != this.mDomObject.getPadding().get(2))) {
            this.markComponentUsable();
            this.updateRecyclerAttr();
            WXRecyclerView wxRecyclerView = (WXRecyclerView)((BounceRecyclerView)this.getHostView()).getInnerView();
            wxRecyclerView.initView(this.getContext(), this.mLayoutType, this.mColumnCount, this.mColumnGap, this.getOrientation());
        }
    }

    @Override
    public void createChildViewAt(int index) {
        int indexToCreate = index;
        if (indexToCreate < 0 && (indexToCreate = this.childCount() - 1) < 0) {
            return;
        }
        final WXComponent child = this.getChild(indexToCreate);
        if (child instanceof WXBaseRefresh) {
            child.createView();
            if (child instanceof WXRefresh) {
                ((BounceRecyclerView)this.getHostView()).setOnRefreshListener((WXRefresh)child);
                ((BounceRecyclerView)this.getHostView()).postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        ((BounceRecyclerView)WXListComponent.this.getHostView()).setHeaderView(child);
                    }
                }, 100L);
            } else if (child instanceof WXLoading) {
                ((BounceRecyclerView)this.getHostView()).setOnLoadingListener((WXLoading)child);
                ((BounceRecyclerView)this.getHostView()).postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        ((BounceRecyclerView)WXListComponent.this.getHostView()).setFooterView(child);
                    }
                }, 100L);
            }
        } else {
            super.createChildViewAt(indexToCreate);
        }
    }

    @Override
    public void remove(WXComponent child, boolean destroy) {
        super.remove(child, destroy);
        this.removeFooterOrHeader(child);
    }

    private void removeFooterOrHeader(WXComponent child) {
        if (child instanceof WXLoading) {
            ((BounceRecyclerView)this.getHostView()).removeFooterView(child);
        } else if (child instanceof WXRefresh) {
            ((BounceRecyclerView)this.getHostView()).removeHeaderView(child);
        }
    }
}

