/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.annotation.Component;
import com.taobao.weex.dom.ImmutableDomObject;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.ui.component.WXBaseRefresh;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXScroller;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.component.list.WXListComponent;
import com.taobao.weex.ui.view.WXFrameLayout;
import com.taobao.weex.ui.view.WXLoadingLayout;
import com.taobao.weex.ui.view.refresh.core.WXSwipeLayout;
import com.taobao.weex.ui.view.refresh.wrapper.BaseBounceView;
import com.taobao.weex.utils.WXUtils;
import java.util.HashMap;

@Component(lazyload=false)
public class WXLoading
extends WXBaseRefresh
implements WXSwipeLayout.WXOnLoadingListener {
    public static final String HIDE = "hide";

    public WXLoading(WXSDKInstance instance, WXDomObject node, WXVContainer parent, boolean lazy) {
        super(instance, node, parent, lazy);
    }

    @Override
    protected WXFrameLayout initComponentHostView(@NonNull Context context) {
        return new WXLoadingLayout(context);
    }

    @Override
    public void onLoading() {
        ImmutableDomObject domObject = this.getDomObject();
        if (domObject != null && domObject.getEvents().contains("loading")) {
            this.fireEvent("loading");
        }
    }

    @Override
    public void onPullingUp(float dy, int pullOutDistance, float viewHeight) {
        ImmutableDomObject domObject = this.getDomObject();
        if (domObject != null && domObject.getEvents().contains("pullingup")) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("dy", Float.valueOf(dy));
            data.put("pullingDistance", pullOutDistance);
            data.put("viewHeight", Float.valueOf(viewHeight));
            this.fireEvent("pullingup", data);
        }
    }

    @Override
    public boolean canRecycled() {
        return false;
    }

    @Override
    protected boolean setProperty(String key, Object param) {
        switch (key) {
            case "display": {
                String display = WXUtils.getString(param, null);
                if (display != null) {
                    this.setDisplay(display);
                }
                return true;
            }
        }
        return super.setProperty(key, param);
    }

    @WXComponentProp(name="display")
    public void setDisplay(String display) {
        if (!TextUtils.isEmpty((CharSequence)display) && display.equals(HIDE) && (this.getParent() instanceof WXListComponent || this.getParent() instanceof WXScroller) && ((BaseBounceView)((Object)this.getParent().getHostView())).getSwipeLayout().isRefreshing()) {
            ((BaseBounceView)((Object)this.getParent().getHostView())).finishPullLoad();
            ((BaseBounceView)((Object)this.getParent().getHostView())).onLoadmoreComplete();
        }
    }
}

