/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import android.annotation.SuppressLint;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.taobao.weappplus_sdk.R;
import com.taobao.weex.IWXRenderListener;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.annotation.Component;
import com.taobao.weex.common.WXRenderStrategy;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.ui.component.NestedContainer;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXDiv;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.view.WXFrameLayout;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;

@Component(lazyload=false)
public class WXEmbed
extends WXDiv
implements WXSDKInstance.OnInstanceVisibleListener,
NestedContainer {
    public static final String ITEM_ID = "itemId";
    private String src;
    private WXSDKInstance mNestedInstance;
    private static int ERROR_IMG_WIDTH = (int)WXViewUtils.getRealPxByWidth(270.0f, 750);
    private static int ERROR_IMG_HEIGHT = (int)WXViewUtils.getRealPxByWidth(260.0f, 750);
    private boolean mIsVisible = true;
    private EmbedRenderListener mListener = new EmbedRenderListener(this);
    private String originUrl;

    @Deprecated
    public WXEmbed(WXSDKInstance instance, WXDomObject dom, WXVContainer parent, String instanceId, boolean isLazy) {
        this(instance, dom, parent);
    }

    public WXEmbed(WXSDKInstance instance, WXDomObject node, WXVContainer parent) {
        super(instance, node, parent);
        Object itemId;
        ERROR_IMG_WIDTH = (int)WXViewUtils.getRealPxByWidth(270.0f, instance.getInstanceViewPortWidth());
        ERROR_IMG_HEIGHT = (int)WXViewUtils.getRealPxByWidth(260.0f, instance.getInstanceViewPortWidth());
        if (instance instanceof EmbedManager && (itemId = node.getAttrs().get(ITEM_ID)) != null) {
            ((EmbedManager)((Object)instance)).putEmbed(itemId.toString(), this);
        }
    }

    @Override
    public void setOnNestEventListener(NestedContainer.OnNestedInstanceEventListener listener) {
        this.mListener.mEventListener = listener;
    }

    @Override
    public ViewGroup getViewContainer() {
        return (ViewGroup)this.getHostView();
    }

    @Override
    protected boolean setProperty(String key, Object param) {
        switch (key) {
            case "src": {
                String src = WXUtils.getString(param, null);
                if (src != null) {
                    this.setSrc(src);
                }
                return true;
            }
        }
        return super.setProperty(key, param);
    }

    @Override
    public void renderNewURL(String url) {
        this.src = url;
        this.loadContent();
    }

    public String getOriginUrl() {
        return this.originUrl;
    }

    public void setOriginUrl(String originUrl) {
        this.originUrl = originUrl;
    }

    @WXComponentProp(name="src")
    public void setSrc(String src) {
        this.originUrl = src;
        this.src = src;
        if (this.mNestedInstance != null) {
            this.mNestedInstance.destroy();
            this.mNestedInstance = null;
        }
        if (this.mIsVisible) {
            this.loadContent();
        }
    }

    public String getSrc() {
        return this.src;
    }

    protected void loadContent() {
        this.mNestedInstance = this.createInstance();
        if (this.mListener != null && this.mListener.mEventListener != null && !this.mListener.mEventListener.onPreCreate(this, this.src)) {
            this.mListener.mEventListener.onCreated(this, this.mNestedInstance);
        }
    }

    private WXSDKInstance createInstance() {
        WXSDKInstance sdkInstance = this.getInstance().createNestedInstance(this);
        this.getInstance().addOnInstanceVisibleListener(this);
        sdkInstance.registerRenderListener(this.mListener);
        String url = this.src;
        if (this.mListener != null && this.mListener.mEventListener != null) {
            url = this.mListener.mEventListener.transformUrl(this.src);
            if (!this.mListener.mEventListener.onPreCreate(this, this.src)) {
                return null;
            }
        }
        if (TextUtils.isEmpty((CharSequence)url)) {
            this.mListener.mEventListener.onException(this, "wx_user_intercept_error", "degradeToH5");
            return sdkInstance;
        }
        ViewGroup.LayoutParams layoutParams = ((WXFrameLayout)this.getHostView()).getLayoutParams();
        sdkInstance.renderByUrl("default", url, null, null, layoutParams.width, layoutParams.height, WXRenderStrategy.APPEND_ASYNC);
        return sdkInstance;
    }

    @Override
    public void setVisibility(String visibility) {
        super.setVisibility(visibility);
        boolean visible = TextUtils.equals((CharSequence)visibility, (CharSequence)"visible");
        if (!TextUtils.isEmpty((CharSequence)this.src) && visible) {
            if (this.mNestedInstance == null) {
                this.loadContent();
            } else {
                this.mNestedInstance.onViewAppear();
            }
        }
        if (!visible && this.mNestedInstance != null) {
            this.mNestedInstance.onViewDisappear();
        }
        this.mIsVisible = visible;
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.mNestedInstance != null) {
            this.mNestedInstance.destroy();
            this.mNestedInstance = null;
        }
        this.src = null;
        if (this.getInstance() != null) {
            this.getInstance().removeOnInstanceVisibleListener(this);
        }
    }

    @Override
    public void onAppear() {
        WXComponent comp;
        if (this.mIsVisible && this.mNestedInstance != null && (comp = this.mNestedInstance.getRootComponent()) != null) {
            comp.fireEvent("viewappear");
        }
    }

    @Override
    public void onDisappear() {
        WXComponent comp;
        if (this.mIsVisible && this.mNestedInstance != null && (comp = this.mNestedInstance.getRootComponent()) != null) {
            comp.fireEvent("viewdisappear");
        }
    }

    static class EmbedRenderListener
    implements IWXRenderListener {
        WXEmbed mComponent;
        NestedContainer.OnNestedInstanceEventListener mEventListener;

        EmbedRenderListener(WXEmbed comp) {
            this.mComponent = comp;
            this.mEventListener = new ClickToReloadListener();
        }

        @Override
        public void onViewCreated(WXSDKInstance instance, View view) {
            FrameLayout hostView = (FrameLayout)this.mComponent.getHostView();
            hostView.removeAllViews();
            hostView.addView(view);
        }

        @Override
        public void onRenderSuccess(WXSDKInstance instance, int width, int height) {
        }

        @Override
        public void onRefreshSuccess(WXSDKInstance instance, int width, int height) {
        }

        @Override
        public void onException(WXSDKInstance instance, String errCode, String msg) {
            if (this.mEventListener != null) {
                this.mEventListener.onException(this.mComponent, errCode, msg);
            }
        }
    }

    public static class ClickToReloadListener
    implements NestedContainer.OnNestedInstanceEventListener {
        @Override
        public void onException(NestedContainer container, String errCode, String msg) {
            if (TextUtils.equals((CharSequence)errCode, (CharSequence)"wx_network_error") && container instanceof WXEmbed) {
                final WXEmbed comp = (WXEmbed)container;
                final ImageView imageView = new ImageView(comp.getContext());
                imageView.setImageResource(R.drawable.error);
                FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(ERROR_IMG_WIDTH, ERROR_IMG_HEIGHT);
                layoutParams.gravity = 17;
                imageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                imageView.setScaleType(ImageView.ScaleType.FIT_XY);
                imageView.setAdjustViewBounds(true);
                imageView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        imageView.setOnClickListener(null);
                        imageView.setEnabled(false);
                        comp.loadContent();
                    }
                });
                FrameLayout hostView = (FrameLayout)comp.getHostView();
                hostView.removeAllViews();
                hostView.addView((View)imageView);
                WXLogUtils.e("WXEmbed", "NetWork failure :" + errCode + ",\n error message :" + msg);
            }
        }

        @Override
        public boolean onPreCreate(NestedContainer comp, String src) {
            return true;
        }

        @Override
        public String transformUrl(String origin) {
            return origin;
        }

        @Override
        public void onCreated(NestedContainer comp, WXSDKInstance nestedInstance) {
        }
    }

    public static class FailToH5Listener
    extends ClickToReloadListener {
        @Override
        @SuppressLint(value={"SetJavaScriptEnabled"})
        public void onException(NestedContainer comp, String errCode, String msg) {
            if (errCode != null && comp instanceof WXEmbed && errCode.startsWith("1|")) {
                ViewGroup container = comp.getViewContainer();
                WebView webView = new WebView(container.getContext());
                ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, -1);
                webView.setLayoutParams(params);
                webView.getSettings().setJavaScriptEnabled(true);
                webView.removeJavascriptInterface("searchBoxJavaBridge_");
                webView.removeJavascriptInterface("accessibility");
                webView.removeJavascriptInterface("accessibilityTraversal");
                webView.getSettings().setSavePassword(false);
                container.removeAllViews();
                container.addView((View)webView);
                webView.loadUrl(((WXEmbed)comp).src);
            } else {
                super.onException(comp, errCode, msg);
            }
        }
    }

    public static interface EmbedManager {
        public WXEmbed getEmbed(String var1);

        public void putEmbed(String var1, WXEmbed var2);
    }
}

