/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.dom;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.text.Layout;
import android.text.TextUtils;
import com.taobao.weex.dom.CSSAlignConvert;
import com.taobao.weex.dom.CSSFlexDirectionConvert;
import com.taobao.weex.dom.CSSJustifyConvert;
import com.taobao.weex.dom.CSSPositionTypeConvert;
import com.taobao.weex.dom.CSSWrapConvert;
import com.taobao.weex.dom.flex.CSSAlign;
import com.taobao.weex.dom.flex.CSSFlexDirection;
import com.taobao.weex.dom.flex.CSSJustify;
import com.taobao.weex.dom.flex.CSSPositionType;
import com.taobao.weex.dom.flex.CSSWrap;
import com.taobao.weex.ui.component.WXTextDecoration;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class WXStyle
implements Map<String, Object>,
Cloneable {
    private static final long serialVersionUID = 611132641365274134L;
    public static final int UNSET = -1;
    @NonNull
    private final Map<String, Object> mStyles;
    private Map<String, Map<String, Object>> mPesudoStyleMap = new ArrayMap();
    private Map<String, Object> mPesudoResetStyleMap = new ArrayMap();

    public WXStyle() {
        this.mStyles = new ArrayMap();
    }

    @Nullable
    public String getBlur() {
        if (this.get("filter") == null) {
            return null;
        }
        return this.get("filter").toString().trim();
    }

    public static WXTextDecoration getTextDecoration(Map<String, Object> style) {
        Object obj = style.get("textDecoration");
        if (obj == null) {
            return WXTextDecoration.NONE;
        }
        String textDecoration = obj.toString();
        if (textDecoration.equals("underline")) {
            return WXTextDecoration.UNDERLINE;
        }
        if (textDecoration.equals("line-through")) {
            return WXTextDecoration.LINETHROUGH;
        }
        return WXTextDecoration.NONE;
    }

    public static String getTextColor(Map<String, Object> style) {
        if (style == null) {
            return "";
        }
        Object temp = style.get("color");
        return temp == null ? "" : temp.toString();
    }

    public static int getFontWeight(Map<String, Object> style) {
        Object temp;
        int typeface = 0;
        if (style != null && (temp = style.get("fontWeight")) != null) {
            String fontWeight;
            switch (fontWeight = temp.toString()) {
                case "600": 
                case "700": 
                case "800": 
                case "900": 
                case "bold": {
                    typeface = 1;
                }
            }
        }
        return typeface;
    }

    public static int getFontStyle(Map<String, Object> style) {
        int typeface = 0;
        if (style == null) {
            return typeface;
        }
        Object temp = style.get("fontStyle");
        if (temp == null) {
            return typeface;
        }
        String fontWeight = temp.toString();
        if (fontWeight.equals("italic")) {
            typeface = 2;
        }
        return typeface;
    }

    public static int getFontSize(Map<String, Object> style, int viewPortW) {
        if (style == null) {
            return (int)WXViewUtils.getRealPxByWidth(32.0f, viewPortW);
        }
        int fontSize = WXUtils.getInt(style.get("fontSize"));
        if (fontSize <= 0) {
            fontSize = 32;
        }
        return (int)WXViewUtils.getRealPxByWidth(fontSize, viewPortW);
    }

    public static String getFontFamily(Map<String, Object> style) {
        Object temp;
        String fontFamily = null;
        if (style != null && (temp = style.get("fontFamily")) != null) {
            fontFamily = temp.toString();
        }
        return fontFamily;
    }

    public static Layout.Alignment getTextAlignment(Map<String, Object> style) {
        Layout.Alignment alignment = Layout.Alignment.ALIGN_NORMAL;
        String textAlign = (String)style.get("textAlign");
        if (TextUtils.equals((CharSequence)"left", (CharSequence)textAlign)) {
            alignment = Layout.Alignment.ALIGN_NORMAL;
        } else if (TextUtils.equals((CharSequence)"center", (CharSequence)textAlign)) {
            alignment = Layout.Alignment.ALIGN_CENTER;
        } else if (TextUtils.equals((CharSequence)"right", (CharSequence)textAlign)) {
            alignment = Layout.Alignment.ALIGN_OPPOSITE;
        }
        return alignment;
    }

    public static TextUtils.TruncateAt getTextOverflow(Map<String, Object> style) {
        TextUtils.TruncateAt truncateAt = null;
        String ellipse = (String)style.get("textOverflow");
        if (TextUtils.equals((CharSequence)"ellipsis", (CharSequence)ellipse)) {
            truncateAt = TextUtils.TruncateAt.END;
        }
        return truncateAt;
    }

    public static int getLines(Map<String, Object> style) {
        return WXUtils.getInt(style.get("lines"));
    }

    public static int getLineHeight(Map<String, Object> style, int viewPortW) {
        if (style == null) {
            return -1;
        }
        int lineHeight = WXUtils.getInt(style.get("lineHeight"));
        if (lineHeight <= 0) {
            lineHeight = -1;
            return lineHeight;
        }
        return (int)WXViewUtils.getRealPxByWidth(lineHeight, viewPortW);
    }

    public CSSAlign getAlignItems() {
        Object alignItems = this.get("alignItems");
        if (alignItems == null) {
            return CSSAlign.STRETCH;
        }
        return CSSAlignConvert.convert2AlignItems(alignItems.toString().trim());
    }

    public CSSAlign getAlignSelf() {
        Object alignSelf = this.get("alignSelf");
        if (alignSelf == null) {
            return CSSAlign.AUTO;
        }
        return CSSAlignConvert.convert2AlignSelf(alignSelf.toString().trim());
    }

    public float getFlex() {
        return WXUtils.getFloat(this.get("flex"));
    }

    public CSSFlexDirection getFlexDirection() {
        Object flexDirection = this.get("flexDirection");
        if (flexDirection == null) {
            return CSSFlexDirection.COLUMN;
        }
        return CSSFlexDirectionConvert.convert(flexDirection.toString().trim());
    }

    public CSSJustify getJustifyContent() {
        Object justifyContent = this.get("justifyContent");
        if (justifyContent == null) {
            return CSSJustify.FLEX_START;
        }
        return CSSJustifyConvert.convert(justifyContent.toString().trim());
    }

    public CSSWrap getCSSWrap() {
        Object cssWrap = this.get("flexWrap");
        if (cssWrap == null) {
            return CSSWrap.NOWRAP;
        }
        return CSSWrapConvert.convert(cssWrap.toString().trim());
    }

    public float getWidth() {
        return WXUtils.getFloat(this.get("width"));
    }

    public float getDefaultWidth() {
        return WXUtils.getFloat(this.get("defaultWidth"));
    }

    public float getMinWidth() {
        return WXUtils.getFloat(this.get("minWidth"));
    }

    public float getMaxWidth() {
        return WXUtils.getFloat(this.get("maxWidth"));
    }

    public float getHeight() {
        return WXUtils.getFloat(this.get("height"));
    }

    public float getDefaultHeight() {
        return WXUtils.getFloat(this.get("defaultHeight"));
    }

    public float getMinHeight() {
        return WXUtils.getFloat(this.get("minHeight"));
    }

    public float getMaxHeight() {
        return WXUtils.getFloat(this.get("maxHeight"));
    }

    public float getBorderRadius() {
        float temp = WXUtils.getFloat(this.get("borderRadius"));
        if (WXUtils.isUndefined(temp)) {
            return Float.NaN;
        }
        return temp;
    }

    public float getBorderTopWidth() {
        return this.getBorderWidth("borderTopWidth");
    }

    private float getBorderWidth(String key) {
        float temp = WXUtils.getFloat(this.get(key));
        if (WXUtils.isUndefined(temp)) {
            return this.getBorderWidth();
        }
        return temp;
    }

    public float getBorderWidth() {
        return WXUtils.getFloat(this.get("borderWidth"));
    }

    public float getBorderRightWidth() {
        return this.getBorderWidth("borderRightWidth");
    }

    public float getBorderBottomWidth() {
        return this.getBorderWidth("borderBottomWidth");
    }

    public float getBorderLeftWidth() {
        return this.getBorderWidth("borderLeftWidth");
    }

    public String getBorderColor() {
        Object color = this.get("borderColor");
        return color == null ? null : color.toString();
    }

    public String getBorderStyle() {
        Object borderStyle = this.get("borderStyle");
        return borderStyle == null ? null : borderStyle.toString();
    }

    public float getMargin() {
        return WXUtils.getFloat(this.get("margin"));
    }

    public float getPadding() {
        return WXUtils.getFloat(this.get("padding"));
    }

    public float getMarginTop() {
        float temp = WXUtils.getFloat(this.get("marginTop"));
        if (WXUtils.isUndefined(temp)) {
            temp = WXUtils.getFloat(this.get("margin"));
        }
        return temp;
    }

    public float getMarginLeft() {
        float temp = WXUtils.getFloat(this.get("marginLeft"));
        if (WXUtils.isUndefined(temp)) {
            temp = WXUtils.getFloat(this.get("margin"));
        }
        return temp;
    }

    public float getMarginRight() {
        float temp = WXUtils.getFloat(this.get("marginRight"));
        if (WXUtils.isUndefined(temp)) {
            temp = WXUtils.getFloat(this.get("margin"));
        }
        return temp;
    }

    public float getMarginBottom() {
        float temp = WXUtils.getFloat(this.get("marginBottom"));
        if (WXUtils.isUndefined(temp)) {
            temp = WXUtils.getFloat(this.get("margin"));
        }
        return temp;
    }

    public float getPaddingTop() {
        float temp = WXUtils.getFloat(this.get("paddingTop"));
        if (WXUtils.isUndefined(temp)) {
            temp = WXUtils.getFloat(this.get("padding"));
        }
        return temp;
    }

    public float getPaddingLeft() {
        float temp = WXUtils.getFloat(this.get("paddingLeft"));
        if (WXUtils.isUndefined(temp)) {
            temp = WXUtils.getFloat(this.get("padding"));
        }
        return temp;
    }

    public float getPaddingRight() {
        float temp = WXUtils.getFloat(this.get("paddingRight"));
        if (WXUtils.isUndefined(temp)) {
            temp = WXUtils.getFloat(this.get("padding"));
        }
        return temp;
    }

    public float getPaddingBottom() {
        float temp = WXUtils.getFloat(this.get("paddingBottom"));
        if (WXUtils.isUndefined(temp)) {
            temp = WXUtils.getFloat(this.get("padding"));
        }
        return temp;
    }

    public CSSPositionType getPosition() {
        Object position = this.get("position");
        if (position == null) {
            return CSSPositionType.RELATIVE;
        }
        return CSSPositionTypeConvert.convert(position.toString().trim());
    }

    public boolean isSticky() {
        Object position = this.get("position");
        if (position == null) {
            return false;
        }
        return position.toString().equals("sticky");
    }

    public boolean isFixed() {
        Object position = this.get("position");
        if (position == null) {
            return false;
        }
        return position.toString().equals("fixed");
    }

    public float getLeft() {
        return WXUtils.getFloat(this.get("left"));
    }

    public float getTop() {
        return WXUtils.getFloat(this.get("top"));
    }

    public float getRight() {
        return WXUtils.getFloat(this.get("right"));
    }

    public float getBottom() {
        return WXUtils.getFloat(this.get("bottom"));
    }

    public String getBackgroundColor() {
        Object temp = this.get("backgroundColor");
        return temp == null ? "" : temp.toString();
    }

    public int getTimeFontSize() {
        int fontSize = WXUtils.getInt(this.get("timeFontSize"));
        if (fontSize <= 0) {
            fontSize = 32;
        }
        return fontSize;
    }

    public float getOpacity() {
        Object object = this.get("opacity");
        float opacity = 1.0f;
        if (object == null) {
            return opacity;
        }
        return WXUtils.getFloat(object);
    }

    public String getOverflow() {
        Object obj = this.get("overflow");
        return obj == null ? "visible" : obj.toString();
    }

    @Override
    public boolean equals(Object o) {
        return this.mStyles.equals(o);
    }

    @Override
    public int hashCode() {
        return this.mStyles.hashCode();
    }

    @Override
    public void clear() {
        this.mStyles.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.mStyles.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.mStyles.containsValue(value);
    }

    @Override
    @NonNull
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.mStyles.entrySet();
    }

    @Override
    public Object get(Object key) {
        return this.mStyles.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.mStyles.isEmpty();
    }

    @Override
    @NonNull
    public Set<String> keySet() {
        return this.mStyles.keySet();
    }

    @Override
    public Object put(String key, Object value) {
        return this.mStyles.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ?> map) {
        this.mStyles.putAll(map);
    }

    public void putAll(Map<? extends String, ?> map, boolean byPesudo) {
        this.mStyles.putAll(map);
        if (!byPesudo) {
            this.mPesudoResetStyleMap.putAll(map);
            this.processPesudoClasses(map);
        }
    }

    public Map<String, Object> getPesudoResetStyles() {
        return this.mPesudoResetStyleMap;
    }

    public Map<String, Map<String, Object>> getPesudoStyles() {
        return this.mPesudoStyleMap;
    }

    <T extends String, V> void processPesudoClasses(Map<T, V> styles) {
        Iterator<Map.Entry<T, V>> iterator = styles.entrySet().iterator();
        Map<String, Map<String, Object>> pesudoStyleMap = this.mPesudoStyleMap;
        while (iterator.hasNext()) {
            Map.Entry<T, V> entry = iterator.next();
            String key = (String)entry.getKey();
            int i = key.indexOf(":");
            if (i <= 0) continue;
            String clzName = key.substring(i);
            if (clzName.equals(":enabled")) {
                String styleKey = key.substring(0, i);
                this.mStyles.put(styleKey, entry.getValue());
                this.mPesudoResetStyleMap.put(styleKey, entry.getValue());
                continue;
            }
            ArrayMap stylesMap = pesudoStyleMap.get(clzName = clzName.replace(":enabled", ""));
            if (stylesMap == null) {
                stylesMap = new ArrayMap();
                pesudoStyleMap.put(clzName, (Map<String, Object>)stylesMap);
            }
            stylesMap.put(key.substring(0, i), entry.getValue());
        }
    }

    @Override
    public Object remove(Object key) {
        return this.mStyles.remove(key);
    }

    @Override
    public int size() {
        return this.mStyles.size();
    }

    @Override
    @NonNull
    public Collection<Object> values() {
        return this.mStyles.values();
    }

    protected WXStyle clone() {
        WXStyle style = new WXStyle();
        style.mStyles.putAll(this.mStyles);
        for (Map.Entry<String, Map<String, Object>> entry : this.mPesudoStyleMap.entrySet()) {
            ArrayMap valueClone = new ArrayMap();
            valueClone.putAll(entry.getValue());
            style.mPesudoStyleMap.put(entry.getKey(), (Map<String, Object>)valueClone);
        }
        style.mPesudoResetStyleMap.putAll(this.mPesudoResetStyleMap);
        return style;
    }
}

