/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.dom;

import com.taobao.weex.WXEnvironment;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.util.Map;

public class WXRecyclerDomObject
extends WXDomObject {
    private int mColumnCount = 1;
    private float mColumnWidth = -1.0f;
    private float mColumnGap = 32.0f;
    private boolean mIsPreCalculateCellWidth = false;

    public int getLayoutType() {
        return this.getAttrs().getLayoutType();
    }

    public float getColumnGap() {
        return WXViewUtils.getRealPxByWidth(this.mColumnGap, this.getViewPortWidth());
    }

    public int getColumnCount() {
        return this.mColumnCount;
    }

    public float getColumnWidth() {
        return WXViewUtils.getRealPxByWidth(this.mColumnWidth, this.getViewPortWidth());
    }

    @Override
    public void add(WXDomObject child, int index) {
        super.add(child, index);
        if ("cell".equals(child.getType())) {
            if (!this.mIsPreCalculateCellWidth) {
                this.preCalculateCellWidth();
            }
            child.getStyles().put("width", (Object)Float.valueOf(this.mColumnWidth));
        }
    }

    public void preCalculateCellWidth() {
        if (this.getAttrs() != null) {
            this.mColumnCount = this.getAttrs().getColumnCount();
            this.mColumnWidth = this.getAttrs().getColumnWidth();
            this.mColumnGap = this.getAttrs().getColumnGap();
            float availableWidth = this.getStyleWidth() - this.getPadding().get(0) - this.getPadding().get(2);
            availableWidth = WXViewUtils.getWebPxByWidth(availableWidth, this.getViewPortWidth());
            if (-1 == this.mColumnCount && -1.0f == this.mColumnWidth) {
                this.mColumnCount = 1;
            } else if (-1.0f == this.mColumnWidth && -1 != this.mColumnCount) {
                this.mColumnWidth = (availableWidth - (float)(this.mColumnCount - 1) * this.mColumnGap) / (float)this.mColumnCount;
                this.mColumnWidth = this.mColumnWidth > 0.0f ? this.mColumnWidth : 0.0f;
            } else if (-1.0f != this.mColumnWidth && -1 == this.mColumnCount) {
                this.mColumnCount = Math.round((availableWidth + this.mColumnGap) / (this.mColumnWidth + this.mColumnGap) - 0.5f);
                this.mColumnCount = this.mColumnCount > 0 ? this.mColumnCount : 1;
                this.mColumnWidth = (availableWidth + this.mColumnGap) / (float)this.mColumnCount - this.mColumnGap;
            } else if (-1.0f != this.mColumnWidth && -1 != this.mColumnCount) {
                int columnCount = Math.round((availableWidth + this.mColumnGap) / (this.mColumnWidth + this.mColumnGap) - 0.5f);
                this.mColumnCount = columnCount > this.mColumnCount ? this.mColumnCount : columnCount;
                this.mColumnWidth = (availableWidth + this.mColumnGap) / (float)this.mColumnCount - this.mColumnGap;
            }
            this.mIsPreCalculateCellWidth = true;
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.d("preCalculateCellWidth mColumnGap :" + this.mColumnGap + " mColumnWidth:" + this.mColumnWidth + " mColumnCount:" + this.mColumnCount);
            }
        }
    }

    public void updateRecyclerAttr() {
        this.preCalculateCellWidth();
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            WXDomObject domObject = this.getChild(i);
            if (!"cell".equals(domObject.getType())) continue;
            this.getChild(i).getStyles().put("width", (Object)Float.valueOf(this.mColumnWidth));
        }
    }

    @Override
    public void updateAttr(Map<String, Object> attrs) {
        super.updateAttr(attrs);
        if (attrs.containsKey("columnCount") || attrs.containsKey("columnGap") || attrs.containsKey("columnWidth")) {
            this.updateRecyclerAttr();
        }
    }

    @Override
    public void updateStyle(Map<String, Object> styles, boolean byPesudo) {
        super.updateStyle(styles, byPesudo);
        if (styles.containsKey("padding") || styles.containsKey("paddingLeft") || styles.containsKey("paddingRight")) {
            this.preCalculateCellWidth();
        }
    }
}

