/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.bridge;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.adapter.IWXJSExceptionAdapter;
import com.taobao.weex.adapter.IWXUserTrackAdapter;
import com.taobao.weex.bridge.WXBridge;
import com.taobao.weex.bridge.WXHashMap;
import com.taobao.weex.bridge.WXJSObject;
import com.taobao.weex.bridge.WXModuleManager;
import com.taobao.weex.bridge.WXParams;
import com.taobao.weex.bridge.WXServiceManager;
import com.taobao.weex.bridge.WXValidateProcessor;
import com.taobao.weex.common.IWXBridge;
import com.taobao.weex.common.IWXDebugProxy;
import com.taobao.weex.common.WXErrorCode;
import com.taobao.weex.common.WXException;
import com.taobao.weex.common.WXJSExceptionInfo;
import com.taobao.weex.common.WXPerformance;
import com.taobao.weex.common.WXRefreshData;
import com.taobao.weex.common.WXRuntimeException;
import com.taobao.weex.common.WXThread;
import com.taobao.weex.dom.WXDomModule;
import com.taobao.weex.utils.WXFileUtils;
import com.taobao.weex.utils.WXJsonUtils;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;
import com.taobao.weex.utils.batch.BactchExecutor;
import com.taobao.weex.utils.batch.Interceptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class WXBridgeManager
implements Handler.Callback,
BactchExecutor {
    public static final String METHOD_CREATE_INSTANCE = "createInstance";
    public static final String METHOD_DESTROY_INSTANCE = "destroyInstance";
    public static final String METHOD_CALL_JS = "callJS";
    public static final String METHOD_SET_TIMEOUT = "setTimeoutCallback";
    public static final String METHOD_REGISTER_MODULES = "registerModules";
    public static final String METHOD_REGISTER_COMPONENTS = "registerComponents";
    public static final String METHOD_FIRE_EVENT = "fireEvent";
    public static final String METHOD_CALLBACK = "callback";
    public static final String METHOD_REFRESH_INSTANCE = "refreshInstance";
    public static final String METHOD_NOTIFY_TRIM_MEMORY = "notifyTrimMemory";
    public static final String KEY_METHOD = "method";
    public static final String KEY_ARGS = "args";
    public static final String COMPONENT = "component";
    public static final String REF = "ref";
    public static final String MODULE = "module";
    public static final String METHOD = "method";
    public static final String ARGS = "args";
    private static final String NON_CALLBACK = "-1";
    private static final String UNDEFINED = "undefined";
    private static final int INIT_FRAMEWORK_OK = 1;
    private static long LOW_MEM_VALUE = 80L;
    static volatile WXBridgeManager mBridgeManager;
    private WXHashMap<String, ArrayList<WXHashMap<String, Object>>> mNextTickTasks = new WXHashMap();
    private WXThread mJSThread;
    Handler mJSHandler;
    private IWXBridge mWXBridge;
    private IWXDebugProxy mWxDebugProxy;
    private boolean mMock = false;
    private boolean mInit = false;
    private List<Map<String, Object>> mRegisterComponentFailList = new ArrayList<Map<String, Object>>(8);
    private List<Map<String, Object>> mRegisterModuleFailList = new ArrayList<Map<String, Object>>(8);
    private List<String> mRegisterServiceFailList = new ArrayList<String>(8);
    private List<String> mDestroyedInstanceId = new ArrayList<String>();
    private StringBuilder mLodBuilder = new StringBuilder(50);
    private Interceptor mInterceptor;

    private boolean isJSFrameworkInit() {
        return this.mInit;
    }

    private WXBridgeManager() {
        this.initWXBridge(WXEnvironment.sRemoteDebugMode);
        this.mJSThread = new WXThread("WeexJSBridgeThread", this);
        this.mJSHandler = this.mJSThread.getHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WXBridgeManager getInstance() {
        if (mBridgeManager != null) return mBridgeManager;
        Class<WXBridgeManager> clazz = WXBridgeManager.class;
        synchronized (WXBridgeManager.class) {
            if (mBridgeManager != null) return mBridgeManager;
            mBridgeManager = new WXBridgeManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mBridgeManager;
        }
    }

    private void initWXBridge(boolean remoteDebug) {
        if (remoteDebug) {
            WXEnvironment.sDebugServerConnectable = true;
        }
        if (this.mWxDebugProxy != null) {
            this.mWxDebugProxy.stop(false);
        }
        if (WXEnvironment.sDebugServerConnectable) {
            try {
                Constructor<?> constructor;
                Class<?> clazz = Class.forName("com.taobao.weex.devtools.debug.DebugServerProxy");
                if (clazz != null && (constructor = clazz.getConstructor(Context.class, WXBridgeManager.class)) != null) {
                    this.mWxDebugProxy = (IWXDebugProxy)constructor.newInstance(WXEnvironment.getApplication(), this);
                    if (this.mWxDebugProxy != null) {
                        this.mWxDebugProxy.start();
                    }
                }
            }
            catch (ClassNotFoundException e) {
            }
            catch (NoSuchMethodException e) {
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
            WXServiceManager.execAllCacheJsService();
        }
        this.mWXBridge = remoteDebug && this.mWxDebugProxy != null ? this.mWxDebugProxy.getWXBridge() : new WXBridge();
    }

    public void stopRemoteDebug() {
        if (this.mWxDebugProxy != null) {
            this.mWxDebugProxy.stop(true);
        }
    }

    public Object callModuleMethod(String instanceId, String moduleStr, String methodStr, JSONArray args) {
        WXSDKInstance wxsdkInstance = WXSDKManager.getInstance().getSDKInstance(instanceId);
        if (wxsdkInstance.isNeedValidate() && WXSDKManager.getInstance().getValidateProcessor() != null) {
            WXValidateProcessor.WXModuleValidateResult validateResult = WXSDKManager.getInstance().getValidateProcessor().onModuleValidate(wxsdkInstance, moduleStr, methodStr, args);
            if (validateResult == null) {
                return null;
            }
            if (validateResult.isSuccess) {
                return WXModuleManager.callModuleMethod(instanceId, moduleStr, methodStr, args);
            }
            JSONObject validateInfo = validateResult.validateInfo;
            WXLogUtils.e("[WXBridgeManager] module validate fail. >>> " + validateInfo.toJSONString());
            return validateInfo;
        }
        return WXModuleManager.callModuleMethod(instanceId, moduleStr, methodStr, args);
    }

    public void restart() {
        this.mInit = false;
        this.initWXBridge(WXEnvironment.sRemoteDebugMode);
    }

    public synchronized void setStackTopInstance(final String instanceId) {
        this.post(new Runnable(){

            @Override
            public void run() {
                WXBridgeManager.this.mNextTickTasks.setStackTopInstance(instanceId);
            }
        }, instanceId);
    }

    @Override
    public void post(Runnable r) {
        if (this.mInterceptor != null && this.mInterceptor.take(r)) {
            return;
        }
        if (this.mJSHandler == null) {
            return;
        }
        this.mJSHandler.post(WXThread.secure(r));
    }

    @Override
    public void setInterceptor(Interceptor interceptor) {
        this.mInterceptor = interceptor;
    }

    public void post(Runnable r, Object token) {
        if (this.mJSHandler == null) {
            return;
        }
        Message m = Message.obtain((Handler)this.mJSHandler, (Runnable)WXThread.secure(r));
        m.obj = token;
        m.sendToTarget();
    }

    void setTimeout(String callbackId, String time) {
        Message message = Message.obtain();
        message.what = 1;
        TimerInfo timerInfo = new TimerInfo();
        timerInfo.callbackId = callbackId;
        timerInfo.time = (long)Float.parseFloat(time);
        message.obj = timerInfo;
        this.mJSHandler.sendMessageDelayed(message, timerInfo.time);
    }

    public void sendMessageDelayed(Message message, long delayMillis) {
        if (message == null || this.mJSHandler == null || this.mJSThread == null || !this.mJSThread.isWXThreadAlive() || this.mJSThread.getLooper() == null) {
            return;
        }
        this.mJSHandler.sendMessageDelayed(message, delayMillis);
    }

    public void removeMessage(int what, Object obj) {
        if (this.mJSHandler == null || this.mJSThread == null || !this.mJSThread.isWXThreadAlive() || this.mJSThread.getLooper() == null) {
            return;
        }
        this.mJSHandler.removeMessages(what, obj);
    }

    public Object callNativeModule(String instanceId, String module, String method, JSONArray arguments, Object options) {
        if (WXEnvironment.isApkDebugable()) {
            this.mLodBuilder.append("[WXBridgeManager] callNativeModule >>>> instanceId:").append(instanceId).append(", module:").append(module).append(", method:").append(method).append(", arguments:").append(arguments);
            WXLogUtils.d(this.mLodBuilder.substring(0));
            this.mLodBuilder.setLength(0);
        }
        try {
            if ("dom".equals(module)) {
                WXDomModule dom = WXModuleManager.getDomModule(instanceId);
                return dom.callDomMethod(method, arguments);
            }
            return this.callModuleMethod(instanceId, module, method, arguments);
        }
        catch (Exception e) {
            WXLogUtils.e("[WXBridgeManager] callNative exception: ", e);
            this.commitJSBridgeAlarmMonitor(instanceId, WXErrorCode.WX_ERR_INVOKE_NATIVE, "[WXBridgeManager] callNativeModule exception " + e.getCause());
            return null;
        }
    }

    public Object callNativeComponent(String instanceId, String componentRef, String method, JSONArray arguments, Object options) {
        if (WXEnvironment.isApkDebugable()) {
            this.mLodBuilder.append("[WXBridgeManager] callNativeComponent >>>> instanceId:").append(instanceId).append(", componentRef:").append(componentRef).append(", method:").append(method).append(", arguments:").append(arguments);
            WXLogUtils.d(this.mLodBuilder.substring(0));
            this.mLodBuilder.setLength(0);
        }
        try {
            WXDomModule dom = WXModuleManager.getDomModule(instanceId);
            dom.invokeMethod(componentRef, method, arguments);
        }
        catch (Exception e) {
            WXLogUtils.e("[WXBridgeManager] callNative exception: ", e);
            this.commitJSBridgeAlarmMonitor(instanceId, WXErrorCode.WX_ERR_INVOKE_NATIVE, "[WXBridgeManager] callNativeModule exception " + e.getCause());
        }
        return null;
    }

    public int callNative(String instanceId, String tasks, String callback) {
        int size;
        if (TextUtils.isEmpty((CharSequence)tasks)) {
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.e("[WXBridgeManager] callNative: call Native tasks is null");
            }
            this.commitJSBridgeAlarmMonitor(instanceId, WXErrorCode.WX_ERR_INVOKE_NATIVE, "[WXBridgeManager] callNative: call Native tasks is null");
            return 0;
        }
        if (WXEnvironment.isApkDebugable()) {
            this.mLodBuilder.append("[WXBridgeManager] callNative >>>> instanceId:").append(instanceId).append(", tasks:").append(tasks).append(", callback:").append(callback);
            WXLogUtils.d(this.mLodBuilder.substring(0));
            this.mLodBuilder.setLength(0);
        }
        if (this.mDestroyedInstanceId != null && this.mDestroyedInstanceId.contains(instanceId)) {
            return -1;
        }
        long start = System.currentTimeMillis();
        JSONArray array = JSON.parseArray((String)tasks);
        if (WXSDKManager.getInstance().getSDKInstance(instanceId) != null) {
            WXSDKManager.getInstance().getSDKInstance(instanceId).jsonParseTime(System.currentTimeMillis() - start);
        }
        if ((size = array.size()) > 0) {
            try {
                for (int i = 0; i < size; ++i) {
                    WXDomModule dom;
                    JSONObject task = (JSONObject)array.get(i);
                    if (task == null || WXSDKManager.getInstance().getSDKInstance(instanceId) == null) continue;
                    Object target = task.get((Object)MODULE);
                    if (target != null) {
                        if ("dom".equals(target)) {
                            dom = WXModuleManager.getDomModule(instanceId);
                            dom.callDomMethod(task);
                            continue;
                        }
                        this.callModuleMethod(instanceId, (String)target, (String)task.get((Object)"method"), (JSONArray)task.get((Object)"args"));
                        continue;
                    }
                    if (task.get((Object)COMPONENT) != null) {
                        dom = WXModuleManager.getDomModule(instanceId);
                        dom.invokeMethod((String)task.get((Object)REF), (String)task.get((Object)"method"), (JSONArray)task.get((Object)"args"));
                        continue;
                    }
                    throw new IllegalArgumentException("unknown callNative");
                }
            }
            catch (Exception e) {
                WXLogUtils.e("[WXBridgeManager] callNative exception: ", e);
                this.commitJSBridgeAlarmMonitor(instanceId, WXErrorCode.WX_ERR_INVOKE_NATIVE, "[WXBridgeManager] callNative exception " + e.getCause());
            }
        }
        if (UNDEFINED.equals(callback) || NON_CALLBACK.equals(callback)) {
            return 0;
        }
        this.getNextTick(instanceId, callback);
        return 1;
    }

    public int callAddElement(String instanceId, String ref, String dom, String index, String callback) {
        if (WXEnvironment.isApkDebugable()) {
            this.mLodBuilder.append("[WXBridgeManager] callNative::callAddElement >>>> instanceId:").append(instanceId).append(", ref:").append(ref).append(", dom:").append(dom).append(", callback:").append(callback);
            WXLogUtils.d(this.mLodBuilder.substring(0));
            this.mLodBuilder.setLength(0);
        }
        if (this.mDestroyedInstanceId != null && this.mDestroyedInstanceId.contains(instanceId)) {
            return -1;
        }
        if (WXSDKManager.getInstance().getSDKInstance(instanceId) != null) {
            long start = System.currentTimeMillis();
            JSONObject domObject = JSON.parseObject((String)dom);
            if (WXSDKManager.getInstance().getSDKInstance(instanceId) != null) {
                WXSDKManager.getInstance().getSDKInstance(instanceId).jsonParseTime(System.currentTimeMillis() - start);
            }
            WXDomModule domModule = WXModuleManager.getDomModule(instanceId);
            domModule.addElement(ref, domObject, Integer.parseInt(index));
        }
        if (UNDEFINED.equals(callback) || NON_CALLBACK.equals(callback)) {
            return 0;
        }
        this.getNextTick(instanceId, callback);
        return 1;
    }

    private void getNextTick(String instanceId, String callback) {
        this.addJSTask(METHOD_CALLBACK, instanceId, callback, "{}");
        this.sendMessage(instanceId, 6);
    }

    private void addJSTask(final String method, final String instanceId, final Object ... args) {
        this.post(new Runnable(){

            @Override
            public void run() {
                if (args == null || args.length == 0) {
                    return;
                }
                ArrayList<Object> argsList = new ArrayList<Object>();
                for (Object arg : args) {
                    argsList.add(arg);
                }
                WXHashMap<String, Object> task = new WXHashMap<String, Object>();
                task.put("method", method);
                task.put("args", argsList);
                if (WXBridgeManager.this.mNextTickTasks.get(instanceId) == null) {
                    ArrayList<WXHashMap<String, Object>> list = new ArrayList<WXHashMap<String, Object>>();
                    list.add(task);
                    WXBridgeManager.this.mNextTickTasks.put(instanceId, list);
                } else {
                    ((ArrayList)WXBridgeManager.this.mNextTickTasks.get(instanceId)).add(task);
                }
            }
        });
    }

    private void sendMessage(String instanceId, int what) {
        Message msg = Message.obtain((Handler)this.mJSHandler);
        msg.obj = instanceId;
        msg.what = what;
        msg.sendToTarget();
    }

    public synchronized void initScriptsFramework(String framework) {
        Message msg = this.mJSHandler.obtainMessage();
        msg.obj = framework;
        msg.what = 7;
        msg.setTarget(this.mJSHandler);
        msg.sendToTarget();
    }

    @Deprecated
    public void fireEvent(String instanceId, String ref, String type, Map<String, Object> data) {
        this.fireEvent(instanceId, ref, type, data, null);
    }

    @Deprecated
    public void fireEvent(String instanceId, String ref, String type, Map<String, Object> data, Map<String, Object> domChanges) {
        this.fireEventOnNode(instanceId, ref, type, data, domChanges);
    }

    public void fireEventOnNode(String instanceId, String ref, String type, Map<String, Object> data, Map<String, Object> domChanges) {
        if (TextUtils.isEmpty((CharSequence)instanceId) || TextUtils.isEmpty((CharSequence)ref) || TextUtils.isEmpty((CharSequence)type) || this.mJSHandler == null) {
            return;
        }
        if (!this.checkMainThread()) {
            throw new WXRuntimeException("fireEvent must be called by main thread");
        }
        this.addJSTask(METHOD_FIRE_EVENT, instanceId, ref, type, data, domChanges);
        this.sendMessage(instanceId, 6);
    }

    private boolean checkMainThread() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    @Deprecated
    public void callback(String instanceId, String callback, String data) {
        this.callback(instanceId, callback, data, false);
    }

    @Deprecated
    public void callback(String instanceId, String callback, Map<String, Object> data) {
        this.callback(instanceId, callback, data, false);
    }

    @Deprecated
    public void callback(String instanceId, String callback, Object data, boolean keepAlive) {
        this.callbackJavascript(instanceId, callback, data, keepAlive);
    }

    void callbackJavascript(String instanceId, String callback, Object data, boolean keepAlive) {
        if (TextUtils.isEmpty((CharSequence)instanceId) || TextUtils.isEmpty((CharSequence)callback) || this.mJSHandler == null) {
            return;
        }
        this.addJSTask(METHOD_CALLBACK, instanceId, callback, data, keepAlive);
        this.sendMessage(instanceId, 6);
    }

    public void refreshInstance(final String instanceId, final WXRefreshData jsonData) {
        if (TextUtils.isEmpty((CharSequence)instanceId) || jsonData == null) {
            return;
        }
        this.mJSHandler.postDelayed(WXThread.secure(new Runnable(){

            @Override
            public void run() {
                WXBridgeManager.this.invokeRefreshInstance(instanceId, jsonData);
            }
        }), 0L);
    }

    private void invokeRefreshInstance(String instanceId, WXRefreshData refreshData) {
        try {
            if (!this.isJSFrameworkInit()) {
                WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(instanceId);
                if (instance != null) {
                    instance.onRenderError("wx_create_instance_error", "createInstance failed!");
                }
                String err = "[WXBridgeManager] invokeRefreshInstance: framework.js uninitialized.";
                this.commitJSBridgeAlarmMonitor(instanceId, WXErrorCode.WX_ERR_INVOKE_NATIVE, err);
                WXLogUtils.e(err);
                return;
            }
            long start = System.currentTimeMillis();
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.d("refreshInstance >>>> instanceId:" + instanceId + ", data:" + refreshData.data + ", isDirty:" + refreshData.isDirty);
            }
            if (refreshData.isDirty) {
                return;
            }
            WXJSObject instanceIdObj = new WXJSObject(2, instanceId);
            WXJSObject dataObj = new WXJSObject(3, refreshData.data == null ? "{}" : refreshData.data);
            WXJSObject[] args = new WXJSObject[]{instanceIdObj, dataObj};
            this.invokeExecJS(instanceId, null, METHOD_REFRESH_INSTANCE, args);
            WXLogUtils.renderPerformanceLog("invokeRefreshInstance", System.currentTimeMillis() - start);
        }
        catch (Throwable e) {
            String err = "[WXBridgeManager] invokeRefreshInstance " + e.getCause();
            this.commitJSBridgeAlarmMonitor(instanceId, WXErrorCode.WX_ERR_INVOKE_NATIVE, err);
            WXLogUtils.e(err);
        }
    }

    public void commitJSBridgeAlarmMonitor(String instanceId, WXErrorCode errCode, String errMsg) {
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(instanceId);
        IWXUserTrackAdapter adapter = WXSDKManager.getInstance().getIWXUserTrackAdapter();
        if (instance == null || adapter == null || errCode == null) {
            return;
        }
        WXPerformance performance = new WXPerformance();
        performance.args = instance.getBundleUrl();
        performance.errCode = errCode.getErrorCode();
        if (errCode != WXErrorCode.WX_SUCCESS) {
            performance.appendErrMsg(TextUtils.isEmpty((CharSequence)errMsg) ? errCode.getErrorMsg() : errMsg);
            WXLogUtils.e("wx_monitor", performance.toString());
        }
        adapter.commit((Context)WXEnvironment.getApplication(), null, "jsBridge", performance, instance.getUserTrackParams());
    }

    public void commitJSFrameworkAlarmMonitor(String type, WXErrorCode errorCode, String errMsg) {
        IWXUserTrackAdapter userTrackAdapter = WXSDKManager.getInstance().getIWXUserTrackAdapter();
        if (userTrackAdapter == null || TextUtils.isEmpty((CharSequence)type) || errorCode == null) {
            return;
        }
        WXPerformance performance = new WXPerformance();
        performance.errCode = errorCode.getErrorCode();
        if (errorCode != WXErrorCode.WX_SUCCESS) {
            performance.appendErrMsg(TextUtils.isEmpty((CharSequence)errMsg) ? errorCode.getErrorMsg() : errMsg);
            WXLogUtils.e("wx_monitor", performance.toString());
        }
        userTrackAdapter.commit((Context)WXEnvironment.getApplication(), null, type, performance, null);
    }

    public void createInstance(String instanceId, final String template, final Map<String, Object> options, final String data) {
        final WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(instanceId);
        if (instance == null) {
            WXLogUtils.e("WXBridgeManager", "createInstance failed, SDKInstance is not exist");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)instanceId) || TextUtils.isEmpty((CharSequence)template) || this.mJSHandler == null) {
            instance.onRenderError("wx_create_instance_error", "createInstance fail!");
            return;
        }
        WXModuleManager.createDomModule(instance);
        this.post(new Runnable(){

            @Override
            public void run() {
                long start = System.currentTimeMillis();
                WXBridgeManager.this.invokeCreateInstance(instance, template, options, data);
                final long totalTime = System.currentTimeMillis() - start;
                WXSDKManager.getInstance().postOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        instance.createInstanceFinished(totalTime);
                    }
                }, 0L);
            }
        }, instanceId);
    }

    private void invokeCreateInstance(@NonNull WXSDKInstance instance, String template, Map<String, Object> options, String data) {
        this.initFramework("");
        if (this.mMock) {
            this.mock(instance.getInstanceId());
        } else {
            if (!this.isJSFrameworkInit()) {
                instance.onRenderError("wx_create_instance_error", "createInstance fail!");
                String err = "[WXBridgeManager] invokeCreateInstance: framework.js uninitialized.";
                this.commitJSBridgeAlarmMonitor(instance.getInstanceId(), WXErrorCode.WX_ERR_INVOKE_NATIVE, err);
                WXLogUtils.e(err);
                return;
            }
            try {
                if (WXEnvironment.isApkDebugable()) {
                    WXLogUtils.d("createInstance >>>> instanceId:" + instance.getInstanceId() + ", options:" + WXJsonUtils.fromObjectToJSONString(options) + ", data:" + data);
                }
                WXJSObject instanceIdObj = new WXJSObject(2, instance.getInstanceId());
                WXJSObject instanceObj = new WXJSObject(2, template);
                WXJSObject optionsObj = new WXJSObject(3, options == null ? "{}" : WXJsonUtils.fromObjectToJSONString(options));
                WXJSObject dataObj = new WXJSObject(3, data == null ? "{}" : data);
                WXJSObject[] args = new WXJSObject[]{instanceIdObj, instanceObj, optionsObj, dataObj};
                this.invokeExecJS(instance.getInstanceId(), null, METHOD_CREATE_INSTANCE, args, false);
            }
            catch (Throwable e) {
                instance.onRenderError("wx_create_instance_error", "createInstance failed!");
                String err = "[WXBridgeManager] invokeCreateInstance " + e.getCause();
                this.commitJSBridgeAlarmMonitor(instance.getInstanceId(), WXErrorCode.WX_ERR_INVOKE_NATIVE, err);
                WXLogUtils.e(err);
            }
        }
    }

    private void mock(String instanceId) {
    }

    public void destroyInstance(final String instanceId) {
        if (this.mJSHandler == null || TextUtils.isEmpty((CharSequence)instanceId)) {
            return;
        }
        if (this.mDestroyedInstanceId != null) {
            this.mDestroyedInstanceId.add(instanceId);
        }
        this.mJSHandler.removeCallbacksAndMessages((Object)instanceId);
        this.post(new Runnable(){

            @Override
            public void run() {
                WXBridgeManager.this.removeTaskByInstance(instanceId);
                WXBridgeManager.this.invokeDestroyInstance(instanceId);
            }
        }, instanceId);
    }

    private void removeTaskByInstance(String instanceId) {
        this.mNextTickTasks.removeFromMapAndStack(instanceId);
    }

    private void invokeDestroyInstance(String instanceId) {
        try {
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.d("destroyInstance >>>> instanceId:" + instanceId);
            }
            WXJSObject instanceIdObj = new WXJSObject(2, instanceId);
            WXJSObject[] args = new WXJSObject[]{instanceIdObj};
            this.invokeExecJS(instanceId, null, METHOD_DESTROY_INSTANCE, args);
        }
        catch (Throwable e) {
            String err = "[WXBridgeManager] invokeDestroyInstance " + e.getCause();
            this.commitJSBridgeAlarmMonitor(instanceId, WXErrorCode.WX_ERR_INVOKE_NATIVE, err);
            WXLogUtils.e(err);
        }
    }

    public boolean handleMessage(Message msg) {
        if (msg == null) {
            return false;
        }
        int what = msg.what;
        switch (what) {
            case 7: {
                this.invokeInitFramework(msg);
                break;
            }
            case 6: {
                this.invokeCallJSBatch(msg);
                break;
            }
            case 1: {
                TimerInfo timerInfo = (TimerInfo)msg.obj;
                if (timerInfo == null) break;
                WXJSObject obj = new WXJSObject(2, timerInfo.callbackId);
                WXJSObject[] args = new WXJSObject[]{obj};
                this.invokeExecJS("", null, METHOD_SET_TIMEOUT, args);
                break;
            }
        }
        return false;
    }

    private void invokeExecJS(String instanceId, String namespace, String function, WXJSObject[] args) {
        this.invokeExecJS(instanceId, namespace, function, args, true);
    }

    public void invokeExecJS(String instanceId, String namespace, String function, WXJSObject[] args, boolean logTaskDetail) {
        if (WXEnvironment.isApkDebugable()) {
            this.mLodBuilder.append("callJS >>>> instanceId:").append(instanceId).append("function:").append(function);
            if (logTaskDetail) {
                this.mLodBuilder.append(" tasks:").append(WXJsonUtils.fromObjectToJSONString(args));
            }
            WXLogUtils.d(this.mLodBuilder.substring(0));
            this.mLodBuilder.setLength(0);
        }
        this.mWXBridge.execJS(instanceId, namespace, function, args);
    }

    private void invokeInitFramework(Message msg) {
        String framework = "";
        if (msg.obj != null) {
            framework = (String)msg.obj;
        }
        if (WXUtils.getAvailMemory((Context)WXEnvironment.getApplication()) > LOW_MEM_VALUE) {
            this.initFramework(framework);
        }
    }

    private void initFramework(String framework) {
        if (!this.isJSFrameworkInit()) {
            if (TextUtils.isEmpty((CharSequence)framework)) {
                if (WXEnvironment.isApkDebugable()) {
                    WXLogUtils.d("weex JS framework from assets");
                }
                framework = WXFileUtils.loadAsset("main.js", (Context)WXEnvironment.getApplication());
            }
            if (TextUtils.isEmpty((CharSequence)framework)) {
                this.mInit = false;
                this.commitJSFrameworkAlarmMonitor("jsFramework", WXErrorCode.WX_ERR_JS_FRAMEWORK, "JS Framework is empty!");
                return;
            }
            try {
                long start = System.currentTimeMillis();
                if (this.mWXBridge.initFramework(framework, this.assembleDefaultOptions()) == 1) {
                    WXEnvironment.sJSLibInitTime = System.currentTimeMillis() - start;
                    WXLogUtils.renderPerformanceLog("initFramework", WXEnvironment.sJSLibInitTime);
                    WXEnvironment.sSDKInitTime = System.currentTimeMillis() - WXEnvironment.sSDKInitStart;
                    WXLogUtils.renderPerformanceLog("SDKInitTime", WXEnvironment.sSDKInitTime);
                    this.mInit = true;
                    this.execRegisterFailTask();
                    WXEnvironment.JsFrameworkInit = true;
                    this.registerDomModule();
                    this.commitJSFrameworkAlarmMonitor("jsFramework", WXErrorCode.WX_SUCCESS, "success");
                } else {
                    WXLogUtils.e("[WXBridgeManager] invokeInitFramework  ExecuteJavaScript fail");
                    String err = "[WXBridgeManager] invokeInitFramework  ExecuteJavaScript fail";
                    this.commitJSFrameworkAlarmMonitor("jsFramework", WXErrorCode.WX_ERR_JS_FRAMEWORK, err);
                }
            }
            catch (Throwable e) {
                WXLogUtils.e("[WXBridgeManager] invokeInitFramework ", e);
                String err = "[WXBridgeManager] invokeInitFramework exception!#" + e.toString();
                this.commitJSFrameworkAlarmMonitor("jsFramework", WXErrorCode.WX_ERR_JS_FRAMEWORK, err);
            }
        }
    }

    private void invokeCallJSBatch(Message message) {
        if (this.mNextTickTasks.isEmpty() || !this.isJSFrameworkInit()) {
            if (!this.isJSFrameworkInit()) {
                WXLogUtils.e("[WXBridgeManager] invokeCallJSBatch: framework.js uninitialized.");
            }
            return;
        }
        try {
            Object instanceId = message.obj;
            Object task = null;
            Stack<String> instanceStack = this.mNextTickTasks.getInstanceStack();
            int size = instanceStack.size();
            for (int i = size - 1; i >= 0 && ((task = this.mNextTickTasks.remove(instanceId = instanceStack.get(i))) == null || ((ArrayList)task).isEmpty()); --i) {
            }
            task = ((ArrayList)task).toArray();
            WXJSObject[] args = new WXJSObject[]{new WXJSObject(2, instanceId), new WXJSObject(3, WXJsonUtils.fromObjectToJSONString(task))};
            this.invokeExecJS(String.valueOf(instanceId), null, METHOD_CALL_JS, args);
        }
        catch (Throwable e) {
            WXLogUtils.e("WXBridgeManager", e);
            String err = "invokeCallJSBatch#" + e.toString();
            this.commitJSBridgeAlarmMonitor(message.obj.toString(), WXErrorCode.WX_ERR_JS_EXECUTE, err);
        }
        if (!this.mNextTickTasks.isEmpty()) {
            this.mJSHandler.sendEmptyMessage(6);
        }
    }

    private WXParams assembleDefaultOptions() {
        Map<String, String> config = WXEnvironment.getConfig();
        WXParams wxParams = new WXParams();
        wxParams.setPlatform(config.get("os"));
        wxParams.setOsVersion(config.get("sysVersion"));
        wxParams.setAppVersion(config.get("appVersion"));
        wxParams.setWeexVersion(config.get("weexVersion"));
        wxParams.setDeviceModel(config.get("sysModel"));
        wxParams.setShouldInfoCollect(config.get("infoCollect"));
        wxParams.setLogLevel(config.get("logLevel"));
        String appName = config.get("appName");
        if (!TextUtils.isEmpty((CharSequence)appName)) {
            wxParams.setAppName(appName);
        }
        wxParams.setDeviceWidth(TextUtils.isEmpty((CharSequence)config.get("deviceWidth")) ? String.valueOf(WXViewUtils.getScreenWidth((Context)WXEnvironment.sApplication)) : config.get("deviceWidth"));
        wxParams.setDeviceHeight(TextUtils.isEmpty((CharSequence)config.get("deviceHeight")) ? String.valueOf(WXViewUtils.getScreenHeight((Context)WXEnvironment.sApplication)) : config.get("deviceHeight"));
        wxParams.setOptions(WXEnvironment.getCustomOptions());
        return wxParams;
    }

    private void execRegisterFailTask() {
        ArrayList<Map<String, Object>> receiver;
        if (this.mRegisterModuleFailList.size() > 0) {
            ArrayList<Map<String, Object>> moduleReceiver = new ArrayList<Map<String, Object>>();
            int moduleCount = this.mRegisterModuleFailList.size();
            for (int i = 0; i < moduleCount; ++i) {
                this.invokeRegisterModules(this.mRegisterModuleFailList.get(i), moduleReceiver);
            }
            this.mRegisterComponentFailList.clear();
            if (moduleReceiver.size() > 0) {
                this.mRegisterComponentFailList.addAll(moduleReceiver);
            }
        }
        if (this.mRegisterComponentFailList.size() > 0) {
            receiver = new ArrayList<Map<String, Object>>();
            this.invokeRegisterComponents(this.mRegisterComponentFailList, receiver);
            this.mRegisterComponentFailList.clear();
            if (receiver.size() > 0) {
                this.mRegisterComponentFailList.addAll(receiver);
            }
        }
        if (this.mRegisterServiceFailList.size() > 0) {
            receiver = new ArrayList();
            for (String service : this.mRegisterServiceFailList) {
                this.invokeExecJSService(service, receiver);
            }
            this.mRegisterServiceFailList.clear();
            if (receiver.size() > 0) {
                this.mRegisterServiceFailList.addAll(receiver);
            }
        }
    }

    public void registerModules(final Map<String, Object> modules) {
        if (modules != null && modules.size() != 0) {
            if (this.isJSThread()) {
                this.invokeRegisterModules(modules, this.mRegisterModuleFailList);
            } else {
                this.post(new Runnable(){

                    @Override
                    public void run() {
                        WXBridgeManager.this.invokeRegisterModules(modules, WXBridgeManager.this.mRegisterComponentFailList);
                    }
                }, null);
            }
        }
    }

    public void registerComponents(final List<Map<String, Object>> components) {
        if (this.mJSHandler == null || components == null || components.size() == 0) {
            return;
        }
        this.post(new Runnable(){

            @Override
            public void run() {
                WXBridgeManager.this.invokeRegisterComponents(components, WXBridgeManager.this.mRegisterComponentFailList);
            }
        }, null);
    }

    public void execJSService(final String service) {
        this.post(new Runnable(){

            @Override
            public void run() {
                WXBridgeManager.this.invokeExecJSService(service, WXBridgeManager.this.mRegisterServiceFailList);
            }
        });
    }

    private void invokeExecJSService(String service, List<String> receiver) {
        try {
            if (!this.isJSFrameworkInit()) {
                WXLogUtils.e("[WXBridgeManager] invoke execJSService: framework.js uninitialized.");
                receiver.add(service);
                return;
            }
            this.mWXBridge.execJSService(service);
        }
        catch (Throwable e) {
            WXLogUtils.e("[WXBridgeManager] invokeRegisterService:", e);
            this.commitJSFrameworkAlarmMonitor("jsFramework", WXErrorCode.WX_ERR_JS_EXECUTE, "invokeRegisterService");
        }
    }

    private boolean isJSThread() {
        return this.mJSThread != null && this.mJSThread.getId() == Thread.currentThread().getId();
    }

    private void invokeRegisterModules(Map<String, Object> modules, List<Map<String, Object>> failReceiver) {
        if (modules == null || !this.isJSFrameworkInit()) {
            if (!this.isJSFrameworkInit()) {
                WXLogUtils.e("[WXBridgeManager] invokeCallJSBatch: framework.js uninitialized.");
            }
            failReceiver.add(modules);
            return;
        }
        WXJSObject[] args = new WXJSObject[]{new WXJSObject(3, WXJsonUtils.fromObjectToJSONString(modules))};
        try {
            this.mWXBridge.execJS("", null, METHOD_REGISTER_MODULES, args);
        }
        catch (Throwable e) {
            WXLogUtils.e("[WXBridgeManager] invokeRegisterModules:", e);
            this.commitJSFrameworkAlarmMonitor("jsFramework", WXErrorCode.WX_ERR_JS_EXECUTE, "invokeRegisterModules");
        }
    }

    private void invokeRegisterComponents(List<Map<String, Object>> components, List<Map<String, Object>> failReceiver) {
        if (components == failReceiver) {
            throw new RuntimeException("Fail receiver should not use source.");
        }
        if (!this.isJSFrameworkInit()) {
            WXLogUtils.e("[WXBridgeManager] invokeCallJSBatch: framework.js uninitialized.");
            for (Map<String, Object> comp : components) {
                failReceiver.add(comp);
            }
            return;
        }
        if (components == null) {
            return;
        }
        WXJSObject[] args = new WXJSObject[]{new WXJSObject(3, WXJsonUtils.fromObjectToJSONString(components))};
        try {
            this.mWXBridge.execJS("", null, METHOD_REGISTER_COMPONENTS, args);
        }
        catch (Throwable e) {
            WXLogUtils.e("[WXBridgeManager] invokeRegisterComponents ", e);
            this.commitJSFrameworkAlarmMonitor("jsFramework", WXErrorCode.WX_ERR_JS_EXECUTE, "invokeRegisterComponents");
        }
    }

    public void destroy() {
        if (this.mJSThread != null) {
            this.mJSThread.quit();
        }
        mBridgeManager = null;
        if (this.mDestroyedInstanceId != null) {
            this.mDestroyedInstanceId.clear();
        }
    }

    public void reportJSException(String instanceId, String function, String exception) {
        WXSDKInstance instance;
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.e("reportJSException >>>> instanceId:" + instanceId + ", exception function:" + function + ", exception:" + exception);
        }
        if (instanceId != null && (instance = WXSDKManager.getInstance().getSDKInstance(instanceId)) != null) {
            instance.onJSException(WXErrorCode.WX_ERR_JS_EXECUTE.getErrorCode(), function, exception);
            String err = "function:" + function + "#exception:" + exception;
            this.commitJSBridgeAlarmMonitor(instanceId, WXErrorCode.WX_ERR_JS_EXECUTE, err);
            IWXJSExceptionAdapter adapter = WXSDKManager.getInstance().getIWXJSExceptionAdapter();
            if (adapter != null) {
                WXJSExceptionInfo jsException = new WXJSExceptionInfo(instanceId, instance.getBundleUrl(), WXErrorCode.WX_ERR_JS_EXECUTE.getErrorCode(), function, exception, null);
                adapter.onJSException(jsException);
                if (WXEnvironment.isApkDebugable()) {
                    WXLogUtils.d(jsException.toString());
                }
            }
        }
    }

    private void registerDomModule() throws WXException {
        HashMap<String, Object> domMap = new HashMap<String, Object>();
        domMap.put("dom", WXDomModule.METHODS);
        this.registerModules(domMap);
    }

    @Deprecated
    public void notifyTrimMemory() {
    }

    @Nullable
    public Looper getJSLooper() {
        Looper ret = null;
        if (this.mJSThread != null) {
            ret = this.mJSThread.getLooper();
        }
        return ret;
    }

    public static class TimerInfo {
        public String callbackId;
        public long time;
        public String instanceId;
    }
}

