/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.appfram.pickers;

import android.content.DialogInterface;
import android.support.annotation.Nullable;
import android.support.v7.app.AlertDialog;
import com.taobao.weex.annotation.JSMethod;
import com.taobao.weex.appfram.pickers.DatePickerImpl;
import com.taobao.weex.bridge.JSCallback;
import com.taobao.weex.common.WXModule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WXPickersModule
extends WXModule {
    private static final String SUCCESS = "success";
    private static final String CANCEL = "cancel";
    private static final String ERROR = "error";
    private static final String RESULT = "result";
    private static final String DATA = "data";
    private static final String KEY_VALUE = "value";
    private static final String KEY_INDEX = "index";
    private static final String KEY_TITLE = "title";
    private static final String KEY_MAX = "max";
    private static final String KEY_MIN = "min";
    private static final String KEY_ITEMS = "items";
    private int selected;

    @JSMethod
    public void pick(Map<String, Object> options, JSCallback callback) {
        List<String> items = this.safeConvert(this.getOption(options, KEY_ITEMS, new ArrayList()));
        int index = this.getOption(options, KEY_INDEX, 0);
        String title = this.getOption(options, KEY_TITLE, null);
        this.performSinglePick(items, index, title, callback);
    }

    @JSMethod
    public void pickDate(Map<String, Object> options, JSCallback callback) {
        this.performPickDate(options, callback);
    }

    @JSMethod
    public void pickTime(Map<String, Object> options, JSCallback callback) {
        this.performPickTime(options, callback);
    }

    private List<String> safeConvert(List src) {
        ArrayList<String> result = new ArrayList<String>(src.size());
        for (Object obj : src) {
            result.add(String.valueOf(obj));
        }
        return result;
    }

    private <T> T getOption(Map<String, Object> options, String key, T defValue) {
        Object value = options.get(key);
        if (value == null) {
            return defValue;
        }
        try {
            return (T)value;
        }
        catch (Exception e) {
            e.printStackTrace();
            return defValue;
        }
    }

    private void performPickTime(Map<String, Object> options, final JSCallback callback) {
        String value = this.getOption(options, KEY_VALUE, "");
        DatePickerImpl.pickTime(this.mWXSDKInstance.getContext(), value, new DatePickerImpl.OnPickListener(){

            @Override
            public void onPick(boolean set, @Nullable String result) {
                if (set) {
                    HashMap<String, String> ret = new HashMap<String, String>(2);
                    ret.put(WXPickersModule.RESULT, WXPickersModule.SUCCESS);
                    ret.put(WXPickersModule.DATA, result);
                    callback.invoke(ret);
                } else {
                    HashMap<String, String> ret = new HashMap<String, String>(2);
                    ret.put(WXPickersModule.RESULT, WXPickersModule.CANCEL);
                    ret.put(WXPickersModule.DATA, null);
                    callback.invoke(ret);
                }
            }
        });
    }

    private void performPickDate(Map<String, Object> options, final JSCallback callback) {
        String value = this.getOption(options, KEY_VALUE, "");
        String max = this.getOption(options, KEY_MAX, "");
        String min = this.getOption(options, KEY_MIN, "");
        DatePickerImpl.pickDate(this.mWXSDKInstance.getContext(), value, max, min, new DatePickerImpl.OnPickListener(){

            @Override
            public void onPick(boolean set, @Nullable String result) {
                if (set) {
                    HashMap<String, String> ret = new HashMap<String, String>(2);
                    ret.put(WXPickersModule.RESULT, WXPickersModule.SUCCESS);
                    ret.put(WXPickersModule.DATA, result);
                    callback.invoke(ret);
                } else {
                    HashMap<String, String> ret = new HashMap<String, String>(2);
                    ret.put(WXPickersModule.RESULT, WXPickersModule.CANCEL);
                    ret.put(WXPickersModule.DATA, null);
                    callback.invoke(ret);
                }
            }
        });
    }

    private void performSinglePick(List<String> items, int checked, String title, final JSCallback callback) {
        this.selected = checked;
        new AlertDialog.Builder(this.mWXSDKInstance.getContext()).setTitle((CharSequence)title).setSingleChoiceItems((CharSequence[])items.toArray(new String[items.size()]), checked, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                WXPickersModule.this.selected = which;
            }
        }).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                HashMap<String, Object> ret = new HashMap<String, Object>(2);
                ret.put(WXPickersModule.RESULT, WXPickersModule.SUCCESS);
                ret.put(WXPickersModule.DATA, WXPickersModule.this.selected);
                callback.invoke(ret);
            }
        }).setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                HashMap<String, Object> ret = new HashMap<String, Object>(2);
                ret.put(WXPickersModule.RESULT, WXPickersModule.CANCEL);
                ret.put(WXPickersModule.DATA, -1);
                callback.invoke(ret);
            }
        }).show();
    }
}

